/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.smartcardhsmprovider;

import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMPrivateKey;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import opencard.opt.security.PrivateKeyRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartCardHSMSignature
extends SignatureSpi {
    private static final Logger log = LoggerFactory.getLogger(SmartCardHSMSignature.class);
    private static boolean SIGN_STATE;
    protected SmartCardHSMCardService schsm;
    protected SmartCardHSMPrivateKey privateKey;
    private String digestAlgorithm;
    protected String signAlgorithm;
    private String padAlgorithm;
    private MessageDigest digest;

    public SmartCardHSMSignature(SmartCardHSMProvider provider, String digestAlgorithm, String signAlgorithm, String padAlgorithm) {
        this.schsm = provider.getSmartCardHSMCardService();
        this.digestAlgorithm = digestAlgorithm;
        this.signAlgorithm = signAlgorithm;
        this.padAlgorithm = padAlgorithm;
        if (!provider.isVerified()) {
            throw new ProviderException("Login required.");
        }
    }

    @Override
    protected Object engineGetParameter(String arg0) throws InvalidParameterException {
        return null;
    }

    @Override
    protected void engineInitSign(PrivateKey key) throws InvalidKeyException {
        log.trace("SmartCardHSMSignature.engineInitSign");
        SIGN_STATE = true;
        if (!(key instanceof SmartCardHSMPrivateKey)) {
            throw new InvalidKeyException("The key is not type of SmartCardHSMPrivateKey");
        }
        this.privateKey = (SmartCardHSMPrivateKey)key;
        try {
            this.digest = MessageDigest.getInstance(this.digestAlgorithm);
        }
        catch (NoSuchAlgorithmException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
    }

    @Override
    protected void engineInitVerify(PublicKey arg0) throws InvalidKeyException {
        throw new RuntimeException("engineInitVerify() is not supported");
    }

    @Override
    protected void engineSetParameter(String arg0, Object arg1) throws InvalidParameterException {
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] md = this.digest.digest();
        byte[] signature = null;
        try {
            signature = this.schsm.signHash((PrivateKeyRef)this.privateKey, this.signAlgorithm, this.padAlgorithm, md);
        }
        catch (CardServiceException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        catch (CardTerminalException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        return signature;
    }

    @Override
    protected void engineUpdate(byte arg0) throws SignatureException {
        log.trace("SmartCardHSMSignature.engineUpdate()");
        if (SIGN_STATE) {
            this.digest.update(arg0);
        }
    }

    @Override
    protected void engineUpdate(byte[] arg0, int arg1, int arg2) throws SignatureException {
        log.trace("SmartCardHSMSignature.engineUpdate()");
        if (SIGN_STATE) {
            this.digest.update(arg0, arg1, arg2);
        }
    }

    @Override
    protected boolean engineVerify(byte[] arg0) throws SignatureException {
        log.trace("SmartCardHSMSignature.engineVerify");
        throw new RuntimeException("engineVerify() is not supported");
    }

    protected static class SHA512withECDSA
    extends SmartCardHSMSignature {
        public SHA512withECDSA(SmartCardHSMProvider provider, String algorithm) {
            super(provider, "SHA-512", "NONEwithECDSA", "NONE");
        }
    }

    protected static class SHA384withECDSA
    extends SmartCardHSMSignature {
        public SHA384withECDSA(SmartCardHSMProvider provider, String algorithm) {
            super(provider, "SHA-384", "NONEwithECDSA", "NONE");
        }
    }

    protected static class SHA256withECDSA
    extends SmartCardHSMSignature {
        public SHA256withECDSA(SmartCardHSMProvider provider, String algorithm) {
            super(provider, "SHA-256", "NONEwithECDSA", "NONE");
        }
    }

    protected static class SHA224withECDSA
    extends SmartCardHSMSignature {
        public SHA224withECDSA(SmartCardHSMProvider provider, String algorithm) {
            super(provider, "SHA-224", "NONEwithECDSA", "NONE");
        }
    }

    protected static class SHA1withECDSA
    extends SmartCardHSMSignature {
        public SHA1withECDSA(SmartCardHSMProvider provider, String algorithm) {
            super(provider, "SHA1", "NONEwithECDSA", "NONE");
        }
    }

    protected static class NONEwithECDSA
    extends SmartCardHSMSignature {
        private ByteArrayOutputStream md;

        public NONEwithECDSA(SmartCardHSMProvider provider, String algorithm) {
            super(provider, "", "NONEwithECDSA", "NONE");
            log.debug("NONEwithECDSA");
        }

        @Override
        protected void engineUpdate(byte arg0) throws SignatureException {
            if (SIGN_STATE) {
                this.md.write(arg0);
            }
        }

        @Override
        protected void engineUpdate(byte[] arg0, int arg1, int arg2) throws SignatureException {
            if (SIGN_STATE) {
                this.md.write(arg0, arg1, arg2);
            }
        }

        @Override
        protected void engineInitSign(PrivateKey key) throws InvalidKeyException {
            log.debug("Initialized for signature...");
            SIGN_STATE = true;
            this.privateKey = (SmartCardHSMPrivateKey)key;
            this.md = new ByteArrayOutputStream();
        }

        @Override
        protected byte[] engineSign() throws SignatureException {
            byte[] signature = null;
            try {
                signature = this.schsm.signHash((PrivateKeyRef)this.privateKey, this.signAlgorithm, this.md.toByteArray());
            }
            catch (CardServiceException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new ProviderException(e);
            }
            catch (CardTerminalException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new ProviderException(e);
            }
            catch (InvalidKeyException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new ProviderException(e);
            }
            return signature;
        }
    }

    protected static class NONEwithRSA
    extends SmartCardHSMSignature {
        private ByteArrayOutputStream md;

        public NONEwithRSA(SmartCardHSMProvider provider, String algorithm) {
            super(provider, "", "NONEwithRSA", "PKCS1_V15");
            log.debug("NONEwithRSA");
        }

        @Override
        protected void engineUpdate(byte arg0) throws SignatureException {
            if (SIGN_STATE) {
                this.md.write(arg0);
            }
        }

        @Override
        protected void engineUpdate(byte[] arg0, int arg1, int arg2) throws SignatureException {
            if (SIGN_STATE) {
                this.md.write(arg0, arg1, arg2);
            }
        }

        @Override
        protected void engineInitSign(PrivateKey key) throws InvalidKeyException {
            log.debug("Initialized for signature...");
            SIGN_STATE = true;
            this.privateKey = (SmartCardHSMPrivateKey)key;
            this.md = new ByteArrayOutputStream();
        }

        @Override
        protected byte[] engineSign() throws SignatureException {
            byte[] signature = null;
            try {
                signature = this.schsm.signHash((PrivateKeyRef)this.privateKey, this.signAlgorithm, this.md.toByteArray());
            }
            catch (CardServiceException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new ProviderException(e);
            }
            catch (CardTerminalException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new ProviderException(e);
            }
            catch (InvalidKeyException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new ProviderException(e);
            }
            return signature;
        }
    }

    protected static class SHA512withRSAPKCS1PSS
    extends SmartCardHSMSignature {
        public SHA512withRSAPKCS1PSS(SmartCardHSMProvider provider, String algorithm) {
            super(provider, "SHA512", "SHA512withRSA", "PKCS1_PSS");
        }
    }

    protected static class SHA384withRSAPKCS1PSS
    extends SmartCardHSMSignature {
        public SHA384withRSAPKCS1PSS(SmartCardHSMProvider provider, String algorithm) {
            super(provider, "SHA384", "SHA384withRSA", "PKCS1_PSS");
        }
    }

    protected static class SHA256withRSAPKCS1PSS
    extends SmartCardHSMSignature {
        public SHA256withRSAPKCS1PSS(SmartCardHSMProvider provider, String algorithm) {
            super(provider, "SHA256", "SHA256withRSA", "PKCS1_PSS");
        }
    }

    protected static class SHA1withRSAPKCS1PSS
    extends SmartCardHSMSignature {
        public SHA1withRSAPKCS1PSS(SmartCardHSMProvider provider, String algorithm) {
            super(provider, "SHA1", "SHA1withRSA", "PKCS1_PSS");
        }
    }

    protected static class SHA512withRSAPKCS1V15
    extends SmartCardHSMSignature {
        public SHA512withRSAPKCS1V15(SmartCardHSMProvider provider, String algorithm) {
            super(provider, "SHA512", "SHA512withRSA", "PKCS1_V15");
        }
    }

    protected static class SHA384withRSAPKCS1V15
    extends SmartCardHSMSignature {
        public SHA384withRSAPKCS1V15(SmartCardHSMProvider provider, String algorithm) {
            super(provider, "SHA384", "SHA384withRSA", "PKCS1_V15");
        }
    }

    protected static class SHA256withRSAPKCS1V15
    extends SmartCardHSMSignature {
        public SHA256withRSAPKCS1V15(SmartCardHSMProvider provider, String algorithm) {
            super(provider, "SHA256", "SHA256withRSA", "PKCS1_V15");
        }
    }

    protected static class SHA1withRSAPKCS1V15
    extends SmartCardHSMSignature {
        public SHA1withRSAPKCS1V15(SmartCardHSMProvider provider, String algorithm) {
            super(provider, "SHA1", "SHA1withRSA", "PKCS1_V15");
        }
    }
}

