/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.smartcardhsmprovider;

import de.cardcontact.opencard.service.smartcardhsm.CertificateDescription;
import de.cardcontact.opencard.service.smartcardhsm.KeyDescription;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMEntry;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMRSAKey;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import de.cardcontact.tlv.TLVEncodingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import opencard.core.OpenCardException;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.HexString;
import opencard.opt.iso.fs.CardFilePath;
import opencard.opt.iso.fs.CardIOException;
import opencard.opt.service.CardServiceResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartCardHSMKeyStore
extends KeyStoreSpi {
    private static final Logger log = LoggerFactory.getLogger(SmartCardHSMKeyStore.class);
    private SmartCardHSMProvider provider;
    private Vector<String> aliases;

    public SmartCardHSMKeyStore(SmartCardHSMProvider provider, String algorithm) {
        this.provider = provider;
    }

    @Override
    public Enumeration<String> engineAliases() {
        SmartCardHSMCardService schsm = this.provider.getSmartCardHSMCardService();
        try {
            this.aliases = schsm.getAliases();
        }
        catch (OpenCardException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        catch (CertificateException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        catch (TLVEncodingException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        return this.aliases.elements();
    }

    @Override
    public boolean engineContainsAlias(String alias) {
        SmartCardHSMCardService schsm = this.provider.getSmartCardHSMCardService();
        return schsm.containsLabel(alias);
    }

    @Override
    public void engineDeleteEntry(String alias) throws KeyStoreException {
        if (!this.provider.isVerified()) {
            throw new ProviderException("Login required.");
        }
        SmartCardHSMCardService schsm = this.provider.getSmartCardHSMCardService();
        try {
            schsm.removeEntry(alias);
        }
        catch (CardServiceResourceNotFoundException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new KeyStoreException(alias + " not found.");
        }
        catch (CardTerminalException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        catch (CardIOException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        catch (CardServiceException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
    }

    @Override
    public Certificate engineGetCertificate(String alias) {
        SmartCardHSMCardService schsm = this.provider.getSmartCardHSMCardService();
        SmartCardHSMEntry entry = schsm.getSmartCardHSMEntry(alias);
        if (entry == null) {
            return null;
        }
        return entry.getCert();
    }

    @Override
    public String engineGetCertificateAlias(Certificate arg0) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Certificate[] engineGetCertificateChain(String alias) {
        return new Certificate[]{this.engineGetCertificate(alias)};
    }

    @Override
    public Date engineGetCreationDate(String alias) {
        return new Date();
    }

    @Override
    public Key engineGetKey(String alias, char[] password) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        SmartCardHSMCardService schsm = this.provider.getSmartCardHSMCardService();
        SmartCardHSMEntry entry = null;
        if (password != null && password.length > 0) {
            String pw = "";
            for (int i = 0; i < password.length; ++i) {
                pw = pw + password[i];
            }
            try {
                boolean verified = schsm.verifyPassword(null, 0, pw.getBytes());
            }
            catch (CardServiceException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new ProviderException(e);
            }
            catch (CardTerminalException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new ProviderException(e);
            }
        }
        if ((entry = schsm.getSmartCardHSMEntry(alias)) == null) {
            throw new UnrecoverableKeyException("No key found.");
        }
        return entry.getKey();
    }

    @Override
    public boolean engineIsCertificateEntry(String alias) {
        SmartCardHSMCardService schsm = this.provider.getSmartCardHSMCardService();
        SmartCardHSMEntry entry = schsm.getSmartCardHSMEntry(alias);
        if (entry == null) {
            return false;
        }
        return !entry.isEECertificate();
    }

    @Override
    public boolean engineIsKeyEntry(String alias) {
        SmartCardHSMCardService schsm = this.provider.getSmartCardHSMCardService();
        SmartCardHSMEntry entry = schsm.getSmartCardHSMEntry(alias);
        if (entry == null) {
            return false;
        }
        return entry.isKeyEntry();
    }

    @Override
    public void engineLoad(InputStream stream, char[] password) throws IOException, NoSuchAlgorithmException, CertificateException {
        String pwd;
        boolean verified;
        SmartCardHSMCardService schsm = this.provider.getSmartCardHSMCardService();
        if (password != null && !(verified = schsm.verifyPassword(null, 0, (pwd = new String(password)).getBytes()))) {
            log.error("Login failed. Wrong PIN?");
            throw new IOException("Login failed. Wrong PIN?");
        }
        try {
            this.aliases = schsm.getAliases();
        }
        catch (TLVEncodingException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
    }

    @Override
    public void engineSetCertificateEntry(String alias, Certificate cert) throws KeyStoreException {
        SmartCardHSMCardService schsm = this.provider.getSmartCardHSMCardService();
        SmartCardHSMEntry entry = schsm.getSmartCardHSMEntry(alias);
        if (!this.provider.isVerified()) {
            throw new ProviderException("Login required.");
        }
        try {
            if (entry != null) {
                SmartCardHSMKey key = entry.getKey();
                if (key != null) {
                    String path = ":CE" + HexString.hexify((int)key.getKeyRef());
                    CardFilePath file = new CardFilePath(path);
                    schsm.write(file, 0, cert.getEncoded());
                    schsm.addCertToMap(cert, true, key.getKeyRef(), alias);
                } else {
                    byte id = entry.getId();
                    String path = ":CA" + HexString.hexify((int)id);
                    CardFilePath file = new CardFilePath(path);
                    schsm.write(file, 0, cert.getEncoded());
                    schsm.addCertToMap(cert, false, id, alias);
                }
            } else {
                byte id = schsm.determineFreeCAId();
                if (id == -1) {
                    throw new KeyStoreException("Storage limit for CA Certificates reached.");
                }
                String path = ":CA" + HexString.hexify((int)id);
                CardFilePath file = new CardFilePath(path);
                schsm.write(file, 0, cert.getEncoded());
                path = ":C8" + HexString.hexify((int)id);
                file = new CardFilePath(path);
                schsm.write(file, 0, CertificateDescription.buildCertDescription((String)alias, (PublicKey)cert.getPublicKey(), (byte[])new byte[]{-54, id}));
                schsm.addCertToMap(cert, false, id, alias);
            }
        }
        catch (OpenCardException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        catch (CertificateException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        catch (TLVEncodingException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
    }

    @Override
    public void engineSetKeyEntry(String alias, byte[] key, Certificate[] chain) throws KeyStoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineSetKeyEntry(String alias, Key key, char[] password, Certificate[] chain) throws KeyStoreException {
        SmartCardHSMKey skey = (SmartCardHSMKey)key;
        SmartCardHSMCardService schsm = this.provider.getSmartCardHSMCardService();
        if (!this.provider.isVerified()) {
            throw new ProviderException("Login required.");
        }
        String oldlabel = skey.getLabel();
        skey.setLabel(alias);
        try {
            byte[] id = new byte[]{skey.getKeyRef()};
            KeyDescription prkd = key instanceof SmartCardHSMRSAKey ? new KeyDescription(id, alias, (int)skey.getKeySize(), KeyDescription.KeyTypes.RSA) : new KeyDescription(id, alias, (int)skey.getKeySize(), KeyDescription.KeyTypes.EC);
            schsm.storePRKD(skey.getKeyRef(), prkd);
            if (oldlabel != null) {
                schsm.renameEntry(oldlabel, alias);
            } else {
                schsm.addKeyToMap(skey);
            }
            if (chain.length >= 1) {
                String path = ":CE" + HexString.hexify((int)skey.getKeyRef());
                CardFilePath file = new CardFilePath(path);
                schsm.write(file, 0, chain[0].getEncoded());
                schsm.addCertToMap(chain[0], true, skey.getKeyRef(), alias);
            }
        }
        catch (CardServiceException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        catch (CardTerminalException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
        catch (CertificateEncodingException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
    }

    @Override
    public int engineSize() {
        SmartCardHSMCardService schsm = this.provider.getSmartCardHSMCardService();
        try {
            Vector aliases = schsm.getAliases();
            return aliases.size();
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            return 0;
        }
    }

    @Override
    public void engineStore(OutputStream arg0, char[] arg1) throws IOException, NoSuchAlgorithmException, CertificateException {
    }
}

