/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.smartcardhsmprovider;

import de.cardcontact.opencard.factory.GlobalPlatformCardServiceFactory;
import de.cardcontact.opencard.factory.IsoCardServiceFactory;
import de.cardcontact.opencard.factory.RemoteClientCardServiceFactory;
import de.cardcontact.opencard.factory.SmartCardHSMCardServiceFactory;
import de.cardcontact.opencard.service.StatusWordTable;
import de.cardcontact.opencard.service.remoteclient.RemoteClientCardService;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.terminal.smartcardio.SmartCardIOFactory;
import de.cardcontact.smartcardhsmprovider.OCFCallback;
import de.cardcontact.smartcardhsmprovider.PublicKeyAuthenticationCallback;
import de.cardcontact.tlv.HexString;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.AuthProvider;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.security.cert.CertPathBuilderException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import opencard.core.OpenCardException;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.event.EventGenerator;
import opencard.core.service.CHVDialog;
import opencard.core.service.CardRequest;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceRegistry;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.APDUFormatter;
import opencard.core.util.APDUTracer;
import opencard.core.util.OpenCardPropertyLoadingException;
import opencard.opt.util.PassThruCardServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SmartCardHSMProvider
extends AuthProvider
implements CTListener,
APDUTracer {
    private static final long serialVersionUID = 4737690040987973156L;
    private static final Logger log = LoggerFactory.getLogger(SmartCardHSMProvider.class);
    private static String PROVIDER_NAME = "SmartCardHSM";
    private static double VERSION = 1.0;
    private static String INFO = "SmartCardHSM provider implementing x";
    private boolean doSecureMessaging = true;
    private int doOCFShutdown = 0;
    private boolean usePinPad = false;
    private boolean usePKACallback = false;
    private SmartCard sc = null;
    private String terminalName = null;
    private CardTerminal ct = null;
    private int slotID = 0;
    private SmartCardHSMCardService schsm;
    private PasswordCallback passwordCallback;
    private PublicKeyAuthenticationCallback pkaCallback;
    private CallbackHandler callBackHandler = null;

    public SmartCardHSMProvider() {
        super(PROVIDER_NAME, VERSION, INFO);
        log.debug("Super constructor called...");
        this.initProviderProperties();
        try {
            this.register();
        }
        catch (Exception e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
    }

    public SmartCardHSMProvider(String name, boolean handleEvents) {
        super(PROVIDER_NAME + "/" + name, VERSION, INFO);
        log.debug("Super constructor called...");
        this.terminalName = name;
        this.initProviderProperties();
        if (handleEvents) {
            try {
                this.register();
            }
            catch (Exception e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new ProviderException(e);
            }
        }
    }

    public SmartCardHSMProvider(String name) {
        this(name, true);
    }

    public static void removeProviders() {
        Provider[] providers;
        for (Provider provider : providers = Security.getProviders()) {
            if (!provider.getName().startsWith(PROVIDER_NAME)) continue;
            SmartCardHSMProvider scprov = (SmartCardHSMProvider)provider;
            scprov.unregister();
            Security.removeProvider(scprov.getName());
        }
    }

    public boolean isVerified() {
        boolean status = false;
        if (this.schsm == null) {
            return false;
        }
        try {
            status = this.schsm.getSecurityStatus();
        }
        catch (CardServiceException cardServiceException) {
        }
        catch (CardTerminalException cardTerminalException) {
            // empty catch block
        }
        if (!status) {
            status = this.verify();
        }
        return status;
    }

    private boolean verify() {
        if (this.schsm == null) {
            throw new ProviderException("CardService not initialized");
        }
        if (this.callBackHandler != null) {
            try {
                log.debug("Get password callback from application");
                if (this.usePKACallback) {
                    this.callBackHandler.handle(new Callback[]{this.passwordCallback, this.pkaCallback});
                } else {
                    this.callBackHandler.handle(new Callback[]{this.passwordCallback});
                }
            }
            catch (IOException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new ProviderException(e);
            }
            catch (UnsupportedCallbackException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new ProviderException(e);
            }
            if (this.passwordCallback.getPassword() != null) {
                this.schsm.setCHVDialog((CHVDialog)new OCFCallback(this.passwordCallback));
                try {
                    return this.schsm.verifyPassword();
                }
                catch (OpenCardException e) {
                    log.error(e.getLocalizedMessage(), (Throwable)e);
                    throw new ProviderException(e);
                }
            }
            if (this.pkaCallback.getUrl() != null) {
                try {
                    RemoteClientCardService rc = (RemoteClientCardService)this.sc.getCardService(RemoteClientCardService.class, true);
                    rc.update(this.pkaCallback.getUrl(), null, null);
                    return this.schsm.getSecurityStatus();
                }
                catch (Exception e) {
                    log.error(e.getLocalizedMessage(), (Throwable)e);
                    throw new ProviderException(e);
                }
            }
            throw new ProviderException("Neither a password nor an URL to an authentication server was configured");
        }
        try {
            return this.schsm.verifyPassword();
        }
        catch (OpenCardException e) {
            log.error(e.getLocalizedMessage(), (Throwable)e);
            throw new ProviderException(e);
        }
    }

    public void setSecureMessaging(boolean doSecureMessaging) {
        this.doSecureMessaging = doSecureMessaging;
    }

    public void useTerminalPinPad(boolean usePinPad) {
        this.usePinPad = usePinPad;
    }

    public void usePKACallback(boolean usePKACallback) {
        this.usePKACallback = usePKACallback;
    }

    private void initProviderProperties() {
        this.passwordCallback = new PasswordCallback("SmartCardHSMPasswordCallback", false);
        this.pkaCallback = new PublicKeyAuthenticationCallback();
        log.debug("Initializing provider algorithms...");
        this.putService(new SCHSMService(this, "SecureRandom", "NativePRNG", "de.cardcontact.smartcardhsmprovider.SecureRandom"));
        this.putService(new SCHSMService(this, "KeyGenerator", "AES", "de.cardcontact.smartcardhsmprovider.KeyGenerator"));
        Vector<String> alias = new Vector<String>();
        alias.addElement("RSA");
        this.putService(new KeyPairGenService(this, "KeyPairGenerator", "RSA//PKCS1-v1-5-SHA-1", "de.cardcontact.smartcardhsmprovider.KeyPairGenerator$RSA", alias));
        this.putService(new KeyPairGenService(this, "KeyPairGenerator", "RSA//PKCS1-v1-5-SHA-256", "de.cardcontact.smartcardhsmprovider.KeyPairGenerator$RSA"));
        this.putService(new KeyPairGenService(this, "KeyPairGenerator", "RSA//PKCS1-PSS-SHA-1", "de.cardcontact.smartcardhsmprovider.KeyPairGenerator$RSA"));
        this.putService(new KeyPairGenService(this, "KeyPairGenerator", "RSA//PKCS1-PSS-SHA-256", "de.cardcontact.smartcardhsmprovider.KeyPairGenerator$RSA"));
        alias = new Vector();
        alias.addElement("EC");
        this.putService(new KeyPairGenService(this, "KeyPairGenerator", "EC//ECDSA-SHA-1", "de.cardcontact.smartcardhsmprovider.KeyPairGenerator$EC", alias));
        this.putService(new KeyPairGenService(this, "KeyPairGenerator", "EC//ECDSA-SHA-224", "de.cardcontact.smartcardhsmprovider.KeyPairGenerator$EC"));
        this.putService(new KeyPairGenService(this, "KeyPairGenerator", "EC//ECDSA-SHA-256", "de.cardcontact.smartcardhsmprovider.KeyPairGenerator$EC"));
        this.put("AlgorithmParameters.EC SupportedCurves", "secp192r1,prime192v1,secp256r1,prime256v1,brainpoolP192r1,brainpoolP224r1,brainpoolP256r1,brainpoolP320r1,secp192k1,secp256k1");
        alias = new Vector();
        alias.addElement("SHA1withRSA");
        this.putService(new SCHSMService(this, "Signature", "SHA1withRSA//PKCS1-v1-5", "de.cardcontact.smartcardhsmprovider.SmartCardHSMSignature$SHA1withRSAPKCS1V15", alias));
        alias = new Vector();
        alias.addElement("SHA256withRSA");
        this.putService(new SCHSMService(this, "Signature", "SHA256withRSA//PKCS1-v1-5", "de.cardcontact.smartcardhsmprovider.SmartCardHSMSignature$SHA256withRSAPKCS1V15", alias));
        alias = new Vector();
        alias.addElement("SHA1withRSA/PSS");
        this.putService(new SCHSMService(this, "Signature", "SHA1withRSA//PKCS1-PSS", "de.cardcontact.smartcardhsmprovider.SmartCardHSMSignature$SHA1withRSAPKCS1PSS", alias));
        alias = new Vector();
        alias.addElement("SHA256withRSA/PSS");
        this.putService(new SCHSMService(this, "Signature", "SHA256withRSA//PKCS1-PSS", "de.cardcontact.smartcardhsmprovider.SmartCardHSMSignature$SHA256withRSAPKCS1PSS", alias));
        this.putService(new SCHSMService(this, "Signature", "SHA1withECDSA", "de.cardcontact.smartcardhsmprovider.SmartCardHSMSignature$SHA1withECDSA"));
        this.putService(new SCHSMService(this, "Signature", "SHA224withECDSA", "de.cardcontact.smartcardhsmprovider.SmartCardHSMSignature$SHA224withECDSA"));
        this.putService(new SCHSMService(this, "Signature", "SHA256withECDSA", "de.cardcontact.smartcardhsmprovider.SmartCardHSMSignature$SHA256withECDSA"));
        this.putService(new SCHSMService(this, "Signature", "NONEwithECDSA", "de.cardcontact.smartcardhsmprovider.SmartCardHSMSignature$NONEwithECDSA"));
        this.putService(new SCHSMService(this, "Signature", "NONEwithRSA", "de.cardcontact.smartcardhsmprovider.SmartCardHSMSignature$NONEwithRSA"));
        this.putService(new SCHSMService(this, "KeyStore", "SmartCardHSMKeyStore", "de.cardcontact.smartcardhsmprovider.SmartCardHSMKeyStore"));
        alias = new Vector();
        alias.addElement("RSA");
        this.putService(new SCHSMService(this, "Cipher", "RSA/None/NoPadding", "de.cardcontact.smartcardhsmprovider.SmartCardHSMCipher", alias));
        alias = new Vector();
        alias.addElement("RSA/ECB/PKCS1Padding");
        alias.addElement("RSA/NONE/PKCS1Padding");
        this.putService(new SCHSMService(this, "Cipher", "RSA/None/PKCS1Padding", "de.cardcontact.smartcardhsmprovider.SmartCardHSMCipher", alias));
        alias = new Vector();
        alias.addElement("RSA/NONE/OAEPWithSHA1AndMGF1Padding");
        alias.addElement("RSA/None/OAEPWithSHA1AndMGF1Padding");
        this.putService(new SCHSMService(this, "Cipher", "RSA/ECB/OAEPWithSHA-1AndMGF1Padding", "de.cardcontact.smartcardhsmprovider.SmartCardHSMCipher", alias));
        this.putService(new SCHSMService(this, "KeyAgreement", "ECDH", "de.cardcontact.smartcardhsmprovider.SmartCardHSMKeyAgreement"));
    }

    public void setSmartCardHSMCardService(SmartCardHSMCardService schsm) {
        if (schsm == null) {
            this.schsm = null;
            return;
        }
        try {
            log.debug("Setting SmartCardHSMCardService object");
            schsm.getCard().setAPDUTracer((APDUTracer)this);
            schsm.useClassThreePinPad(this.usePinPad);
            if (this.doSecureMessaging) {
                schsm.initSecureMessaging();
            }
        }
        catch (CertPathBuilderException | OpenCardException e) {
            log.error(e.getLocalizedMessage(), e);
            throw new ProviderException(e);
        }
        this.schsm = schsm;
    }

    public SmartCardHSMCardService getSmartCardHSMCardService() {
        this.checkCardState();
        return this.schsm;
    }

    private void checkCardState() {
        if (this.schsm == null) {
            try {
                EventGenerator.getGenerator().createEventsForPresentCards((CTListener)this);
            }
            catch (CardTerminalException e) {
                log.debug(e.getLocalizedMessage(), (Throwable)e);
            }
            if (this.schsm == null) {
                throw new ProviderException("No card inserted");
            }
        }
    }

    @Override
    public void login(Subject subject, CallbackHandler cbh) throws LoginException {
        boolean verified;
        this.checkCardState();
        if (this.callBackHandler == null && cbh == null && !this.usePinPad) {
            throw new LoginException("The mandatory CallbackHandler cannot be null");
        }
        if (cbh != null) {
            this.setCallbackHandler(cbh);
        }
        if (!(verified = this.verify())) {
            log.info("Login failed. Wrong PIN?");
            throw new FailedLoginException("Login failed. Wrong PIN?");
        }
    }

    @Override
    public void logout() throws LoginException {
    }

    @Override
    public void setCallbackHandler(CallbackHandler cbh) {
        this.callBackHandler = cbh;
    }

    public void register() throws OpenCardPropertyLoadingException, CardServiceException, CardTerminalException, ClassNotFoundException {
        if (SmartCard.isStarted()) {
            log.debug("OCF already running");
            if (this.doOCFShutdown == 0) {
                ++this.doOCFShutdown;
            }
        } else {
            log.debug("Startup of OCF...");
            SmartCard.startup();
            CardTerminalRegistry ctr = CardTerminalRegistry.getRegistry();
            SmartCardIOFactory ctf = new SmartCardIOFactory();
            String[] param = new String[]{"*", "PCSC"};
            ctf.createCardTerminals(ctr, param);
            CardServiceRegistry csr = CardServiceRegistry.getRegistry();
            IsoCardServiceFactory csf = new IsoCardServiceFactory();
            csr.add((CardServiceFactory)csf);
            csf = new PassThruCardServiceFactory();
            csr.add((CardServiceFactory)csf);
            csf = new GlobalPlatformCardServiceFactory();
            csr.add((CardServiceFactory)csf);
            csf = new SmartCardHSMCardServiceFactory();
            csr.add((CardServiceFactory)csf);
            csf = new RemoteClientCardServiceFactory();
            csr.add((CardServiceFactory)csf);
        }
        ++this.doOCFShutdown;
        log.debug("Register to event generator...");
        EventGenerator.getGenerator().addCTListener((CTListener)this);
    }

    public void unregister() {
        log.debug("Unregister from event generator...");
        EventGenerator.getGenerator().removeCTListener((CTListener)this);
        --this.doOCFShutdown;
        if (this.doOCFShutdown <= 0) {
            try {
                log.debug("Shutdown OCF...");
                SmartCard.shutdown();
            }
            catch (CardTerminalException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new ProviderException(e);
            }
        }
        this.sc = null;
        this.ct = null;
        this.schsm = null;
    }

    public void cardInserted(CardTerminalEvent ctEvent) throws CardTerminalException {
        if (this.sc == null) {
            log.debug("Card inserted");
            CardTerminalRegistry ctr = CardTerminalRegistry.getRegistry();
            if (this.ct == null) {
                if (this.terminalName != null) {
                    this.ct = ctr.cardTerminalForName(this.terminalName);
                }
                if (this.ct == null) {
                    this.ct = ctEvent.getCardTerminal();
                }
            }
            CardRequest cr = new CardRequest(1, this.ct, SmartCardHSMCardService.class);
            this.sc = SmartCard.getSmartCard((CardTerminalEvent)ctEvent, (CardRequest)cr);
            if (this.sc == null) {
                log.debug("New card is not a SmartCard-HSM");
                return;
            }
            this.slotID = ctEvent.getSlotID();
            try {
                log.debug("New SmartCardHSMCardService object");
                this.schsm = (SmartCardHSMCardService)this.sc.getCardService(SmartCardHSMCardService.class, true);
                this.schsm.getCard().setAPDUTracer((APDUTracer)this);
                this.schsm.useClassThreePinPad(this.usePinPad);
                if (this.doSecureMessaging) {
                    this.schsm.initSecureMessaging();
                }
            }
            catch (CardServiceException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new ProviderException(e);
            }
            catch (ClassNotFoundException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
            }
            catch (CertPathBuilderException e) {
                throw new ProviderException(e);
            }
            if (this.callBackHandler != null) {
                this.verify();
            }
        }
    }

    public void cardRemoved(CardTerminalEvent ctEvent) throws CardTerminalException {
        if (ctEvent.getSlotID() == this.slotID) {
            if (this.ct != null && !ctEvent.getCardTerminal().equals(this.ct)) {
                return;
            }
            log.debug("Card removed");
            this.sc = null;
            this.ct = null;
            this.slotID = -1;
            this.schsm = null;
        }
    }

    public void traceAnswerToReset(SlotChannel sc, CardID cardID) {
        String s = sc.getCardTerminal().getName();
        s = s.concat("\n");
        s = s.concat(HexString.hexifyByteArray((byte[])cardID.getATR()));
        log.debug(s);
    }

    public void traceCommandAPDU(SlotChannel sc, CommandAPDU capdu) {
        String s = sc.getCardTerminal().getName();
        s = s.concat("\n");
        s = s.concat(APDUFormatter.commandAPDUToString((CommandAPDU)capdu));
        log.debug(s);
    }

    public void traceResponseAPDU(SlotChannel sc, ResponseAPDU rapdu) {
        try {
            StringBuffer sb = new StringBuffer(80);
            int len = rapdu.getLength();
            byte[] buf = rapdu.getBuffer();
            sb.append("   R: ");
            sb.append(StatusWordTable.MessageForSW((int)rapdu.sw()));
            sb.append(" Lr=" + (len - 2));
            sb.append("\n");
            if (len > 2) {
                sb.append(HexString.dump((byte[])buf, (int)0, (int)(len - 2), (int)16, (int)6));
            }
            log.debug(sb.toString());
        }
        catch (Exception e) {
            log.debug("Error decoding APDU.", (Throwable)e);
        }
    }

    private static class KeyPairGenService
    extends Provider.Service {
        private static final Class[] constructorParamTypes = new Class[]{SmartCardHSMProvider.class, String.class};

        KeyPairGenService(AuthProvider provider, String type, String algorithm, String className, Vector<String> aliases) {
            super(provider, type, algorithm, className, aliases, null);
        }

        KeyPairGenService(AuthProvider provider, String type, String algorithm, String className) {
            super(provider, type, algorithm, className, null, null);
        }

        @Override
        public Object newInstance(Object param) {
            try {
                SmartCardHSMProvider provider = (SmartCardHSMProvider)this.getProvider();
                ClassLoader loader = provider.getClass().getClassLoader();
                Class<?> clazz = loader == null ? Class.forName(this.getClassName()) : loader.loadClass(this.getClassName());
                Constructor<?> cons = clazz.getConstructor(constructorParamTypes);
                StringTokenizer st = new StringTokenizer(this.getAlgorithm(), "/");
                st.nextToken();
                Object obj = cons.newInstance(provider, st.nextToken());
                return obj;
            }
            catch (Exception e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new ProviderException(e);
            }
        }
    }

    private static class SCHSMService
    extends Provider.Service {
        private static final Class[] constructorParamTypes = new Class[]{SmartCardHSMProvider.class, String.class};

        SCHSMService(AuthProvider provider, String type, String algorithm, String className, Vector<String> aliases) {
            super(provider, type, algorithm, className, aliases, null);
        }

        SCHSMService(AuthProvider provider, String type, String algorithm, String className) {
            super(provider, type, algorithm, className, null, null);
        }

        @Override
        public Object newInstance(Object param) {
            try {
                SmartCardHSMProvider provider = (SmartCardHSMProvider)this.getProvider();
                ClassLoader loader = provider.getClass().getClassLoader();
                Class<?> clazz = loader == null ? Class.forName(this.getClassName()) : loader.loadClass(this.getClassName());
                Constructor<?> cons = clazz.getConstructor(constructorParamTypes);
                Object obj = cons.newInstance(provider, this.getAlgorithm());
                return obj;
            }
            catch (Exception e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
                throw new ProviderException(e);
            }
        }
    }
}

