/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.smartcardhsmprovider;

import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMPrivateKey;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.SignatureSpi;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import opencard.opt.security.PrivateKeyRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartCardHSMSignature
extends SignatureSpi {
    private static final Logger log = LoggerFactory.getLogger(SmartCardHSMSignature.class);
    private static boolean SIGN_STATE;
    protected SmartCardHSMCardService schsm;
    protected SmartCardHSMPrivateKey privateKey;
    private String digestAlgorithm;
    protected String signAlgorithm;
    private String padAlgorithm;
    private MessageDigest digest;

    public SmartCardHSMSignature(SmartCardHSMProvider smartCardHSMProvider, String string, String string2, String string3) {
        this.schsm = smartCardHSMProvider.getSmartCardHSMCardService();
        this.digestAlgorithm = string;
        this.signAlgorithm = string2;
        this.padAlgorithm = string3;
        if (!smartCardHSMProvider.isVerified()) {
            throw new ProviderException("Login required.");
        }
    }

    @Override
    protected Object engineGetParameter(String string) throws InvalidParameterException {
        return null;
    }

    @Override
    protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
        log.trace("SmartCardHSMSignature.engineInitSign");
        SIGN_STATE = true;
        if (!(privateKey instanceof SmartCardHSMPrivateKey)) {
            throw new InvalidKeyException("The key is not type of SmartCardHSMPrivateKey");
        }
        this.privateKey = (SmartCardHSMPrivateKey)privateKey;
        try {
            this.digest = MessageDigest.getInstance(this.digestAlgorithm, "BC");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            log.error(noSuchAlgorithmException.getLocalizedMessage(), (Throwable)noSuchAlgorithmException);
            throw new ProviderException(noSuchAlgorithmException);
        }
        catch (NoSuchProviderException noSuchProviderException) {
            log.error(noSuchProviderException.getLocalizedMessage(), (Throwable)noSuchProviderException);
            throw new ProviderException(noSuchProviderException);
        }
    }

    @Override
    protected void engineInitVerify(PublicKey publicKey) throws InvalidKeyException {
        SIGN_STATE = false;
        log.debug("Do nothing...");
    }

    @Override
    protected void engineSetParameter(String string, Object object) throws InvalidParameterException {
    }

    @Override
    protected byte[] engineSign() throws SignatureException {
        byte[] byArray = this.digest.digest();
        byte[] byArray2 = null;
        try {
            byArray2 = this.schsm.signHash((PrivateKeyRef)this.privateKey, this.signAlgorithm, this.padAlgorithm, byArray);
        }
        catch (CardServiceException cardServiceException) {
            log.error(cardServiceException.getLocalizedMessage(), (Throwable)cardServiceException);
            throw new ProviderException(cardServiceException);
        }
        catch (CardTerminalException cardTerminalException) {
            log.error(cardTerminalException.getLocalizedMessage(), (Throwable)cardTerminalException);
            throw new ProviderException(cardTerminalException);
        }
        return byArray2;
    }

    @Override
    protected void engineUpdate(byte by) throws SignatureException {
        log.trace("SmartCardHSMSignature.engineUpdate()");
        if (SIGN_STATE) {
            this.digest.update(by);
        }
    }

    @Override
    protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
        log.trace("SmartCardHSMSignature.engineUpdate()");
        if (SIGN_STATE) {
            this.digest.update(byArray, n, n2);
        }
    }

    @Override
    protected boolean engineVerify(byte[] byArray) throws SignatureException {
        log.trace("SmartCardHSMSignature.engineVerify");
        return false;
    }

    protected static class SHA256withECDSA
    extends SmartCardHSMSignature {
        public SHA256withECDSA(SmartCardHSMProvider smartCardHSMProvider, String string) {
            super(smartCardHSMProvider, "SHA-256", "NONEwithECDSA", "NONE");
        }
    }

    protected static class SHA224withECDSA
    extends SmartCardHSMSignature {
        public SHA224withECDSA(SmartCardHSMProvider smartCardHSMProvider, String string) {
            super(smartCardHSMProvider, "SHA-224", "NONEwithECDSA", "NONE");
        }
    }

    protected static class SHA1withECDSA
    extends SmartCardHSMSignature {
        public SHA1withECDSA(SmartCardHSMProvider smartCardHSMProvider, String string) {
            super(smartCardHSMProvider, "SHA1", "NONEwithECDSA", "NONE");
        }
    }

    protected static class NONEwithECDSA
    extends SmartCardHSMSignature {
        private ByteArrayOutputStream md;

        public NONEwithECDSA(SmartCardHSMProvider smartCardHSMProvider, String string) {
            super(smartCardHSMProvider, "", "NONEwithECDSA", "NONE");
            log.debug("NONEwithECDSA");
        }

        @Override
        protected void engineUpdate(byte by) throws SignatureException {
            if (SIGN_STATE) {
                this.md.write(by);
            }
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
            if (SIGN_STATE) {
                this.md.write(byArray, n, n2);
            }
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
            log.debug("Initialized for signature...");
            SIGN_STATE = true;
            this.privateKey = (SmartCardHSMPrivateKey)privateKey;
            this.md = new ByteArrayOutputStream();
        }

        @Override
        protected byte[] engineSign() throws SignatureException {
            byte[] byArray = null;
            try {
                byArray = this.schsm.signHash((PrivateKeyRef)this.privateKey, this.signAlgorithm, this.md.toByteArray());
            }
            catch (CardServiceException cardServiceException) {
                log.error(cardServiceException.getLocalizedMessage(), (Throwable)cardServiceException);
                throw new ProviderException(cardServiceException);
            }
            catch (CardTerminalException cardTerminalException) {
                log.error(cardTerminalException.getLocalizedMessage(), (Throwable)cardTerminalException);
                throw new ProviderException(cardTerminalException);
            }
            catch (InvalidKeyException invalidKeyException) {
                log.error(invalidKeyException.getLocalizedMessage(), (Throwable)invalidKeyException);
                throw new ProviderException(invalidKeyException);
            }
            return byArray;
        }
    }

    protected static class NONEwithRSA
    extends SmartCardHSMSignature {
        private ByteArrayOutputStream md;

        public NONEwithRSA(SmartCardHSMProvider smartCardHSMProvider, String string) {
            super(smartCardHSMProvider, "", "NONEwithRSA", "PKCS1_V15");
            log.debug("NONEwithRSA");
        }

        @Override
        protected void engineUpdate(byte by) throws SignatureException {
            if (SIGN_STATE) {
                this.md.write(by);
            }
        }

        @Override
        protected void engineUpdate(byte[] byArray, int n, int n2) throws SignatureException {
            if (SIGN_STATE) {
                this.md.write(byArray, n, n2);
            }
        }

        @Override
        protected void engineInitSign(PrivateKey privateKey) throws InvalidKeyException {
            log.debug("Initialized for signature...");
            SIGN_STATE = true;
            this.privateKey = (SmartCardHSMPrivateKey)privateKey;
            this.md = new ByteArrayOutputStream();
        }

        @Override
        protected byte[] engineSign() throws SignatureException {
            byte[] byArray = null;
            try {
                byArray = this.schsm.signHash((PrivateKeyRef)this.privateKey, this.signAlgorithm, this.md.toByteArray());
            }
            catch (CardServiceException cardServiceException) {
                log.error(cardServiceException.getLocalizedMessage(), (Throwable)cardServiceException);
                throw new ProviderException(cardServiceException);
            }
            catch (CardTerminalException cardTerminalException) {
                log.error(cardTerminalException.getLocalizedMessage(), (Throwable)cardTerminalException);
                throw new ProviderException(cardTerminalException);
            }
            catch (InvalidKeyException invalidKeyException) {
                log.error(invalidKeyException.getLocalizedMessage(), (Throwable)invalidKeyException);
                throw new ProviderException(invalidKeyException);
            }
            return byArray;
        }
    }

    protected static class SHA1withRSAPKCS1PSS
    extends SmartCardHSMSignature {
        public SHA1withRSAPKCS1PSS(SmartCardHSMProvider smartCardHSMProvider, String string) {
            super(smartCardHSMProvider, "SHA1", "SHA1withRSA", "PKCS1_PSS");
        }
    }

    protected static class SHA256withRSAPKCS1PSS
    extends SmartCardHSMSignature {
        public SHA256withRSAPKCS1PSS(SmartCardHSMProvider smartCardHSMProvider, String string) {
            super(smartCardHSMProvider, "SHA256", "SHA256withRSA", "PKCS1_PSS");
        }
    }

    protected static class SHA256withRSAPKCS1V15
    extends SmartCardHSMSignature {
        public SHA256withRSAPKCS1V15(SmartCardHSMProvider smartCardHSMProvider, String string) {
            super(smartCardHSMProvider, "SHA256", "SHA256withRSA", "PKCS1_V15");
        }
    }

    protected static class SHA1withRSAPKCS1V15
    extends SmartCardHSMSignature {
        public SHA1withRSAPKCS1V15(SmartCardHSMProvider smartCardHSMProvider, String string) {
            super(smartCardHSMProvider, "SHA1", "SHA1withRSA", "PKCS1_V15");
        }
    }
}

