/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.smartcardhsmprovider;

import de.cardcontact.opencard.factory.GlobalPlatformCardServiceFactory;
import de.cardcontact.opencard.factory.IsoCardServiceFactory;
import de.cardcontact.opencard.factory.RemoteClientCardServiceFactory;
import de.cardcontact.opencard.factory.SmartCardHSMCardServiceFactory;
import de.cardcontact.opencard.service.StatusWordTable;
import de.cardcontact.opencard.service.remoteclient.RemoteClient;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.terminal.smartcardio.SmartCardIOFactory;
import de.cardcontact.opencard.utils.StreamingAPDUTracer;
import de.cardcontact.smartcardhsmprovider.OCFCallback;
import de.cardcontact.smartcardhsmprovider.PublicKeyAuthenticationCallback;
import de.cardcontact.tlv.HexString;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.security.AuthProvider;
import java.security.Provider;
import java.security.ProviderException;
import java.security.Security;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import opencard.core.OpenCardException;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.event.EventGenerator;
import opencard.core.service.CHVDialog;
import opencard.core.service.CardRequest;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceRegistry;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardID;
import opencard.core.terminal.CardTerminal;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.core.terminal.SlotChannel;
import opencard.core.util.APDUTracer;
import opencard.core.util.OpenCardPropertyLoadingException;
import opencard.opt.util.PassThruCardServiceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SmartCardHSMProvider
extends AuthProvider
implements CTListener,
APDUTracer {
    private static final long serialVersionUID = 4737690040987973156L;
    private static final Logger log = LoggerFactory.getLogger(SmartCardHSMProvider.class);
    private static String PROVIDER_NAME = "SmartCardHSM";
    private static double VERSION = 1.0;
    private static String INFO = "SmartCardHSM provider implementing x";
    private boolean doSecureMessaging = true;
    private int doOCFShutdown = 0;
    private boolean usePinPad = false;
    private boolean usePKACallback = false;
    private SmartCard sc = null;
    private String terminalName = null;
    private CardTerminal ct = null;
    private int slotID = 0;
    private SmartCardHSMCardService schsm;
    private PasswordCallback passwordCallback;
    private PublicKeyAuthenticationCallback pkaCallback;
    private CallbackHandler cbh = null;

    public SmartCardHSMProvider() {
        super(PROVIDER_NAME, VERSION, INFO);
        log.debug("Super constructor called...");
        this.initProviderProperties();
        try {
            this.register();
        }
        catch (Exception exception) {
            log.error(exception.getLocalizedMessage(), (Throwable)exception);
            throw new ProviderException(exception);
        }
    }

    public SmartCardHSMProvider(String string) {
        super(PROVIDER_NAME + "/" + string, VERSION, INFO);
        log.debug("Super constructor called...");
        this.terminalName = string;
        this.initProviderProperties();
        try {
            this.register();
        }
        catch (Exception exception) {
            log.error(exception.getLocalizedMessage(), (Throwable)exception);
            throw new ProviderException(exception);
        }
    }

    public static void removeProviders() {
        Provider[] providerArray;
        for (Provider provider : providerArray = Security.getProviders()) {
            if (!provider.getName().startsWith(PROVIDER_NAME)) continue;
            SmartCardHSMProvider smartCardHSMProvider = (SmartCardHSMProvider)provider;
            smartCardHSMProvider.unregister();
            Security.removeProvider(smartCardHSMProvider.getName());
        }
    }

    public boolean isVerified() {
        boolean bl = false;
        if (this.schsm == null) {
            return false;
        }
        try {
            bl = this.schsm.getSecurityStatus();
        }
        catch (CardServiceException cardServiceException) {
        }
        catch (CardTerminalException cardTerminalException) {
            // empty catch block
        }
        if (!bl) {
            bl = this.verify();
        }
        return bl;
    }

    private boolean verify() {
        if (this.schsm == null) {
            throw new ProviderException("CardService not initialized");
        }
        if (this.cbh != null) {
            try {
                log.debug("Get password callback from application");
                if (this.usePKACallback) {
                    this.cbh.handle(new Callback[]{this.passwordCallback, this.pkaCallback});
                } else {
                    this.cbh.handle(new Callback[]{this.passwordCallback});
                }
            }
            catch (IOException iOException) {
                log.error(iOException.getLocalizedMessage(), (Throwable)iOException);
                throw new ProviderException(iOException);
            }
            catch (UnsupportedCallbackException unsupportedCallbackException) {
                log.error(unsupportedCallbackException.getLocalizedMessage(), (Throwable)unsupportedCallbackException);
                throw new ProviderException(unsupportedCallbackException);
            }
            if (this.passwordCallback.getPassword() != null) {
                this.schsm.setCHVDialog((CHVDialog)new OCFCallback(this.passwordCallback));
                try {
                    return this.schsm.verifyPassword();
                }
                catch (OpenCardException openCardException) {
                    log.error(openCardException.getLocalizedMessage(), (Throwable)openCardException);
                    throw new ProviderException(openCardException);
                }
            }
            if (this.pkaCallback.getUrl() != null) {
                try {
                    RemoteClient remoteClient = (RemoteClient)this.sc.getCardService(RemoteClient.class, true);
                    remoteClient.update(this.pkaCallback.getUrl(), null, null);
                    return this.schsm.getSecurityStatus();
                }
                catch (Exception exception) {
                    log.error(exception.getLocalizedMessage(), (Throwable)exception);
                    throw new ProviderException(exception);
                }
            }
            throw new ProviderException("Neither a password nor an URL to an authentication server was configured");
        }
        try {
            return this.schsm.verifyPassword();
        }
        catch (OpenCardException openCardException) {
            log.error(openCardException.getLocalizedMessage(), (Throwable)openCardException);
            throw new ProviderException(openCardException);
        }
    }

    public void setSecureMessaging(boolean bl) {
        this.doSecureMessaging = bl;
    }

    public void useTerminalPinPad(boolean bl) {
        this.usePinPad = bl;
    }

    public void usePKACallback(boolean bl) {
        this.usePKACallback = bl;
    }

    private void initProviderProperties() {
        this.passwordCallback = new PasswordCallback("SmartCardHSMPasswordCallback", false);
        this.pkaCallback = new PublicKeyAuthenticationCallback();
        log.debug("Initializing provider algorithms...");
        this.putService(new SCHSMService(this, "SecureRandom", "NativePRNG", "de.cardcontact.smartcardhsmprovider.SecureRandom"));
        this.putService(new SCHSMService(this, "KeyGenerator", "AES", "de.cardcontact.smartcardhsmprovider.KeyGenerator"));
        Vector<String> vector = new Vector<String>();
        vector.addElement("RSA");
        this.putService(new KeyPairGenService(this, "KeyPairGenerator", "RSA//PKCS1-v1-5-SHA-1", "de.cardcontact.smartcardhsmprovider.KeyPairGenerator$RSA", vector));
        this.putService(new KeyPairGenService(this, "KeyPairGenerator", "RSA//PKCS1-v1-5-SHA-256", "de.cardcontact.smartcardhsmprovider.KeyPairGenerator$RSA"));
        this.putService(new KeyPairGenService(this, "KeyPairGenerator", "RSA//PKCS1-PSS-SHA-1", "de.cardcontact.smartcardhsmprovider.KeyPairGenerator$RSA"));
        this.putService(new KeyPairGenService(this, "KeyPairGenerator", "RSA//PKCS1-PSS-SHA-256", "de.cardcontact.smartcardhsmprovider.KeyPairGenerator$RSA"));
        vector = new Vector();
        vector.addElement("EC");
        this.putService(new KeyPairGenService(this, "KeyPairGenerator", "EC//ECDSA-SHA-1", "de.cardcontact.smartcardhsmprovider.KeyPairGenerator$EC", vector));
        this.putService(new KeyPairGenService(this, "KeyPairGenerator", "EC//ECDSA-SHA-224", "de.cardcontact.smartcardhsmprovider.KeyPairGenerator$EC"));
        this.putService(new KeyPairGenService(this, "KeyPairGenerator", "EC//ECDSA-SHA-256", "de.cardcontact.smartcardhsmprovider.KeyPairGenerator$EC"));
        this.put("AlgorithmParameters.EC SupportedCurves", "secp192r1,prime192v1,secp256r1,prime256v1,brainpoolP192r1,brainpoolP224r1,brainpoolP256r1,brainpoolP320r1,secp192k1,secp256k1");
        vector = new Vector();
        vector.addElement("SHA1withRSA");
        this.putService(new SCHSMService(this, "Signature", "SHA1withRSA//PKCS1-v1-5", "de.cardcontact.smartcardhsmprovider.SmartCardHSMSignature$SHA1withRSAPKCS1V15", vector));
        vector = new Vector();
        vector.addElement("SHA256withRSA");
        this.putService(new SCHSMService(this, "Signature", "SHA256withRSA//PKCS1-v1-5", "de.cardcontact.smartcardhsmprovider.SmartCardHSMSignature$SHA256withRSAPKCS1V15", vector));
        vector = new Vector();
        vector.addElement("SHA1withRSA/PSS");
        this.putService(new SCHSMService(this, "Signature", "SHA1withRSA//PKCS1-PSS", "de.cardcontact.smartcardhsmprovider.SmartCardHSMSignature$SHA1withRSAPKCS1PSS", vector));
        vector = new Vector();
        vector.addElement("SHA256withRSA/PSS");
        this.putService(new SCHSMService(this, "Signature", "SHA256withRSA//PKCS1-PSS", "de.cardcontact.smartcardhsmprovider.SmartCardHSMSignature$SHA256withRSAPKCS1PSS", vector));
        this.putService(new SCHSMService(this, "Signature", "SHA1withECDSA", "de.cardcontact.smartcardhsmprovider.SmartCardHSMSignature$SHA1withECDSA"));
        this.putService(new SCHSMService(this, "Signature", "SHA224withECDSA", "de.cardcontact.smartcardhsmprovider.SmartCardHSMSignature$SHA224withECDSA"));
        this.putService(new SCHSMService(this, "Signature", "SHA256withECDSA", "de.cardcontact.smartcardhsmprovider.SmartCardHSMSignature$SHA256withECDSA"));
        this.putService(new SCHSMService(this, "Signature", "NONEwithECDSA", "de.cardcontact.smartcardhsmprovider.SmartCardHSMSignature$NONEwithECDSA"));
        this.putService(new SCHSMService(this, "Signature", "NONEwithRSA", "de.cardcontact.smartcardhsmprovider.SmartCardHSMSignature$NONEwithRSA"));
        this.putService(new SCHSMService(this, "KeyStore", "SmartCardHSMKeyStore", "de.cardcontact.smartcardhsmprovider.SmartCardHSMKeyStore"));
        vector = new Vector();
        vector.addElement("RSA");
        this.putService(new SCHSMService(this, "Cipher", "RSA/None/NoPadding", "de.cardcontact.smartcardhsmprovider.SmartCardHSMCipher", vector));
        vector = new Vector();
        vector.addElement("RSA/ECB/PKCS1Padding");
        vector.addElement("RSA/NONE/PKCS1Padding");
        this.putService(new SCHSMService(this, "Cipher", "RSA/None/PKCS1Padding", "de.cardcontact.smartcardhsmprovider.SmartCardHSMCipher", vector));
        vector = new Vector();
        vector.addElement("RSA/NONE/OAEPWithSHA1AndMGF1Padding");
        vector.addElement("RSA/None/OAEPWithSHA1AndMGF1Padding");
        this.putService(new SCHSMService(this, "Cipher", "RSA/ECB/OAEPWithSHA-1AndMGF1Padding", "de.cardcontact.smartcardhsmprovider.SmartCardHSMCipher", vector));
        this.putService(new SCHSMService(this, "KeyAgreement", "ECDH", "de.cardcontact.smartcardhsmprovider.SmartCardHSMKeyAgreement"));
    }

    public void setSmartCardHSMCardService(SmartCardHSMCardService smartCardHSMCardService) {
        this.schsm = smartCardHSMCardService;
    }

    public SmartCardHSMCardService getSmartCardHSMCardService() {
        this.checkCardState();
        return this.schsm;
    }

    private void checkCardState() {
        if (this.schsm == null) {
            try {
                EventGenerator.getGenerator().createEventsForPresentCards((CTListener)this);
            }
            catch (CardTerminalException cardTerminalException) {
                log.debug(cardTerminalException.getLocalizedMessage(), (Throwable)cardTerminalException);
            }
            if (this.schsm == null) {
                throw new ProviderException("No card inserted");
            }
        }
    }

    @Override
    public void login(Subject subject, CallbackHandler callbackHandler) throws LoginException {
        this.checkCardState();
        if (callbackHandler == null && !this.usePinPad) {
            throw new LoginException("The mandatory CallbackHandler cannot be null");
        }
        this.setCallbackHandler(callbackHandler);
        boolean bl = this.verify();
        if (!bl) {
            log.info("Login failed. Wrong PIN?");
            throw new FailedLoginException("Login failed. Wrong PIN?");
        }
    }

    @Override
    public void logout() throws LoginException {
    }

    @Override
    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.cbh = callbackHandler;
    }

    public void register() throws OpenCardPropertyLoadingException, CardServiceException, CardTerminalException, ClassNotFoundException {
        if (SmartCard.isStarted()) {
            log.debug("OCF already running");
            if (this.doOCFShutdown == 0) {
                ++this.doOCFShutdown;
            }
        } else {
            log.debug("Startup of OCF...");
            SmartCard.startup();
            CardTerminalRegistry cardTerminalRegistry = CardTerminalRegistry.getRegistry();
            SmartCardIOFactory smartCardIOFactory = new SmartCardIOFactory();
            String[] stringArray = new String[]{"*", "PCSC"};
            smartCardIOFactory.createCardTerminals(cardTerminalRegistry, stringArray);
            CardServiceRegistry cardServiceRegistry = CardServiceRegistry.getRegistry();
            IsoCardServiceFactory isoCardServiceFactory = new IsoCardServiceFactory();
            cardServiceRegistry.add((CardServiceFactory)isoCardServiceFactory);
            isoCardServiceFactory = new PassThruCardServiceFactory();
            cardServiceRegistry.add((CardServiceFactory)isoCardServiceFactory);
            isoCardServiceFactory = new GlobalPlatformCardServiceFactory();
            cardServiceRegistry.add((CardServiceFactory)isoCardServiceFactory);
            isoCardServiceFactory = new SmartCardHSMCardServiceFactory();
            cardServiceRegistry.add((CardServiceFactory)isoCardServiceFactory);
            isoCardServiceFactory = new RemoteClientCardServiceFactory();
            cardServiceRegistry.add((CardServiceFactory)isoCardServiceFactory);
        }
        ++this.doOCFShutdown;
        log.debug("Register to event generator...");
        EventGenerator.getGenerator().addCTListener((CTListener)this);
    }

    public void unregister() {
        log.debug("Unregister from event generator...");
        EventGenerator.getGenerator().removeCTListener((CTListener)this);
        --this.doOCFShutdown;
        if (this.doOCFShutdown <= 0) {
            try {
                log.debug("Shutdown OCF...");
                SmartCard.shutdown();
            }
            catch (CardTerminalException cardTerminalException) {
                log.error(cardTerminalException.getLocalizedMessage(), (Throwable)cardTerminalException);
                throw new ProviderException(cardTerminalException);
            }
        }
        this.sc = null;
        this.ct = null;
        this.schsm = null;
    }

    public void cardInserted(CardTerminalEvent cardTerminalEvent) throws CardTerminalException {
        if (this.sc == null) {
            log.debug("Card inserted");
            CardTerminalRegistry cardTerminalRegistry = CardTerminalRegistry.getRegistry();
            this.ct = cardTerminalRegistry.cardTerminalForName(this.terminalName);
            if (this.ct == null) {
                this.ct = cardTerminalEvent.getCardTerminal();
            }
            CardRequest cardRequest = new CardRequest(1, this.ct, SmartCardHSMCardService.class);
            this.sc = SmartCard.getSmartCard((CardTerminalEvent)cardTerminalEvent, (CardRequest)cardRequest);
            if (this.sc == null) {
                log.debug("New card is not a SmartCard-HSM");
                return;
            }
            this.slotID = cardTerminalEvent.getSlotID();
            try {
                log.debug("New SmartCardHSMCardService object");
                this.schsm = (SmartCardHSMCardService)this.sc.getCardService(SmartCardHSMCardService.class, true);
                this.schsm.getCard().setAPDUTracer((APDUTracer)this);
                this.schsm.useClassThreePinPad(this.usePinPad);
                if (this.doSecureMessaging) {
                    this.schsm.initSecureMessaging();
                }
            }
            catch (CardServiceException cardServiceException) {
                log.error(cardServiceException.getLocalizedMessage(), (Throwable)cardServiceException);
                throw new ProviderException(cardServiceException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                log.error(classNotFoundException.getLocalizedMessage(), (Throwable)classNotFoundException);
                throw new ProviderException(classNotFoundException);
            }
            if (this.cbh != null) {
                this.verify();
            }
        }
    }

    public void cardRemoved(CardTerminalEvent cardTerminalEvent) throws CardTerminalException {
        if (cardTerminalEvent.getSlotID() == this.slotID) {
            if (this.ct != null && !cardTerminalEvent.getCardTerminal().equals(this.ct)) {
                return;
            }
            log.debug("Card removed");
            this.sc = null;
            this.ct = null;
            this.slotID = -1;
            this.schsm = null;
        }
    }

    public void traceAnswerToReset(SlotChannel slotChannel, CardID cardID) {
        String string = slotChannel.getCardTerminal().getName();
        string = string.concat("\n");
        string = string.concat(HexString.hexifyByteArray((byte[])cardID.getATR()));
        log.debug(string);
    }

    public void traceCommandAPDU(SlotChannel slotChannel, CommandAPDU commandAPDU) {
        String string = slotChannel.getCardTerminal().getName();
        string = string.concat("\n");
        string = string.concat(StreamingAPDUTracer.commandAPDUToString((CommandAPDU)commandAPDU));
        log.debug(string);
    }

    public void traceResponseAPDU(SlotChannel slotChannel, ResponseAPDU responseAPDU) {
        try {
            StringBuffer stringBuffer = new StringBuffer(80);
            int n = responseAPDU.getLength();
            byte[] byArray = responseAPDU.getBuffer();
            stringBuffer.append("   R: ");
            stringBuffer.append(StatusWordTable.MessageForSW((int)responseAPDU.sw()));
            stringBuffer.append(" Lr=" + (n - 2));
            stringBuffer.append("\n");
            if (n > 2) {
                stringBuffer.append(HexString.dump((byte[])byArray, (int)0, (int)(n - 2), (int)16, (int)6));
            }
            log.debug(stringBuffer.toString());
        }
        catch (Exception exception) {
            log.debug("Error decoding APDU.", (Throwable)exception);
        }
    }

    private static class KeyPairGenService
    extends Provider.Service {
        private static final Class[] constructorParamTypes = new Class[]{SmartCardHSMProvider.class, String.class};

        KeyPairGenService(AuthProvider authProvider, String string, String string2, String string3, Vector<String> vector) {
            super(authProvider, string, string2, string3, vector, null);
        }

        KeyPairGenService(AuthProvider authProvider, String string, String string2, String string3) {
            super(authProvider, string, string2, string3, null, null);
        }

        @Override
        public Object newInstance(Object object) {
            try {
                SmartCardHSMProvider smartCardHSMProvider = (SmartCardHSMProvider)this.getProvider();
                ClassLoader classLoader = smartCardHSMProvider.getClass().getClassLoader();
                Class<?> clazz = classLoader == null ? Class.forName(this.getClassName()) : classLoader.loadClass(this.getClassName());
                Constructor<?> constructor = clazz.getConstructor(constructorParamTypes);
                StringTokenizer stringTokenizer = new StringTokenizer(this.getAlgorithm(), "/");
                stringTokenizer.nextToken();
                Object obj = constructor.newInstance(smartCardHSMProvider, stringTokenizer.nextToken());
                return obj;
            }
            catch (Exception exception) {
                log.error(exception.getLocalizedMessage(), (Throwable)exception);
                throw new ProviderException(exception);
            }
        }
    }

    private static class SCHSMService
    extends Provider.Service {
        private static final Class[] constructorParamTypes = new Class[]{SmartCardHSMProvider.class, String.class};

        SCHSMService(AuthProvider authProvider, String string, String string2, String string3, Vector<String> vector) {
            super(authProvider, string, string2, string3, vector, null);
        }

        SCHSMService(AuthProvider authProvider, String string, String string2, String string3) {
            super(authProvider, string, string2, string3, null, null);
        }

        @Override
        public Object newInstance(Object object) {
            try {
                SmartCardHSMProvider smartCardHSMProvider = (SmartCardHSMProvider)this.getProvider();
                ClassLoader classLoader = smartCardHSMProvider.getClass().getClassLoader();
                Class<?> clazz = classLoader == null ? Class.forName(this.getClassName()) : classLoader.loadClass(this.getClassName());
                Constructor<?> constructor = clazz.getConstructor(constructorParamTypes);
                Object obj = constructor.newInstance(smartCardHSMProvider, this.getAlgorithm());
                return obj;
            }
            catch (Exception exception) {
                log.error(exception.getLocalizedMessage(), (Throwable)exception);
                throw new ProviderException(exception);
            }
        }
    }
}

