/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.smartcardhsmprovider;

import de.cardcontact.opencard.service.smartcardhsm.CertificateDescription;
import de.cardcontact.opencard.service.smartcardhsm.KeyDescription;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMEntry;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMRSAKey;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import de.cardcontact.tlv.TLVEncodingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import opencard.core.OpenCardException;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.util.HexString;
import opencard.opt.iso.fs.CardFilePath;
import opencard.opt.iso.fs.CardIOException;
import opencard.opt.service.CardServiceResourceNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartCardHSMKeyStore
extends KeyStoreSpi {
    private static final Logger log = LoggerFactory.getLogger(SmartCardHSMKeyStore.class);
    private SmartCardHSMProvider provider;
    private SmartCardHSMCardService schsm;
    private Vector<String> aliases;

    public SmartCardHSMKeyStore(SmartCardHSMProvider smartCardHSMProvider, String string) {
        this.provider = smartCardHSMProvider;
        this.schsm = smartCardHSMProvider.getSmartCardHSMCardService();
    }

    @Override
    public Enumeration<String> engineAliases() {
        try {
            this.aliases = this.schsm.getAliases();
        }
        catch (OpenCardException openCardException) {
            log.error(openCardException.getLocalizedMessage(), (Throwable)openCardException);
            throw new ProviderException(openCardException);
        }
        catch (CertificateException certificateException) {
            log.error(certificateException.getLocalizedMessage(), (Throwable)certificateException);
            throw new ProviderException(certificateException);
        }
        catch (TLVEncodingException tLVEncodingException) {
            log.error(tLVEncodingException.getLocalizedMessage(), (Throwable)tLVEncodingException);
            throw new ProviderException(tLVEncodingException);
        }
        return this.aliases.elements();
    }

    @Override
    public boolean engineContainsAlias(String string) {
        return this.schsm.containsLabel(string);
    }

    @Override
    public void engineDeleteEntry(String string) throws KeyStoreException {
        if (!this.provider.isVerified()) {
            throw new ProviderException("Login required.");
        }
        try {
            this.schsm.removeEntry(string);
        }
        catch (CardServiceResourceNotFoundException cardServiceResourceNotFoundException) {
            log.error(cardServiceResourceNotFoundException.getLocalizedMessage(), (Throwable)cardServiceResourceNotFoundException);
            throw new KeyStoreException(string + " not found.");
        }
        catch (CardTerminalException cardTerminalException) {
            log.error(cardTerminalException.getLocalizedMessage(), (Throwable)cardTerminalException);
            throw new ProviderException(cardTerminalException);
        }
        catch (CardIOException cardIOException) {
            log.error(cardIOException.getLocalizedMessage(), (Throwable)cardIOException);
            throw new ProviderException(cardIOException);
        }
        catch (CardServiceException cardServiceException) {
            log.error(cardServiceException.getLocalizedMessage(), (Throwable)cardServiceException);
            throw new ProviderException(cardServiceException);
        }
    }

    @Override
    public Certificate engineGetCertificate(String string) {
        SmartCardHSMEntry smartCardHSMEntry = this.schsm.getSmartCardHSMEntry(string);
        if (smartCardHSMEntry == null) {
            return null;
        }
        return smartCardHSMEntry.getCert();
    }

    @Override
    public String engineGetCertificateAlias(Certificate certificate) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Certificate[] engineGetCertificateChain(String string) {
        return new Certificate[]{this.engineGetCertificate(string)};
    }

    @Override
    public Date engineGetCreationDate(String string) {
        return new Date();
    }

    @Override
    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        SmartCardHSMEntry smartCardHSMEntry = null;
        if (cArray != null && cArray.length > 0) {
            int n;
            String string2 = "";
            for (n = 0; n < cArray.length; ++n) {
                string2 = string2 + cArray[n];
            }
            try {
                n = this.schsm.verifyPassword(null, 0, string2.getBytes()) ? 1 : 0;
            }
            catch (CardServiceException cardServiceException) {
                log.error(cardServiceException.getLocalizedMessage(), (Throwable)cardServiceException);
                throw new ProviderException(cardServiceException);
            }
            catch (CardTerminalException cardTerminalException) {
                log.error(cardTerminalException.getLocalizedMessage(), (Throwable)cardTerminalException);
                throw new ProviderException(cardTerminalException);
            }
        }
        if ((smartCardHSMEntry = this.schsm.getSmartCardHSMEntry(string)) == null) {
            throw new UnrecoverableKeyException("No key found.");
        }
        return smartCardHSMEntry.getKey();
    }

    @Override
    public boolean engineIsCertificateEntry(String string) {
        SmartCardHSMEntry smartCardHSMEntry = this.schsm.getSmartCardHSMEntry(string);
        if (smartCardHSMEntry == null) {
            return false;
        }
        return !smartCardHSMEntry.isEECertificate();
    }

    @Override
    public boolean engineIsKeyEntry(String string) {
        SmartCardHSMEntry smartCardHSMEntry = this.schsm.getSmartCardHSMEntry(string);
        if (smartCardHSMEntry == null) {
            return false;
        }
        return smartCardHSMEntry.isKeyEntry();
    }

    @Override
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        String string;
        boolean bl;
        if (cArray != null && !(bl = this.schsm.verifyPassword(null, 0, (string = new String(cArray)).getBytes()))) {
            log.error("Login failed. Wrong PIN?");
            throw new IOException("Login failed. Wrong PIN?");
        }
        try {
            this.aliases = this.schsm.getAliases();
        }
        catch (TLVEncodingException tLVEncodingException) {
            log.error(tLVEncodingException.getLocalizedMessage(), (Throwable)tLVEncodingException);
            throw new ProviderException(tLVEncodingException);
        }
    }

    @Override
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        SmartCardHSMEntry smartCardHSMEntry = this.schsm.getSmartCardHSMEntry(string);
        if (!this.provider.isVerified()) {
            throw new ProviderException("Login required.");
        }
        try {
            if (smartCardHSMEntry != null) {
                SmartCardHSMKey smartCardHSMKey = smartCardHSMEntry.getKey();
                if (smartCardHSMKey != null) {
                    String string2 = ":CE" + HexString.hexify((int)smartCardHSMKey.getKeyRef());
                    CardFilePath cardFilePath = new CardFilePath(string2);
                    this.schsm.write(cardFilePath, 0, certificate.getEncoded());
                    this.schsm.addCertToMap(certificate, true, smartCardHSMKey.getKeyRef(), string);
                } else {
                    byte by = smartCardHSMEntry.getId();
                    String string3 = ":CA" + HexString.hexify((int)by);
                    CardFilePath cardFilePath = new CardFilePath(string3);
                    this.schsm.write(cardFilePath, 0, certificate.getEncoded());
                    this.schsm.addCertToMap(certificate, false, by, string);
                }
            } else {
                byte by = this.schsm.determineFreeCAId();
                if (by == -1) {
                    throw new KeyStoreException("Storage limit for CA Certificates reached.");
                }
                String string4 = ":CA" + HexString.hexify((int)by);
                CardFilePath cardFilePath = new CardFilePath(string4);
                this.schsm.write(cardFilePath, 0, certificate.getEncoded());
                string4 = ":C8" + HexString.hexify((int)by);
                cardFilePath = new CardFilePath(string4);
                this.schsm.write(cardFilePath, 0, CertificateDescription.buildCertDescription((String)string, (PublicKey)certificate.getPublicKey(), (byte[])new byte[]{-54, by}));
                this.schsm.addCertToMap(certificate, false, by, string);
            }
        }
        catch (OpenCardException openCardException) {
            log.error(openCardException.getLocalizedMessage(), (Throwable)openCardException);
            throw new ProviderException(openCardException);
        }
        catch (CertificateException certificateException) {
            log.error(certificateException.getLocalizedMessage(), (Throwable)certificateException);
            throw new ProviderException(certificateException);
        }
        catch (TLVEncodingException tLVEncodingException) {
            log.error(tLVEncodingException.getLocalizedMessage(), (Throwable)tLVEncodingException);
            throw new ProviderException(tLVEncodingException);
        }
    }

    @Override
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        SmartCardHSMKey smartCardHSMKey = (SmartCardHSMKey)key;
        if (!this.provider.isVerified()) {
            throw new ProviderException("Login required.");
        }
        String string2 = smartCardHSMKey.getLabel();
        smartCardHSMKey.setLabel(string);
        try {
            byte[] byArray = new byte[]{smartCardHSMKey.getKeyRef()};
            KeyDescription keyDescription = key instanceof SmartCardHSMRSAKey ? new KeyDescription(byArray, string, (int)smartCardHSMKey.getKeySize(), KeyDescription.KeyTypes.RSA) : new KeyDescription(byArray, string, (int)smartCardHSMKey.getKeySize(), KeyDescription.KeyTypes.EC);
            this.schsm.storePRKD(smartCardHSMKey.getKeyRef(), keyDescription);
            if (string2 != null) {
                this.schsm.renameEntry(string2, string);
            } else {
                this.schsm.addKeyToMap(smartCardHSMKey);
            }
            if (certificateArray.length >= 1) {
                String string3 = ":CE" + HexString.hexify((int)smartCardHSMKey.getKeyRef());
                CardFilePath cardFilePath = new CardFilePath(string3);
                this.schsm.write(cardFilePath, 0, certificateArray[0].getEncoded());
                this.schsm.addCertToMap(certificateArray[0], true, smartCardHSMKey.getKeyRef(), string);
            }
        }
        catch (CardServiceException cardServiceException) {
            log.error(cardServiceException.getLocalizedMessage(), (Throwable)cardServiceException);
            throw new ProviderException(cardServiceException);
        }
        catch (CardTerminalException cardTerminalException) {
            log.error(cardTerminalException.getLocalizedMessage(), (Throwable)cardTerminalException);
            throw new ProviderException(cardTerminalException);
        }
        catch (CertificateEncodingException certificateEncodingException) {
            log.error(certificateEncodingException.getLocalizedMessage(), (Throwable)certificateEncodingException);
            throw new ProviderException(certificateEncodingException);
        }
    }

    @Override
    public int engineSize() {
        try {
            Vector vector = this.schsm.getAliases();
            return vector.size();
        }
        catch (Exception exception) {
            log.error(exception.getLocalizedMessage(), (Throwable)exception);
            return 0;
        }
    }

    @Override
    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
    }
}

