/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.smartcardhsmprovider;

import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMECKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKey;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.interfaces.ECPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECFieldFp;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.EllipticCurve;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyAgreementSpi;
import javax.crypto.SecretKey;
import javax.crypto.ShortBufferException;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartCardHSMKeyAgreement
extends KeyAgreementSpi {
    private static final Logger log = LoggerFactory.getLogger(SmartCardHSMKeyAgreement.class);
    private SmartCardHSMCardService schsm;
    private SmartCardHSMKey privateKey;
    private ECParameterSpec ecparam;
    private boolean finishedKeyAgreement;
    private byte[] secret;

    public SmartCardHSMKeyAgreement(SmartCardHSMProvider smartCardHSMProvider, String string) {
        this.schsm = smartCardHSMProvider.getSmartCardHSMCardService();
        if (!smartCardHSMProvider.isVerified()) {
            throw new ProviderException("Login required.");
        }
    }

    @Override
    protected Key engineDoPhase(Key key, boolean bl) throws InvalidKeyException, IllegalStateException {
        byte[] byArray = null;
        try {
            byArray = this.schsm.performECCDH(this.privateKey, this.getPublicKeyComponents(key));
        }
        catch (CardServiceException cardServiceException) {
            log.error(cardServiceException.getLocalizedMessage(), (Throwable)cardServiceException);
            throw new ProviderException(cardServiceException);
        }
        catch (CardTerminalException cardTerminalException) {
            log.error(cardTerminalException.getLocalizedMessage(), (Throwable)cardTerminalException);
            throw new ProviderException(cardTerminalException);
        }
        int n = (byArray.length - 1) / 2;
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        System.arraycopy(byArray, 1, byArray2, 0, n);
        System.arraycopy(byArray, 1 + n, byArray3, 0, n);
        ECPoint eCPoint = new ECPoint(new BigInteger(byArray2), new BigInteger(byArray3));
        PublicKey publicKey = null;
        try {
            ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(eCPoint, this.ecparam);
            KeyFactory keyFactory = KeyFactory.getInstance("EC");
            publicKey = keyFactory.generatePublic(eCPublicKeySpec);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            log.error(noSuchAlgorithmException.getLocalizedMessage(), (Throwable)noSuchAlgorithmException);
            throw new ProviderException(noSuchAlgorithmException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            log.error(invalidKeySpecException.getLocalizedMessage(), (Throwable)invalidKeySpecException);
            throw new ProviderException(invalidKeySpecException);
        }
        if (bl) {
            this.finishedKeyAgreement = true;
            this.secret = byArray;
        }
        return publicKey;
    }

    @Override
    protected byte[] engineGenerateSecret() throws IllegalStateException {
        if (!this.finishedKeyAgreement) {
            throw new IllegalStateException("Can't genereate secret when this isn't the last phase.");
        }
        return this.secret;
    }

    @Override
    protected SecretKey engineGenerateSecret(String string) throws IllegalStateException, NoSuchAlgorithmException, InvalidKeyException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int engineGenerateSecret(byte[] byArray, int n) throws IllegalStateException, ShortBufferException {
        if (!this.finishedKeyAgreement) {
            throw new IllegalStateException("Can't genereate secret when this isn't the last phase.");
        }
        if (this.secret.length + n > byArray.length) {
            throw new ShortBufferException("The input buffer is too short");
        }
        System.arraycopy(this.secret, 0, byArray, n, this.secret.length);
        return byArray.length;
    }

    @Override
    protected void engineInit(Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (!(key instanceof SmartCardHSMKey)) {
            throw new InvalidKeyException("Key must be type of SmartCardHSMECKey");
        }
        this.privateKey = (SmartCardHSMKey)key;
        BigInteger bigInteger = new BigInteger("A9FB57DBA1EEA9BC3E660A909D838D726E3BF623D52620282013481D1F6E5377", 16);
        ECFieldFp eCFieldFp = new ECFieldFp(bigInteger);
        BigInteger bigInteger2 = new BigInteger("7D5A0975FC2C3057EEF67530417AFFE7FB8055C126DC5C6CE94A4B44F330B5D9", 16);
        BigInteger bigInteger3 = new BigInteger("26DC5C6CE94A4B44F330B5D9BBD77CBF958416295CF7E1CE6BCCDC18FF8C07B6", 16);
        EllipticCurve ellipticCurve = new EllipticCurve(eCFieldFp, bigInteger2, bigInteger3);
        BigInteger bigInteger4 = new BigInteger("8BD2AEB9CB7E57CB2C4B482FFC81B7AFB9DE27E1E3BD23C23A4453BD9ACE3262", 16);
        BigInteger bigInteger5 = new BigInteger("547EF835C3DAC4FD97F8461A14611DC9C27745132DED8E545C1D54C72F046997", 16);
        ECPoint eCPoint = new ECPoint(bigInteger4, bigInteger5);
        BigInteger bigInteger6 = new BigInteger("A9FB57DBA1EEA9BC3E660A909D838D718C397AA3B561A6F7901E0E82974856A7", 16);
        int n = 1;
        this.ecparam = new ECParameterSpec(ellipticCurve, eCPoint, bigInteger6, n);
    }

    @Override
    protected void engineInit(Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (!(key instanceof SmartCardHSMECKey)) {
            throw new InvalidKeyException("Key must be type of SmartCardHSMECKey");
        }
        this.privateKey = (SmartCardHSMECKey)key;
        if (!(algorithmParameterSpec instanceof ECParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Parameter must be type of ECParameterSpec");
        }
        this.ecparam = (ECParameterSpec)algorithmParameterSpec;
    }

    private byte[] getPublicKeyComponents(Key key) throws InvalidKeyException {
        if (key instanceof ECPublicKey) {
            ECPublicKey eCPublicKey = (ECPublicKey)key;
            ECPoint eCPoint = eCPublicKey.getW();
            BigInteger bigInteger = eCPoint.getAffineX();
            BigInteger bigInteger2 = eCPoint.getAffineY();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(4);
            try {
                byteArrayOutputStream.write(SmartCardHSMKeyAgreement.unsignedBigIntegerToByteArray(bigInteger, 256));
                byteArrayOutputStream.write(SmartCardHSMKeyAgreement.unsignedBigIntegerToByteArray(bigInteger2, 256));
            }
            catch (IOException iOException) {
                log.error(iOException.getLocalizedMessage(), (Throwable)iOException);
                throw new ProviderException(iOException);
            }
            return byteArrayOutputStream.toByteArray();
        }
        throw new InvalidKeyException("Key must be type of ECPublicKey");
    }

    protected static byte[] unsignedBigIntegerToByteArray(BigInteger bigInteger, int n) {
        byte[] byArray = bigInteger.toByteArray();
        n = (n >> 3) + ((n & 7) == 0 ? 0 : 1);
        byte[] byArray2 = new byte[n];
        int n2 = n - byArray.length;
        int n3 = 0;
        if (n2 < 0) {
            if (n2 < -1 || byArray[0] != 0) {
                throw new IllegalArgumentException("Size mismatch converting big integer to byte array");
            }
            n3 = -n2;
            n2 = 0;
        }
        System.arraycopy(byArray, n3, byArray2, n2, n -= n2);
        return byArray2;
    }
}

