/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.smartcardhsmprovider;

import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKey;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import de.cardcontact.tlv.ConstructedTLV;
import de.cardcontact.tlv.PrimitiveTLV;
import de.cardcontact.tlv.TLV;
import de.cardcontact.tlv.TLVEncodingException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import opencard.opt.iso.fs.CardFilePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmartCardHSMCipher
extends CipherSpi {
    private static final Logger log = LoggerFactory.getLogger(SmartCardHSMCipher.class);
    private SmartCardHSMCardService schsm;
    private int selectedMode;
    private String algorithm;
    private ByteArrayOutputStream input;
    private SmartCardHSMKey key;
    private SmartCardHSMProvider provider;

    public SmartCardHSMCipher(SmartCardHSMProvider smartCardHSMProvider, String string) {
        this.provider = smartCardHSMProvider;
        this.schsm = smartCardHSMProvider.getSmartCardHSMCardService();
        this.algorithm = string;
        if (!smartCardHSMProvider.isVerified()) {
            throw new ProviderException("Login required.");
        }
    }

    protected byte[] decipher() {
        Object object;
        byte by;
        switch (this.algorithm) {
            case "RSA/None/PKCS1Padding": 
            case "RSA/ECB/PKCS1Padding": {
                by = 34;
                break;
            }
            case "RSA/ECB/OAEPWithSHA-1AndMGF1Padding": {
                by = 35;
                break;
            }
            default: {
                by = 33;
            }
        }
        try {
            object = this.schsm.decipher(this.key, this.input.toByteArray(), by);
        }
        catch (CardTerminalException cardTerminalException) {
            log.error(cardTerminalException.getLocalizedMessage(), (Throwable)cardTerminalException);
            throw new ProviderException(cardTerminalException);
        }
        catch (CardServiceException cardServiceException) {
            log.error(cardServiceException.getLocalizedMessage(), (Throwable)cardServiceException);
            throw new ProviderException(cardServiceException);
        }
        return object;
    }

    @Override
    protected byte[] engineDoFinal(byte[] byArray, int n, int n2) throws IllegalBlockSizeException, BadPaddingException {
        if (byArray != null) {
            if (this.input.size() + n2 > this.key.getKeySize() / 8) {
                throw new ProviderException("Input Data exceeds the lenght of the modulus");
            }
            this.input.write(byArray, n, n2);
        }
        byte[] byArray2 = this.decipher();
        this.selectedMode = -1;
        this.input.reset();
        this.input = null;
        return byArray2;
    }

    @Override
    protected int engineDoFinal(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        byte[] byArray3 = this.engineDoFinal(byArray, n, n2);
        if (byArray3.length > byArray2.length - n3) {
            throw new ShortBufferException("The output buffer is too short");
        }
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        return byArray3.length;
    }

    @Override
    protected int engineGetBlockSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected byte[] engineGetIV() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int engineGetOutputSize(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected AlgorithmParameters engineGetParameters() {
        return null;
    }

    @Override
    protected void engineInit(int n, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        if (n != 2 && n != 3 && n != 4) {
            throw new UnsupportedOperationException("Only Decryption, Wrap and Unwrap mode are supported");
        }
        this.selectedMode = n;
        if (n != 3 && n != 4) {
            if (!(key instanceof SmartCardHSMKey)) {
                throw new InvalidKeyException("Key must be type of SmartCardHSMKey");
            }
            this.key = (SmartCardHSMKey)key;
            this.input = new ByteArrayOutputStream();
        }
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void engineInit(int n, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void engineSetMode(String string) throws NoSuchAlgorithmException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void engineSetPadding(String string) throws NoSuchPaddingException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected byte[] engineUpdate(byte[] byArray, int n, int n2) {
        if (this.input.size() + n2 > this.key.getKeySize()) {
            throw new ProviderException("Input Data exceeds the lenght of the modulus");
        }
        this.input.write(byArray, n, n2);
        return null;
    }

    @Override
    protected int engineUpdate(byte[] byArray, int n, int n2, byte[] byArray2, int n3) throws ShortBufferException {
        this.engineUpdate(byArray, n, n2);
        return 0;
    }

    @Override
    protected int engineGetKeySize(Key key) throws InvalidKeyException {
        if (key instanceof SmartCardHSMKey) {
            key = (SmartCardHSMKey)key;
            return ((SmartCardHSMKey)key).getKeySize();
        }
        throw new InvalidKeyException("Key must be type of SmartCardHSMKey");
    }

    @Override
    protected byte[] engineWrap(Key key) throws InvalidKeyException {
        ConstructedTLV constructedTLV;
        byte[] byArray;
        byte[] byArray2;
        CardFilePath cardFilePath;
        byte[] byArray3;
        if (this.selectedMode != 3) {
            throw new IllegalStateException("Cipher is not in wrap mode");
        }
        if (!(key instanceof SmartCardHSMKey)) {
            throw new InvalidKeyException("Key must be type of SmartCardHSMKey");
        }
        SmartCardHSMKey smartCardHSMKey = (SmartCardHSMKey)key;
        try {
            byArray3 = this.schsm.wrapKey(smartCardHSMKey.getKeyRef());
            cardFilePath = new CardFilePath(new byte[]{-60, smartCardHSMKey.getKeyRef()});
            byArray2 = this.schsm.read(cardFilePath, 0, -1);
            cardFilePath = new CardFilePath(new byte[]{-50, smartCardHSMKey.getKeyRef()});
            byArray = this.schsm.read(cardFilePath, 0, -1);
        }
        catch (CardServiceException cardServiceException) {
            log.error(cardServiceException.getLocalizedMessage(), (Throwable)cardServiceException);
            throw new ProviderException(cardServiceException);
        }
        catch (CardTerminalException cardTerminalException) {
            log.error(cardTerminalException.getLocalizedMessage(), (Throwable)cardTerminalException);
            throw new ProviderException(cardTerminalException);
        }
        try {
            constructedTLV = new ConstructedTLV(48);
            cardFilePath = new PrimitiveTLV(4, byArray3);
            PrimitiveTLV primitiveTLV = new PrimitiveTLV(byArray2);
            PrimitiveTLV primitiveTLV2 = new PrimitiveTLV(byArray);
            constructedTLV.add((TLV)cardFilePath);
            constructedTLV.add((TLV)primitiveTLV);
            constructedTLV.add((TLV)primitiveTLV2);
        }
        catch (TLVEncodingException tLVEncodingException) {
            log.error(tLVEncodingException.getLocalizedMessage(), (Throwable)tLVEncodingException);
            throw new ProviderException(tLVEncodingException);
        }
        return constructedTLV.getBytes();
    }

    @Override
    protected Key engineUnwrap(byte[] byArray, String string, int n) {
        if (this.selectedMode != 4) {
            throw new IllegalStateException("Cipher is not in unwrap mode");
        }
        byte[] byArray2 = null;
        byte[] byArray3 = null;
        byte[] byArray4 = null;
        try {
            ConstructedTLV constructedTLV = new ConstructedTLV(byArray);
            byArray2 = constructedTLV.get(0).getValue();
            byArray4 = constructedTLV.get(1).getBytes();
            byArray3 = constructedTLV.get(2).getValue();
            byte by = this.schsm.determineFreeKeyId();
            this.schsm.unwrapKey(by, byArray2);
            CardFilePath cardFilePath = new CardFilePath(new byte[]{-60, by});
            this.schsm.write(cardFilePath, 0, byArray4);
            cardFilePath = new CardFilePath(new byte[]{-50, by});
            this.schsm.write(cardFilePath, 0, byArray3);
            return this.schsm.addKey(by);
        }
        catch (CardTerminalException cardTerminalException) {
            log.error(cardTerminalException.getLocalizedMessage(), (Throwable)cardTerminalException);
            throw new ProviderException(cardTerminalException);
        }
        catch (CardServiceException cardServiceException) {
            log.error(cardServiceException.getLocalizedMessage(), (Throwable)cardServiceException);
            throw new ProviderException(cardServiceException);
        }
        catch (IOException iOException) {
            log.error(iOException.getLocalizedMessage(), (Throwable)iOException);
            throw new ProviderException(iOException);
        }
        catch (TLVEncodingException tLVEncodingException) {
            log.error(tLVEncodingException.getLocalizedMessage(), (Throwable)tLVEncodingException);
            throw new ProviderException(tLVEncodingException);
        }
    }
}

