/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.smartcardhsmprovider;

import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.security.ProviderException;
import java.security.SecureRandomSpi;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureRandom
extends SecureRandomSpi {
    private static final Logger log = LoggerFactory.getLogger(SecureRandom.class);
    private static final long serialVersionUID = -1130070973762733185L;
    private SmartCardHSMProvider provider;
    private SmartCardHSMCardService schsm;

    public SecureRandom(SmartCardHSMProvider smartCardHSMProvider, String string) {
        this.provider = smartCardHSMProvider;
        this.schsm = smartCardHSMProvider.getSmartCardHSMCardService();
    }

    @Override
    protected byte[] engineGenerateSeed(int n) {
        byte[] byArray = null;
        try {
            byArray = this.schsm.generateRandom(n);
        }
        catch (CardTerminalException cardTerminalException) {
            log.error(cardTerminalException.getLocalizedMessage(), (Throwable)cardTerminalException);
            throw new ProviderException(cardTerminalException);
        }
        catch (CardServiceException cardServiceException) {
            log.error(cardServiceException.getLocalizedMessage(), (Throwable)cardServiceException);
            throw new ProviderException(cardServiceException);
        }
        return byArray;
    }

    @Override
    protected void engineNextBytes(byte[] byArray) {
        try {
            byte[] byArray2 = this.schsm.generateRandom(byArray.length);
            System.arraycopy(byArray2, 0, byArray, 0, byArray2.length);
        }
        catch (CardTerminalException cardTerminalException) {
            log.error(cardTerminalException.getLocalizedMessage(), (Throwable)cardTerminalException);
            throw new ProviderException(cardTerminalException);
        }
        catch (CardServiceException cardServiceException) {
            log.error(cardServiceException.getLocalizedMessage(), (Throwable)cardServiceException);
            throw new ProviderException(cardServiceException);
        }
    }

    @Override
    protected void engineSetSeed(byte[] byArray) {
    }
}

