/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.smartcardhsmprovider;

import de.cardcontact.opencard.service.smartcardhsm.CertificateDescription;
import de.cardcontact.opencard.service.smartcardhsm.KeyDescription;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMECKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMECPrivateKeySpec;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMEntry;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMPrivateKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMPrivateKeySpec;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMRSAKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMRSAPrivateKeySpec;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMParameterSpec;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import de.cardcontact.tlv.cvc.CardVerifiableCertificate;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.HashMap;
import opencard.core.OpenCardException;
import opencard.opt.iso.fs.CardFilePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyPairGenerator {

    public static class EC
    extends Key {
        private static final Logger log = LoggerFactory.getLogger(EC.class);
        private SmartCardHSMECPrivateKeySpec spec;

        public EC(SmartCardHSMProvider smartCardHSMProvider, String string) {
            super(smartCardHSMProvider, string);
        }

        @Override
        public void initialize(int n, SecureRandom secureRandom) {
            ECGenParameterSpec eCGenParameterSpec;
            switch (n) {
                case 192: {
                    eCGenParameterSpec = new ECGenParameterSpec("secp192r1");
                    break;
                }
                case 256: {
                    eCGenParameterSpec = new ECGenParameterSpec("secp256r1");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported key size " + n);
                }
            }
            try {
                this.initialize(eCGenParameterSpec, secureRandom);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new IllegalArgumentException("Invalid algorithm", invalidAlgorithmParameterException);
            }
        }

        @Override
        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            log.trace("initialize(spec, random) called...");
            if (algorithmParameterSpec instanceof SmartCardHSMParameterSpec) {
                SmartCardHSMParameterSpec smartCardHSMParameterSpec = (SmartCardHSMParameterSpec)algorithmParameterSpec;
                this.label = smartCardHSMParameterSpec.getLabel();
                this.spec = (SmartCardHSMECPrivateKeySpec)smartCardHSMParameterSpec.getKeySpec();
            } else if (algorithmParameterSpec instanceof ECGenParameterSpec || algorithmParameterSpec instanceof ECParameterSpec) {
                this.label = null;
                this.spec = new SmartCardHSMECPrivateKeySpec(algorithmParameterSpec);
            } else {
                throw new InvalidAlgorithmParameterException("Spec is not an instance of SmartCardHSMPrivateKeySpec, ECGenParameterSpec or ECParameterSpec");
            }
            this.spec.setAlgorithm(this.getAlgorithmFromString(this.algorithm));
        }

        @Override
        public KeyPair generateKeyPair() {
            PublicKey publicKey = null;
            try {
                byte by = this.determineID();
                log.debug("Generating key pair with key ID: " + by);
                byte[] byArray = this.schsm.generateKeyPair(by, (SmartCardHSMPrivateKeySpec)this.spec);
                CardFilePath cardFilePath = new CardFilePath(new byte[]{-50, by});
                this.schsm.write(cardFilePath, 0, byArray);
                CardVerifiableCertificate cardVerifiableCertificate = new CardVerifiableCertificate("CVC", byArray);
                publicKey = cardVerifiableCertificate.getPublicKey();
                byte[] byArray2 = CertificateDescription.computeSubjectKeyID((PublicKey)publicKey);
                KeyDescription keyDescription = new KeyDescription(byArray2, this.label, (int)((short)this.spec.getKeySize()), KeyDescription.KeyTypes.EC);
                keyDescription.setKeyRef(by);
                this.schsm.storePRKD(by, keyDescription);
                this.privateKeyRef = new SmartCardHSMECKey(by, keyDescription.getTranslatedLabel(), (short)this.spec.getKeySize());
                if (this.spec.hasAlgorithmList()) {
                    this.privateKeyRef.setAlgorithms(this.spec.getAlgorithmList());
                }
                if (this.spec.hasKeyDomain()) {
                    this.privateKeyRef.setKeyDomain(this.spec.getKeyDomain());
                }
                this.privateKeyRef.setKeyId(byArray2);
                this.schsm.addKeyToMap((SmartCardHSMKey)this.privateKeyRef);
                this.schsm.addCertToMap((Certificate)cardVerifiableCertificate, true, by, this.label);
            }
            catch (OpenCardException openCardException) {
                log.error(openCardException.getLocalizedMessage(), (Throwable)openCardException);
                throw new ProviderException(openCardException);
            }
            catch (CertificateException certificateException) {
                log.error(certificateException.getLocalizedMessage(), (Throwable)certificateException);
                throw new ProviderException(certificateException);
            }
            catch (Exception exception) {
                log.error(exception.getLocalizedMessage(), (Throwable)exception);
                throw new ProviderException(exception);
            }
            return new KeyPair(publicKey, (PrivateKey)this.privateKeyRef);
        }

        private byte[] getAlgorithmFromString(String string) {
            HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
            hashMap.put("ECDSA-SHA-1", new byte[]{4, 0, 127, 0, 7, 2, 2, 2, 2, 1});
            hashMap.put("ECDSA-SHA-224", new byte[]{4, 0, 127, 0, 7, 2, 2, 2, 2, 2});
            hashMap.put("ECDSA-SHA-256", new byte[]{4, 0, 127, 0, 7, 2, 2, 2, 2, 3});
            return (byte[])hashMap.get(string);
        }
    }

    public static class RSA
    extends Key {
        private static final Logger log = LoggerFactory.getLogger(RSA.class);
        private SmartCardHSMRSAPrivateKeySpec spec;

        public RSA(SmartCardHSMProvider smartCardHSMProvider, String string) {
            super(smartCardHSMProvider, string);
        }

        @Override
        public KeyPair generateKeyPair() {
            PublicKey publicKey = null;
            try {
                byte by = this.determineID();
                log.debug("Generating key pair with key ID: " + by);
                byte[] byArray = this.schsm.generateKeyPair(by, (SmartCardHSMPrivateKeySpec)this.spec);
                CardFilePath cardFilePath = new CardFilePath(new byte[]{-50, by});
                this.schsm.write(cardFilePath, 0, byArray);
                CardVerifiableCertificate cardVerifiableCertificate = new CardVerifiableCertificate("CVC", byArray);
                publicKey = cardVerifiableCertificate.getPublicKey();
                byte[] byArray2 = CertificateDescription.computeSubjectKeyID((PublicKey)publicKey);
                KeyDescription keyDescription = new KeyDescription(byArray2, this.label, (int)((short)this.spec.getModulusSize()), KeyDescription.KeyTypes.RSA);
                keyDescription.setKeyRef(by);
                this.schsm.storePRKD(by, keyDescription);
                this.privateKeyRef = new SmartCardHSMRSAKey(by, keyDescription.getTranslatedLabel(), (short)this.spec.getModulusSize());
                if (this.spec.hasAlgorithmList()) {
                    this.privateKeyRef.setAlgorithms(this.spec.getAlgorithmList());
                }
                if (this.spec.hasKeyDomain()) {
                    this.privateKeyRef.setKeyDomain(this.spec.getKeyDomain());
                }
                this.privateKeyRef.setKeyId(byArray2);
                this.schsm.addKeyToMap((SmartCardHSMKey)this.privateKeyRef);
                this.schsm.addCertToMap((Certificate)cardVerifiableCertificate, true, by, this.label);
            }
            catch (OpenCardException openCardException) {
                log.error(openCardException.getLocalizedMessage(), (Throwable)openCardException);
                throw new ProviderException(openCardException);
            }
            catch (CertificateException certificateException) {
                log.error(certificateException.getLocalizedMessage(), (Throwable)certificateException);
                throw new ProviderException(certificateException);
            }
            return new KeyPair(publicKey, (PrivateKey)this.privateKeyRef);
        }

        @Override
        public void initialize(int n, SecureRandom secureRandom) {
            if (secureRandom != null) {
                throw new ProviderException("Setting a random number generator is not supported");
            }
            this.spec = new SmartCardHSMRSAPrivateKeySpec(n);
        }

        private void initialize(int n) {
            this.initialize(n, null);
        }

        @Override
        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            log.trace("Entering initialize");
            if (!(algorithmParameterSpec instanceof SmartCardHSMParameterSpec)) {
                throw new InvalidAlgorithmParameterException("Spec is not an instance of SmartCardHSMPrivateKeySpec");
            }
            this.label = ((SmartCardHSMParameterSpec)algorithmParameterSpec).getLabel();
            this.spec = (SmartCardHSMRSAPrivateKeySpec)((SmartCardHSMParameterSpec)algorithmParameterSpec).getKeySpec();
            this.spec.setAlgorithm(this.getAlgorithmFromString(this.algorithm));
        }

        private byte[] getAlgorithmFromString(String string) {
            HashMap<String, byte[]> hashMap = new HashMap<String, byte[]>();
            hashMap.put("PKCS1-v1-5-SHA-1", new byte[]{4, 0, 127, 0, 7, 2, 2, 2, 1, 1});
            hashMap.put("PKCS1-v1-5-SHA-256", new byte[]{4, 0, 127, 0, 7, 2, 2, 2, 1, 2});
            hashMap.put("PKCS1-PSS-SHA-1", new byte[]{4, 0, 127, 0, 7, 2, 2, 2, 1, 3});
            hashMap.put("PKCS1-PSS-SHA-256", new byte[]{4, 0, 127, 0, 7, 2, 2, 2, 1, 4});
            return (byte[])hashMap.get(string);
        }
    }

    public static abstract class Key
    extends KeyPairGeneratorSpi {
        protected static byte PRK_DEV_AUT = 0;
        protected SmartCardHSMCardService schsm;
        protected String label;
        protected SmartCardHSMPrivateKey privateKeyRef;
        protected String algorithm;

        public Key(SmartCardHSMProvider smartCardHSMProvider, String string) {
            this.schsm = smartCardHSMProvider.getSmartCardHSMCardService();
            this.algorithm = string;
            if (!smartCardHSMProvider.isVerified()) {
                throw new ProviderException("Login required.");
            }
        }

        protected byte determineID() throws OpenCardException {
            SmartCardHSMEntry smartCardHSMEntry = this.schsm.getSmartCardHSMEntry(this.label);
            if (smartCardHSMEntry == null) {
                return this.schsm.determineFreeKeyId();
            }
            throw new ProviderException("A key for label '" + this.label + "' does already exist");
        }
    }
}

