/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.smartcardhsmprovider;

import de.cardcontact.opencard.service.smartcardhsm.KeyDescription;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMCardService;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMSecretKey;
import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMSecretKeySpec;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMParameterSpec;
import de.cardcontact.smartcardhsmprovider.SmartCardHSMProvider;
import java.security.InvalidAlgorithmParameterException;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.KeyGeneratorSpi;
import javax.crypto.SecretKey;
import opencard.core.OpenCardException;
import opencard.core.service.CardServiceException;
import opencard.core.terminal.CardTerminalException;

public class KeyGenerator
extends KeyGeneratorSpi {
    private SmartCardHSMProvider provider;
    private SmartCardHSMCardService schsm;
    private SmartCardHSMParameterSpec spec;

    public KeyGenerator(SmartCardHSMProvider smartCardHSMProvider, String string) {
        this.provider = smartCardHSMProvider;
        this.schsm = smartCardHSMProvider.getSmartCardHSMCardService();
    }

    @Override
    protected void engineInit(SecureRandom secureRandom) {
        throw new ProviderException("engineInit(SecureRandom random) not supported");
    }

    @Override
    protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (secureRandom != null) {
            throw new ProviderException("Setting a random number generator is not supported");
        }
        if (!(algorithmParameterSpec instanceof SmartCardHSMParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Algorithm parameter must be instance of SmartCardHSMParameterSpec");
        }
        if (!(((SmartCardHSMParameterSpec)algorithmParameterSpec).getKeySpec() instanceof SmartCardHSMSecretKeySpec)) {
            throw new InvalidAlgorithmParameterException("SmartCardHSMParameterSpec must contain SmartCardHSMSecretKeySpec");
        }
        this.spec = (SmartCardHSMParameterSpec)algorithmParameterSpec;
    }

    @Override
    protected void engineInit(int n, SecureRandom secureRandom) {
        throw new ProviderException("engineInit(SecureRandom random) not supported");
    }

    @Override
    protected SecretKey engineGenerateKey() {
        Object object;
        Object object2;
        byte by;
        SmartCardHSMSecretKeySpec smartCardHSMSecretKeySpec = (SmartCardHSMSecretKeySpec)this.spec.getKeySpec();
        byte[] byArray = null;
        try {
            by = this.schsm.determineFreeKeyId();
            byArray = this.schsm.generateKey(by, smartCardHSMSecretKeySpec);
        }
        catch (OpenCardException openCardException) {
            throw new ProviderException("Generating key failed", openCardException);
        }
        byte[] byArray2 = smartCardHSMSecretKeySpec.getAlgorithmList();
        boolean bl = false;
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] != -103) continue;
            bl = true;
            break;
        }
        byte[] byArray3 = null;
        if (bl) {
            object2 = "KeyCheckValue".getBytes();
            try {
                object = this.schsm.deriveSymmetricKey(by, (byte)-103, object2);
            }
            catch (CardServiceException | CardTerminalException throwable) {
                throw new ProviderException("Deriving KCV failed", throwable);
            }
            byArray3 = new byte[8];
            System.arraycopy(object, 0, byArray3, 0, byArray3.length);
        }
        object2 = new KeyDescription(byArray3, this.spec.getLabel(), 0, KeyDescription.KeyTypes.AES);
        object2.setKeyRef(by);
        try {
            this.schsm.storePRKD(by, (KeyDescription)object2);
        }
        catch (OpenCardException openCardException) {
            throw new ProviderException("Writing key description failed", openCardException);
        }
        object = new SmartCardHSMSecretKey(by, object2.getTranslatedLabel(), (short)smartCardHSMSecretKeySpec.getKeySize(), "AES");
        object.setAlgorithms(byArray2);
        if (smartCardHSMSecretKeySpec.hasKeyDomain()) {
            object.setKeyDomain(smartCardHSMSecretKeySpec.getKeyDomain());
        }
        if (byArray != null && byArray.length > 0) {
            object.setWrapCryptogram(byArray);
        }
        if (byArray3 != null) {
            object.setKeyId(byArray3);
        }
        this.schsm.addKeyToMap((SmartCardHSMKey)object);
        return object;
    }
}

