/**
 *  ---------
 * |.##> <##.|  SmartCard-HSM Support Scripts
 * |#       #|
 * |#       #|  Copyright (c) 2011-2012 CardContact Software & System Consulting
 * |'##> <##'|  Andreas Schwier, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 * Consult your license package for usage terms and conditions.
 *
 * @fileoverview Post Issuance Functions
 */

var SCPAuthenticator = require("scsh/perso/SCPAuthenticator").SCPAuthenticator;



function Initializer(job) {
	this.job = job;
	this.authenticator = new SCPAuthenticator(CustomerKeys[job.Keys]);

	this.aid = new ByteString("A000000151000000", HEX);

	this.af = new ApplicationFactory(new Crypto());
	this.af.addApplicationProfile("scsh/perso/ap_jcop_cardmanager.xml");
}

exports.Initializer = Initializer;

Initializer.type = "initializer";



Initializer.prototype.handleCard = function(card) {

	card.reset(Card.RESET_COLD);

	var data = {
		applAid: new ByteString("E82B0601040181C31F0201", HEX)
	};

	var dm = {
		get: function(name, fixed, length, encoding) {
			if (typeof(data[name]) == "undefined") {
				return null;
			}

			return data[name];
		}
	}

	var appl = this.af.getApplicationInstance(dm, this.aid, card, this.job.Profile);
	appl.keyProvider = this.authenticator;

	for (var i = 0; i < this.job.Steps.length; i++) {
		appl.run(this.job.Steps[i]);
	}

	return "OK";
}



Initializer.prototype.configure = function() {
}
