/**
 *  ---------
 * |.##> <##.|  SmartCard-HSM Support Scripts
 * |#       #|
 * |#       #|  Copyright (c) 2011-2012 CardContact Software & System Consulting
 * |'##> <##'|  Andreas Schwier, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 * Consult your license package for usage terms and conditions.
 *
 * @fileoverview DICA Task
 */



function DICATask(card, url) {
	this.card = card;
	this.url = url;
	this.task = new Task(this);
	this.task.setContextMenu([ "Stop" ]);
}

exports.DICATask = DICATask;



DICATask.prototype.start = function() {
	this.running = true;
	this.task.start();
}



DICATask.prototype.stop = function() {
	this.running = false;
	this.task.stop();
	this.task.dispose();
	this.task = undefined;
}



DICATask.prototype.run = function() {
	try 	{
		this.card.remoteUpdate(this.url);
	}
	catch(e) {
		GPSystem.log(GPSystem.ERROR, "DICATask", e);
		this.task.setMessage(this.reader + " : " + e.message);
		throw e;
	}
	finally {
		if (this.card) {
			this.card.close();
		}
	}
}



DICATask.prototype.actionListener = function(source, action) {
	switch(action) {
	case "Stop":
		this.card.cancelRemoteUpdate();
		Card.setCardEventListener();
		this.stop();
		break;
	}
}



DICATask.prototype.notify = function() {
	this.task.setMessage(this.reader + " : " + this.card.remoteMessage + "(" + this.card.remoteMessageId + ")");
}



DICATask.prototype.toString = function() {
	return "DICA connected to " + this.url;
}
