/**
 *  ---------
 * |.##> <##.|  SmartCard-HSM Support Scripts
 * |#       #|
 * |#       #|  Copyright (c) 2011-2012 CardContact Software & System Consulting
 * |'##> <##'|  Andreas Schwier, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 * Consult your license package for usage terms and conditions.
 *
 * @fileoverview Card Task
 */



function CardTask(scheduler, reader) {
	this.scheduler = scheduler;
	this.reader = reader;

	this.task = new Task(this);
}

exports.CardTask = CardTask;



CardTask.prototype.start = function() {
	this.running = true;
	this.task.start();
}



CardTask.prototype.stop = function() {
	this.running = false;
	this.task.stop();
	this.task.dispose();
	this.task = undefined;
}



CardTask.prototype.run = function() {
	try 	{
		this.card = new Card(this.reader);
		this.card.reset(Card.RESET_COLD);

		var msg = this.scheduler.handleCard(this.card);
		this.task.setMessage(this.reader + " : " + msg);
	}
	catch(e) {
		GPSystem.log(GPSystem.ERROR, "CardTask", e);
		this.task.setMessage(this.reader + " : " + e.message);
		throw e;
	}
	finally {
		if (this.card) {
			this.card.close();
		}
	}
}



CardTask.prototype.notify = function() {
	this.task.setMessage(this.reader + " : " + this.card.remoteMessage + "(" + this.card.remoteMessageId + ")");
}



CardTask.prototype.toString = function() {
	return this.reader;
}
