/**
 *  ---------
 * |.##> <##.|  Open Smart Card Development Platform (www.openscdp.org)
 * |#       #|
 * |#       #|  Copyright (c) 1999-2023 CardContact Software & System Consulting
 * |'##> <##'|  Andreas Schwier, 32429 Minden, Germany (www.cardcontact.de)
 *  ---------
 *
 *  This file is part of OpenSCDP.
 *
 *  OpenSCDP is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2 as
 *  published by the Free Software Foundation.
 *
 *  OpenSCDP is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with OpenSCDP; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *
 * @fileoverview Connector for the PKI-API
 */


function FormParser(form) {
    this.form = form;
}

exports.FormParser = FormParser;



FormParser.prototype.getFieldById = function(id) {
    for each (var section in this.form) {
        for each (var field in section.fields) {
            if (id == field.id) {
                return field;
            }
        }
    }
}



FormParser.prototype.enumerateOptions = function(field) {
    var list = [];
    for each (var option in field.options) {
        list.push(option.value);
    }
    return list;
}



FormParser.prototype.enumerateOptionIds = function(field) {
    var list = [];
    for each (var option in field.options) {
        list.push(option.id);
    }
    return list;
}



FormParser.prototype.selectStringOption = function(field, option) {
}



FormParser.test = function() {
    var form = [
    {
      "id": "token",
      "legend": "msg.sems.dica",
      "fields": [
        {
          "id": "issuer",
          "type": "select",
          "label": "msg.sems.issuer",
          "editable": true,
          "required": false,
          "value": 2,
          "options": [
            {
              "id": 2,
              "value": "UTDICA1",
              "selected": true
            },
            {
              "id": 5,
              "value": "UTDICA2",
              "selected": false
            },
            {
              "id": 12,
              "value": "UTDICA3",
              "selected": false
            },
            {
              "id": 14,
              "value": "UTDICA4",
              "selected": false
            },
            {
              "id": 15,
              "value": "UTDICA5",
              "selected": false
            }
          ],
          "multiSelect": false,
          "onchange": "this.form.submit()"
        },
        {
          "id": "process",
          "type": "select",
          "label": "msg.sems.process",
          "editable": true,
          "required": false,
          "value": "se-jcop",
          "options": [
            {
              "id": 0,
              "value": "se-jcop",
              "selected": true
            }
          ],
          "multiSelect": false
        },
        {
          "id": "hardware",
          "type": "select",
          "label": "msg.sems.hardware",
          "editable": true,
          "required": false,
          "value": "Default",
          "options": [
            {
              "id": 0,
              "value": "Default",
              "selected": true
            }
          ],
          "multiSelect": false
        },
        {
          "id": "kmc",
          "type": "select",
          "label": "msg.sems.kmc",
          "editable": true,
          "required": false,
          "value": "Default",
          "options": [
            {
              "id": 0,
              "value": "Default",
              "selected": true
            }
          ],
          "multiSelect": false
        }
      ]
    }
    ];

    var p = new FormParser(form);
    var fld = p.getFieldById("process");
    print(p.enumerateOptions(fld));

    var fld = p.getFieldById("issuer");
    print(p.enumerateOptionIds(fld));
}
