/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.scriptingserver;

import de.cardcontact.scdp.engine.Engine;
import de.cardcontact.scdp.js.GPTracer;
import jakarta.servlet.http.HttpSession;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.openscdp.scriptingserver.ScriptingEngine;
import org.openscdp.scriptingserver.js.JsHttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CardUpdate
implements Runnable {
    final Logger logger = LoggerFactory.getLogger(CardUpdate.class);
    private ScriptingEngine scriptingEngine;
    private HttpSession session;
    private String pathInfo;
    private String queryInfo;

    public CardUpdate(ScriptingEngine engine, HttpSession session, String pathInfo, String queryInfo) {
        this.scriptingEngine = engine;
        this.session = session;
        this.pathInfo = pathInfo;
        this.queryInfo = queryInfo;
    }

    private JsHttpSession getSession(Context cx, Scriptable scope) {
        Object o = this.session.getAttribute("HttpSession");
        if (o != null) {
            return (JsHttpSession)((Object)o);
        }
        Object[] param = new Object[]{this.session};
        JsHttpSession jssession = (JsHttpSession)cx.newObject(scope, "HttpSession", param);
        this.session.setAttribute("HttpSession", (Object)jssession);
        return jssession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Engine engine = this.scriptingEngine.getEngine();
        Scriptable scope = engine.newDynamicScope("Object");
        Object o = ScriptableObject.getProperty((Scriptable)scope, (String)"performCardUpdate");
        Function handler = (Function)o;
        try {
            Context ctx = Context.enter();
            GPTracer tracer = this.scriptingEngine.newGPTracer();
            engine.setTracerForContext(ctx, tracer);
            Object[] argcall = new Object[]{this.getSession(ctx, scope), this.pathInfo, this.queryInfo};
            handler.call(ctx, scope, scope, argcall);
            this.scriptingEngine.countInvocation();
        }
        catch (RhinoException re) {
            String msg = this.scriptingEngine.handleRhinoExceptionMessage(re);
            this.logger.error(msg);
        }
        catch (Exception e) {
            this.logger.error("Card access exception", (Throwable)e);
        }
        finally {
            Context.exit();
        }
    }
}

