/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.scriptingserver;

import de.cardcontact.scdp.engine.Engine;
import de.cardcontact.scdp.js.GPTracer;
import jakarta.servlet.ServletException;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.openscdp.scriptingserver.ScriptingEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptingServlet
extends HttpServlet {
    private static final long serialVersionUID = 1360031552642091977L;
    private ScriptingEngine scriptingEngine;
    final Logger logger = LoggerFactory.getLogger(ScriptingServlet.class);

    public void init() throws UnavailableException {
        this.scriptingEngine = (ScriptingEngine)this.getServletContext().getAttribute("scriptingEngine");
        if (this.scriptingEngine == null) {
            throw new UnavailableException("Attribute scriptingEngine not found in ServletContext");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Engine engine = this.scriptingEngine.getEngine();
        if (!this.scriptingEngine.isHandlerDefined()) {
            this.logger.error("Method handleRequest() not found in global scope. Can not handle service requests.");
            resp.sendError(500, "Method handleRequest() not found in global scope. Can not handle service requests.");
            return;
        }
        Scriptable scope = engine.newDynamicScope("Object");
        Object o = ScriptableObject.getProperty((Scriptable)scope, (String)"handleRequest");
        Function handler = (Function)o;
        try {
            Context ctx = Context.enter();
            GPTracer tracer = this.scriptingEngine.newGPTracer();
            engine.setTracerForContext(ctx, tracer);
            Object[] argreq = new Object[]{req};
            Scriptable reqobj = ctx.newObject(scope, "HttpRequest", argreq);
            Object[] argres = new Object[]{resp};
            Scriptable resobj = ctx.newObject(scope, "HttpResponse", argres);
            Object[] argcall = new Object[]{reqobj, resobj};
            handler.call(ctx, scope, scope, argcall);
            this.scriptingEngine.countInvocation();
        }
        catch (RhinoException re) {
            String msg = this.scriptingEngine.handleRhinoExceptionMessage(re);
            this.logger.error(msg);
            resp.sendError(500, msg);
        }
        catch (Exception e) {
            this.logger.error("Service exception", (Throwable)e);
            resp.sendError(500, e.getMessage());
        }
        finally {
            Context.exit();
        }
    }
}

