/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.scriptingserver.jetty;

import de.cardcontact.opencard.web.RemoteTerminalServlet;
import de.cardcontact.scdp.engine.LogbackInitializer;
import jakarta.servlet.DispatcherType;
import jakarta.servlet.Filter;
import jakarta.servlet.Servlet;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.List;
import java.util.Properties;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.DefaultServlet;
import org.eclipse.jetty.servlet.FilterHolder;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.openscdp.scriptingserver.AdminServlet;
import org.openscdp.scriptingserver.ContextListener;
import org.openscdp.scriptingserver.ScriptingServlet;
import org.openscdp.scriptingserver.jetty.WEBINFFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Launcher {
    static Logger log = LoggerFactory.getLogger(Launcher.class);
    Server server;
    String userDir;
    Properties config = null;

    void configurePorts() throws Exception {
        String[] portlist;
        Object key = "scriptingserver.ports";
        String list = this.config.getProperty((String)key);
        if (list == null) {
            throw new Exception("Could not find property " + (String)key + " with list of ports");
        }
        for (String portname : portlist = list.split("\\,")) {
            key = "scriptingserver." + portname + ".port";
            String v = this.config.getProperty((String)key);
            if (v == null) {
                throw new Exception("Could not find property " + (String)key);
            }
            int port = Integer.parseInt(v);
            key = "scriptingserver." + portname + ".host";
            String host = v = this.config.getProperty((String)key);
            ServerConnector scc = new ServerConnector(this.server);
            scc.setPort(port);
            scc.setName(portname);
            scc.setHost(host);
            this.server.addConnector((Connector)scc);
        }
    }

    void loadConfig() {
        String fname;
        File file;
        this.userDir = System.getenv("SCRIPTINGSERVER_USERDIR");
        if (this.userDir == null) {
            this.userDir = System.getProperty("user.dir");
        }
        if ((file = new File(fname = this.userDir + "/etc/logback.xml")).exists()) {
            LogbackInitializer.init((String)fname);
        }
        this.config = new Properties();
        file = new File(this.userDir + "/etc/server.conf");
        try {
            FileInputStream fi = new FileInputStream(file);
            this.config.load(fi);
            fi.close();
        }
        catch (Exception e) {
            System.out.println("Using default configuration\n");
            this.config.put("scriptingserver.ports", "mainport,adminport");
            this.config.put("scriptingserver.mainport.port", "8080");
            this.config.put("scriptingserver.mainport.host", "127.0.0.1");
            this.config.put("scriptingserver.adminport.port", "8088");
            this.config.put("scriptingserver.adminport.host", "127.0.0.1");
        }
    }

    protected void configureDefaultSSLContext() throws Exception {
        String ksPath;
        TrustManager[] tm = null;
        KeyManager[] km = null;
        String key = "scriptingserver.tls.truststore";
        String tsPath = this.config.getProperty(key);
        if (tsPath != null) {
            key = "scriptingserver.tls.truststorepassword";
            String tsPw = this.config.getProperty(key);
            if (tsPw == null) {
                throw new Exception("Could not find property " + key);
            }
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try (FileInputStream fis = new FileInputStream(this.userDir + "/" + tsPath);){
                trustStore.load(fis, tsPw.toCharArray());
            }
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(trustStore);
            tm = tmf.getTrustManagers();
        }
        if ((ksPath = this.config.getProperty(key = "scriptingserver.tls.keystore")) != null) {
            key = "scriptingserver.tls.keystorepassword";
            String ksPw = this.config.getProperty(key);
            if (ksPw == null) {
                throw new Exception("Could not find property " + key);
            }
            key = "scriptingserver.tls.keystorekeypassword";
            String ksKeyPw = this.config.getProperty(key);
            KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
            try (FileInputStream fis = new FileInputStream(this.userDir + "/" + ksPath);){
                keyStore.load(fis, ksPw.toCharArray());
            }
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            char[] keyPw = null;
            if (ksKeyPw != null) {
                keyPw = ksKeyPw.toCharArray();
            }
            kmf.init(keyStore, keyPw);
            km = kmf.getKeyManagers();
        }
        if (tm != null || km != null) {
            log.info("Set a new default SSL context");
            SSLContext ctx = SSLContext.getInstance("TLS");
            ctx.init(km, tm, null);
            SSLContext.setDefault(ctx);
        }
    }

    void initServer(String[] args) throws Exception {
        this.server = new Server();
        this.configurePorts();
        ServletContextHandler context = new ServletContextHandler(1);
        context.addEventListener((EventListener)((Object)new ContextListener()));
        context.setContextPath("/");
        List<String> cmdargs = Arrays.asList(args);
        if (cmdargs.contains("--shell")) {
            context.setInitParameter("shell", "");
        }
        if (cmdargs.contains("--pcsc")) {
            context.setInitParameter("pcsc", "");
        }
        if (cmdargs.contains("--priobc")) {
            context.setInitParameter("priobc", "");
        }
        String webContent = null;
        String userDir = System.getenv("SCRIPTINGSERVER_USERDIR");
        if (userDir != null) {
            String fname = userDir + "/static";
            File file = new File(fname);
            if (file.exists()) {
                webContent = file.getAbsolutePath();
            }
            context.setInitParameter("userDir", userDir);
        }
        URL url = Launcher.class.getClassLoader().getResource("WebContent");
        if (webContent == null && url != null) {
            webContent = url.toExternalForm();
        }
        if (url == null) {
            String fname;
            File file;
            String cwd = System.getProperty("user.dir");
            if (webContent == null && cwd != null && (file = new File(fname = cwd + "/static")).exists()) {
                webContent = file.getAbsolutePath();
            }
            context.setInitParameter("sysDir", cwd);
        }
        if (webContent != null) {
            log.info("Setting resource base to " + webContent);
            context.setResourceBase(webContent);
        }
        this.server.setHandler((Handler)context);
        context.setInitParameter("standalone", "true");
        context.addServlet(new ServletHolder((Servlet)new AdminServlet()), "/admin/*");
        context.addServlet(new ServletHolder((Servlet)new ScriptingServlet()), "/se/*");
        RemoteTerminalServlet rts = new RemoteTerminalServlet();
        context.addServlet(new ServletHolder((Servlet)rts), "/rt/*");
        SessionHandler sh = context.getSessionHandler();
        sh.setMaxInactiveInterval(1800);
        sh.setSameSite(HttpCookie.SameSite.STRICT);
        sh.addEventListener((EventListener)rts);
        ServletHolder h = new ServletHolder((Servlet)new DefaultServlet());
        context.addServlet(h, "/");
        context.addFilter(new FilterHolder((Filter)new WEBINFFilter()), "/*", EnumSet.of(DispatcherType.INCLUDE, DispatcherType.REQUEST));
    }

    void start(String[] args) {
        try {
            this.loadConfig();
            this.configureDefaultSSLContext();
            this.initServer(args);
            this.server.start();
            this.server.join();
        }
        catch (Exception e) {
            log.error("Problem starting server", (Throwable)e);
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        Launcher launcher = new Launcher();
        launcher.start(args);
    }
}

