/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.scriptingserver;

import jakarta.servlet.ServletContext;
import jakarta.servlet.UnavailableException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import org.mozilla.javascript.RhinoException;
import org.openscdp.scriptingserver.ScriptingEngine;

public class AdminServlet
extends HttpServlet {
    private static final long serialVersionUID = -5074383684785359362L;
    private ScriptingEngine scriptingEngine;
    private boolean scriptUploadAllowed = false;
    private int adminPort = 8088;

    public void init() throws UnavailableException {
        String adminPortStr;
        ServletContext ctx = this.getServletContext();
        String scriptUpload = ctx.getInitParameter("scriptUpload");
        if (scriptUpload != null) {
            this.scriptUploadAllowed = scriptUpload.equals("enabled");
        }
        if ((adminPortStr = ctx.getInitParameter("adminPort")) != null) {
            this.adminPort = Integer.parseInt(adminPortStr);
        }
        this.scriptingEngine = (ScriptingEngine)ctx.getAttribute("scriptingEngine");
        if (this.scriptingEngine == null) {
            throw new UnavailableException("Attribute scriptingEngine not found in ServletContext");
        }
    }

    public void deliverPage(HttpServletResponse resp, String body) throws IOException {
        resp.setContentType("text/html");
        PrintWriter out = resp.getWriter();
        String header = "<!DOCTYPE html PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">\n<html>\n<head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=ISO-8859-1\">\n<title>OpenSCDP Scripting Server</title>\n<link rel=stylesheet type=\"text/css\" href=\"../css/style.css\">\n<meta http-equiv=\"refresh\" content=\"30;\">\n</head>\n<body>\n<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" width=\"750\" align=\"center\">\n  <tr>\n    <td height=\"80\" colspan=\"5\" class=\"pb\"><div align=\"left\"><a href=\"http://www.cardcontact.de\"><img src=\"../images/banner.jpg\" width=\"750\" height=\"80\" border=\"0\"></a></div></td>\n  </tr>\n  <tr height=\"20\">\n  </tr>\n  <tr>\n    <td width=\"100\" valign=\"top\" align=\"left\">\n    <br>\n    <p><b>Scripting Server</b></p>\n    <a href=\"index.html\">Admin</a><br>\n    <a href=\"../doc/index.html\">Doc</a><br>\n    <a href=\"../admin?restart\">Restart</a><br>\n    <a href=\"../admin?clear\">Clear Error</a><br>\n    <a href=\"../se\">SE</a><br>\n    <br>\n    </td>\n    <td width=\"650\" align=\"left\">\n    <br/>\n";
        String footer = "<br>\n<p class=\"copyright\">&copy; Copyright 2003 - 2015 <a href=\"http://www.cardcontact.de\">CardContact</a> Software &amp; System Consulting, Minden, Germany</p>\n    </td>\n  </tr>\n</table>\n</body>\n</html>";
        out.println(header);
        out.println(body);
        out.println(footer);
        out.close();
    }

    public void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!this.scriptUploadAllowed) {
            resp.setStatus(403);
            String page = "<h1>Access denied</h1>\n<p>Script upload with POST or PUT disabled in configuration.</p>\n<p>Set scriptUpload in web.xml to \"enabled\" to allow.</p>\n";
            this.deliverPage(resp, page);
            return;
        }
        if (req.getServerPort() != this.adminPort) {
            resp.setStatus(403);
            String page = "<h1>Access denied</h1>\n<p>Administrative functions only allowed on admin port.</p>\n<p>See adminPort in web.xml for port configured. Default port is 8088.</p>\n";
            this.deliverPage(resp, page);
            return;
        }
        BufferedReader reader = req.getReader();
        try {
            String filename = req.getHeader("X-Content-Name");
            if (filename == null) {
                filename = "PostedOverHTTP";
            }
            this.scriptingEngine.runScript(reader, filename);
        }
        catch (RhinoException re) {
            resp.setStatus(500);
            String page = "<h1>Scripting exception: </h1>\n<pre>" + this.scriptingEngine.handleRhinoExceptionMessage(re) + "</pre>\n";
            this.deliverPage(resp, page);
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doPut(req, resp);
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String resource;
        if (req.getServerPort() != this.adminPort) {
            resp.setStatus(403);
            String page = "<h1>Access denied</h1>\n<p>Administrative functions only allowed on admin port.</p>\n<p>See adminPort in web.xml for port configured. Default port is 8088.</p>\n";
            this.deliverPage(resp, page);
            return;
        }
        String command = req.getQueryString();
        if (command != null) {
            if (command.equalsIgnoreCase("restart")) {
                this.scriptingEngine.startScriptingFramework();
                HttpSession session = req.getSession(false);
                if (session != null) {
                    session.invalidate();
                }
                resp.sendRedirect(req.getContextPath() + "/admin/index.html");
                return;
            }
            if (command.equalsIgnoreCase("clear")) {
                this.scriptingEngine.clearLastRhinoException();
                System.gc();
                resp.sendRedirect(req.getContextPath() + "/admin/index.html");
                return;
            }
        }
        if ((resource = req.getPathInfo()) == null || !resource.equals("/index.html")) {
            resp.sendRedirect(req.getContextPath() + "/admin/index.html");
            return;
        }
        String statusPage = "<h1>OpenSCDP Scripting Server " + this.scriptingEngine.getServerVersion() + "</h1>\n<h2>Server Status</h2>\n<p>" + this.scriptingEngine.getStatus() + "</p>\n<p>Total number of requests served: " + this.scriptingEngine.getInvocationCounter() + "</p>\n<p>Number of scripting exceptions: " + this.scriptingEngine.getExceptionCounter() + "</p>\n<h2>Last scripting exception</h2>\n<p>(" + String.valueOf(this.scriptingEngine.getLastRhinoExceptionTimestamp()) + ")</p>\n<pre>" + this.scriptingEngine.getLastRhinoExceptionMessage() + "</pre>\n<h2>Last scripting trace</h2>\n<pre>" + this.scriptingEngine.getLastTrace() + "</pre>\n<h2>Configuration script trace</h2>\n<pre>" + this.scriptingEngine.getDefaultTrace() + "</pre>\n";
        this.deliverPage(resp, statusPage);
    }
}

