/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.scriptingserver;

import de.cardcontact.scdp.engine.FileResourceLocatorFS;
import jakarta.servlet.ServletContext;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServletFileResourceLocator
extends FileResourceLocatorFS {
    static final Logger logger = LoggerFactory.getLogger(ServletFileResourceLocator.class);
    private static final String WEBPREFIX = "/WEB-INF/js";
    protected ServletContext servletContext;
    private String webPrefix;

    public ServletFileResourceLocator(ServletContext ctx) {
        this.servletContext = ctx;
        this.systemDir = new File(WEBPREFIX);
        this.webPrefix = this.systemDir.getAbsolutePath();
        String userDir = System.getenv("SCRIPTINGSERVER_USERDIR");
        if (userDir == null) {
            userDir = this.servletContext.getInitParameter("userDir");
        }
        userDir = userDir == null ? WEBPREFIX : userDir.concat(ctx.getContextPath());
        this.currentWorkingDir = this.userDir = new File(userDir);
        logger.debug("GPSystem.SYS is set to " + String.valueOf(this.systemDir));
        logger.debug("GPSystem.USR is set to " + String.valueOf(this.userDir));
        logger.debug("/WEB-INF/js is replaced by " + this.webPrefix);
    }

    public InputStream openFileResource(String fileName, boolean changeContext) throws FileNotFoundException {
        InputStream is = null;
        File f = new File(fileName);
        if (fileName.startsWith(this.webPrefix)) {
            String fn = WEBPREFIX.concat(fileName.substring(this.webPrefix.length()));
            fn = fn.replace('\\', '/');
            is = this.servletContext.getResourceAsStream(fn);
        } else {
            is = new FileInputStream(f);
        }
        if (changeContext) {
            this.currentWorkingDir = f.getParentFile();
        }
        return is;
    }

    public boolean exists(String fn) {
        if (fn.startsWith(this.webPrefix)) {
            try {
                String filename = WEBPREFIX.concat(fn.substring(this.webPrefix.length()));
                filename = filename.replace('\\', '/');
                return this.servletContext.getResource(filename) != null;
            }
            catch (MalformedURLException e) {
                return false;
            }
        }
        return new File(fn).exists();
    }
}

