/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.scriptingserver.js;

import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.utils.ArgChecker;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JsHttpResponse
extends ScriptableObject {
    private static final long serialVersionUID = -8695644249516295841L;
    public static final String clazzName = "HttpResponse";
    private HttpServletResponse nativeResponse;

    public String getClassName() {
        return clazzName;
    }

    public static void finishInit(Scriptable scope, FunctionObject ctor, Scriptable proto) {
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_ACCEPTED", (Object)new Integer(202), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_BAD_GATEWAY", (Object)new Integer(502), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_BAD_REQUEST", (Object)new Integer(400), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_CONFLICT", (Object)new Integer(409), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_CONTINUE", (Object)new Integer(100), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_CREATED", (Object)new Integer(201), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_EXPECTATION_FAILED", (Object)new Integer(417), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_FORBIDDEN", (Object)new Integer(403), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_FOUND", (Object)new Integer(302), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_GATEWAY_TIMEOUT", (Object)new Integer(504), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_GONE", (Object)new Integer(410), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_HTTP_VERSION_NOT_SUPPORTED", (Object)new Integer(505), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_INTERNAL_SERVER_ERROR", (Object)new Integer(500), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_LENGTH_REQUIRED", (Object)new Integer(411), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_METHOD_NOT_ALLOWED", (Object)new Integer(405), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_MOVED_PERMANENTLY", (Object)new Integer(301), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_MOVED_TEMPORARILY", (Object)new Integer(302), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_MULTIPLE_CHOICES", (Object)new Integer(300), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_NO_CONTENT", (Object)new Integer(204), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_NON_AUTHORITATIVE_INFORMATION", (Object)new Integer(203), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_NOT_ACCEPTABLE", (Object)new Integer(406), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_NOT_FOUND", (Object)new Integer(404), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_NOT_IMPLEMENTED", (Object)new Integer(501), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_NOT_MODIFIED", (Object)new Integer(304), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_OK", (Object)new Integer(200), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_PARTIAL_CONTENT", (Object)new Integer(206), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_PAYMENT_REQUIRED", (Object)new Integer(402), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_PRECONDITION_FAILED", (Object)new Integer(412), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_PROXY_AUTHENTICATION_REQUIRED", (Object)new Integer(407), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_REQUEST_ENTITY_TOO_LARGE", (Object)new Integer(413), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_REQUEST_TIMEOUT", (Object)new Integer(408), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_REQUEST_URI_TOO_LONG", (Object)new Integer(414), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_REQUESTED_RANGE_NOT_SATISFIABLE", (Object)new Integer(416), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_RESET_CONTENT", (Object)new Integer(205), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_SEE_OTHER", (Object)new Integer(303), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_SERVICE_UNAVAILABLE", (Object)new Integer(503), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_SWITCHING_PROTOCOLS", (Object)new Integer(101), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_TEMPORARY_REDIRECT", (Object)new Integer(307), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_UNAUTHORIZED", (Object)new Integer(401), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_UNSUPPORTED_MEDIA_TYPE", (Object)new Integer(415), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SC_USE_PROXY", (Object)new Integer(305), (int)0);
    }

    public HttpServletResponse jsGet_nativeResponse() {
        return this.nativeResponse;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) {
        ArgChecker.checkRange((Scriptable)ctorObj, (String)clazzName, (Object[])args, (int)1, (int)1);
        if (!(args[0] instanceof HttpServletResponse)) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, (String)clazzName, (int)16, (int)0, (String)"Argument must be of type javax.servlet.http.HttpServletResponse");
        }
        JsHttpResponse t = new JsHttpResponse();
        t.nativeResponse = (HttpServletResponse)args[0];
        return t;
    }

    public static void jsFunction_addHeaderField(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)2, (int)2);
        String key = ArgChecker.getString((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)0, null);
        String value = ArgChecker.getString((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)1, null);
        JsHttpResponse t = (JsHttpResponse)thisObj;
        t.nativeResponse.addHeader(key, value);
    }

    public static void jsFunction_addHeader(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        JsHttpResponse.jsFunction_addHeaderField(cx, thisObj, args, funObj);
    }

    public static void jsFunction_setContentType(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)1, (int)1);
        String str = ArgChecker.getString((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)0, null);
        JsHttpResponse t = (JsHttpResponse)thisObj;
        t.nativeResponse.setContentType(str);
    }

    public static void jsFunction_setCharacterEncoding(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)1, (int)1);
        String str = ArgChecker.getString((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)0, null);
        JsHttpResponse t = (JsHttpResponse)thisObj;
        t.nativeResponse.setCharacterEncoding(str);
    }

    public static void jsFunction_setContentLength(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)1, (int)1);
        int length = ArgChecker.getInt((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)0, (int)0);
        JsHttpResponse t = (JsHttpResponse)thisObj;
        t.nativeResponse.setContentLength(length);
    }

    public static void jsFunction_setStatus(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)1, (int)1);
        int status = ArgChecker.getInt((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)0, (int)0);
        JsHttpResponse t = (JsHttpResponse)thisObj;
        t.nativeResponse.setStatus(status);
    }

    public static void jsFunction_write(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)1, (int)1);
        ByteString bs = ArgChecker.getByteString((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)0, null);
        JsHttpResponse t = (JsHttpResponse)thisObj;
        try {
            ServletOutputStream os = t.nativeResponse.getOutputStream();
            os.write(bs.getBytes());
        }
        catch (IOException e) {
            GPError.throwAsGPErrorEx((Scriptable)thisObj, (String)clazzName, (int)7, (int)0, (String)("I/O Error obtaining output stream for HTTP response: " + e.getMessage()));
        }
    }

    public static void jsFunction_print(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)1, (int)1);
        JsHttpResponse t = (JsHttpResponse)thisObj;
        try {
            PrintWriter pw = t.nativeResponse.getWriter();
            pw.print(Context.toString((Object)args[0]));
        }
        catch (IOException e) {
            GPError.throwAsGPErrorEx((Scriptable)thisObj, (String)clazzName, (int)7, (int)0, (String)("I/O Error obtaining output stream for HTTP response: " + e.getMessage()));
        }
    }

    public static void jsFunction_println(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)1, (int)1);
        JsHttpResponse t = (JsHttpResponse)thisObj;
        try {
            PrintWriter pw = t.nativeResponse.getWriter();
            pw.println(Context.toString((Object)args[0]));
        }
        catch (IOException e) {
            GPError.throwAsGPErrorEx((Scriptable)thisObj, (String)clazzName, (int)7, (int)0, (String)("I/O Error obtaining output stream for HTTP response: " + e.getMessage()));
        }
    }

    public static String jsFunction_toString(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)0, (int)0);
        JsHttpResponse t = (JsHttpResponse)thisObj;
        return "" + t.nativeResponse.getStatus();
    }
}

