/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.scriptingserver.jetty;

import java.awt.Desktop;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.ImageIcon;
import org.openscdp.scriptingserver.jetty.Launcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrayLauncher
extends Launcher
implements ActionListener {
    static Logger log = LoggerFactory.getLogger((String)TrayLauncher.class.getName());
    private MenuItem shutdownMenuItem;
    private MenuItem guiMenuItem;
    static ResourceBundle rb = ResourceBundle.getBundle("messages", Locale.getDefault());

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.shutdownMenuItem)) {
            this.shutdown();
        } else if (e.getSource().equals(this.guiMenuItem)) {
            this.showGUI();
        }
    }

    private void showGUI() {
        try {
            URI uri = new URI("http://127.0.0.1:8080/se");
            Desktop.getDesktop().browse(uri);
        }
        catch (Exception e) {
            log.error("Problem launching browser", (Throwable)e);
            return;
        }
    }

    private TrayIcon initTrayIcon() {
        this.shutdownMenuItem = new MenuItem(rb.getString("traylauncher.shutdown"));
        this.guiMenuItem = new MenuItem(rb.getString("traylauncher.showgui"));
        PopupMenu trayMenu = new PopupMenu(rb.getString("traylauncher.scriptingserver"));
        if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
            trayMenu.add(this.guiMenuItem);
        }
        trayMenu.add(this.shutdownMenuItem);
        URL iconURL = TrayLauncher.class.getResource("/cardcontact_24bit.gif");
        ImageIcon icon = new ImageIcon(iconURL);
        String tooltip = rb.getString("traylauncher.scriptingserver");
        TrayIcon trayIcon = new TrayIcon(icon.getImage(), tooltip, trayMenu);
        trayIcon.setImageAutoSize(true);
        trayIcon.addActionListener(this);
        this.shutdownMenuItem.addActionListener(this);
        this.guiMenuItem.addActionListener(this);
        return trayIcon;
    }

    @Override
    protected void start(String[] args) {
        try {
            this.loadConfig();
            SystemTray systemTray = SystemTray.getSystemTray();
            systemTray.add(this.initTrayIcon());
            this.initServer(args);
            this.server.start();
            this.server.join();
        }
        catch (Exception e) {
            log.error("Problem starting server", (Throwable)e);
            e.printStackTrace();
            System.exit(1);
        }
    }

    private void shutdown() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            log.error("Problem stopping server", (Throwable)e);
        }
        System.exit(0);
    }

    public static void main(String[] args) {
        TrayLauncher launcher = new TrayLauncher();
        launcher.start(args);
    }
}

