/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.scriptingserver;

import de.cardcontact.scdp.engine.Engine;
import de.cardcontact.scdp.engine.FileResourceLocator;
import de.cardcontact.scdp.engine.FileResourceLocatorFS;
import de.cardcontact.scdp.engine.GPTracerSLFAdapter;
import de.cardcontact.scdp.engine.LogbackInitializer;
import de.cardcontact.scdp.engine.VersionInfo;
import de.cardcontact.scdp.js.GPTracer;
import jakarta.servlet.ServletContext;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Date;
import java.util.Properties;
import opencard.core.service.SmartCard;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.openscdp.scriptingserver.ScriptingServerStatusEnum;
import org.openscdp.scriptingserver.ServletFileResourceLocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptingEngine {
    public static final String ATTRIBUTE_NAME = "scriptingEngine";
    final Logger logger = LoggerFactory.getLogger(ScriptingEngine.class);
    private Engine engine;
    private int invocationCounter;
    private int exceptionCounter;
    private ServletContext ctx;
    private FileResourceLocatorFS fileResourceLocator;
    private ScriptingServerStatusEnum status = ScriptingServerStatusEnum.LOADING;
    private String lastRhinoExceptionMessage;
    private Date lastRhinoExceptionTimestamp;
    private GPTracerSLFAdapter defaultTrace = null;
    private GPTracerSLFAdapter lastTrace = null;

    public ScriptingEngine(ServletContext ctx) {
        String fname;
        File file;
        this.ctx = ctx;
        String sysdir = ctx.getInitParameter("sysDir");
        if (sysdir == null) {
            this.logger.info("Using the ServletFileResourceLocator");
            this.fileResourceLocator = new ServletFileResourceLocator(ctx);
        } else {
            String usrdir = ctx.getInitParameter("userDir");
            this.logger.info("Using the FileResourceLocatorFS");
            this.logger.debug("GPSystem.SYS is set to " + sysdir);
            this.logger.debug("GPSystem.USR is set to " + usrdir);
            this.fileResourceLocator = new FileResourceLocatorFS(new File(sysdir), new File(usrdir));
        }
        if (ctx.getInitParameter("standalone") == null && (file = new File(fname = this.fileResourceLocator.mapFilename("etc/logback.xml", 2))).exists()) {
            String context = ctx.getContextPath();
            context = context.length() == 0 ? "root" : context.substring(1);
            System.setProperty("webcontext", context);
            LogbackInitializer.init((String)fname);
        }
    }

    public String getVersion() {
        Object version;
        block5: {
            Package p = ScriptingEngine.class.getPackage();
            version = "(snapshot)";
            if (p.getSpecificationVersion() == null || p.getImplementationVersion() == null) {
                Properties prop = new Properties();
                try {
                    InputStream is = this.ctx.getResourceAsStream("/META-INF/MANIFEST.MF");
                    if (is == null) break block5;
                    prop.load(is);
                    String spec = prop.getProperty("Specification-Version");
                    String impl = prop.getProperty("Implementation-Version");
                    if (spec != null && impl != null) {
                        version = spec + "." + impl;
                    }
                }
                catch (IOException e) {
                    this.logger.error(e.toString());
                }
            } else {
                version = p.getSpecificationVersion() + "." + p.getImplementationVersion();
            }
        }
        return version;
    }

    public void startScriptingFramework() {
        this.logger.info("ScriptingServer " + this.getVersion());
        this.logger.info("SCDP4J " + VersionInfo.getVersion());
        this.logger.info(SmartCard.getVersion());
        this.engine = new Engine();
        this.engine.setRuntimeEnvironmentType(4);
        this.engine.setFileResourceLocator((FileResourceLocator)this.fileResourceLocator);
        this.engine.initializeModule();
        this.defaultTrace = new GPTracerSLFAdapter(0x100000);
        this.defaultTrace.mark();
        this.engine.setTracer((GPTracer)this.defaultTrace);
        String configScriptName = this.ctx.getInitParameter("configScriptName");
        if (configScriptName == null) {
            configScriptName = "config.js";
        }
        this.clearLastRhinoException();
        try {
            ScriptableObject scope = this.engine.getSharedScope();
            Context.enter();
            scope.defineProperty("__ServletContext", (Object)Context.toObject((Object)this.ctx, (Scriptable)scope), 1);
            Context.exit();
            this.engine.executeSetupScript(configScriptName);
            this.status = ScriptingServerStatusEnum.INITIALIZED;
        }
        catch (RhinoException re) {
            String msg = this.handleRhinoExceptionMessage(re);
            this.logger.error("Error executing configuration script\n" + msg);
            this.status = ScriptingServerStatusEnum.FAILEDINIT;
        }
        catch (Exception e) {
            this.logger.error("Exception executing configuration script", (Throwable)e);
            this.status = ScriptingServerStatusEnum.FAILEDINIT;
        }
        this.invocationCounter = 0;
        this.lastTrace = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runScript(Reader reader, String filename) throws IOException {
        ScriptableObject sharedScope = this.engine.getSharedScope();
        Context cx = Context.enter();
        try {
            cx.evaluateReader((Scriptable)sharedScope, reader, filename, 1, null);
            this.logger.info("Configuration script " + filename + " received over HTTP completed");
        }
        catch (RhinoException re) {
            String msg = this.handleRhinoExceptionMessage(re);
            this.logger.error(msg);
        }
        finally {
            Context.exit();
        }
        this.status = this.isHandlerDefined() ? ScriptingServerStatusEnum.SERVICING : ScriptingServerStatusEnum.CONFIGURED;
    }

    public GPTracer newGPTracer() {
        this.lastTrace = new GPTracerSLFAdapter(0);
        this.lastTrace.mark();
        return this.lastTrace;
    }

    public String handleRhinoExceptionMessage(RhinoException re) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        Engine.printRhinoExceptionMessage((RhinoException)re, (PrintStream)ps);
        this.lastRhinoExceptionMessage = baos.toString();
        this.lastRhinoExceptionTimestamp = new Date();
        ++this.exceptionCounter;
        return this.lastRhinoExceptionMessage;
    }

    public static String escapeForXML(String str) {
        return str.replaceAll("<", "&lt;");
    }

    public String getLastRhinoExceptionMessage() {
        return this.lastRhinoExceptionMessage;
    }

    public Date getLastRhinoExceptionTimestamp() {
        return this.lastRhinoExceptionTimestamp;
    }

    public void clearLastRhinoException() {
        this.lastRhinoExceptionMessage = "--- None ---";
        this.lastRhinoExceptionTimestamp = new Date();
        this.exceptionCounter = 0;
    }

    public boolean isHandlerDefined() {
        ScriptableObject sharedScope = this.engine.getSharedScope();
        Object o = ScriptableObject.getProperty((Scriptable)sharedScope, (String)"handleRequest");
        return o != ScriptableObject.NOT_FOUND;
    }

    public boolean isPerformCardUpdateDefined() {
        ScriptableObject sharedScope = this.engine.getSharedScope();
        Object o = ScriptableObject.getProperty((Scriptable)sharedScope, (String)"performCardUpdate");
        return o != ScriptableObject.NOT_FOUND;
    }

    public String getLastTrace() {
        if (this.lastTrace == null) {
            return "--- Nothing recorded ---";
        }
        String trace = this.lastTrace.copy();
        if (trace == null) {
            return "--- Nothing marked ---";
        }
        return ScriptingEngine.escapeForXML(trace);
    }

    public String getDefaultTrace() {
        if (this.defaultTrace == null) {
            return "--- Nothing recorded ---";
        }
        String trace = this.defaultTrace.copy();
        if (trace == null) {
            return "--- Nothing marked ---";
        }
        return ScriptingEngine.escapeForXML(trace);
    }

    public String getStatus() {
        return this.status.toString();
    }

    public ScriptingServerStatusEnum getServerStatus() {
        return this.status;
    }

    public void countInvocation() {
        ++this.invocationCounter;
    }

    public String getServerVersion() {
        return VersionInfo.getVersion();
    }

    public String getInvocationCounter() {
        return String.valueOf(this.invocationCounter);
    }

    public String getExceptionCounter() {
        return String.valueOf(this.exceptionCounter);
    }

    public Engine getEngine() {
        return this.engine;
    }
}

