/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.scriptingserver;

import de.cardcontact.opencard.factory.GlobalPlatformCardServiceFactory;
import de.cardcontact.opencard.factory.IsoCardServiceFactory;
import de.cardcontact.opencard.factory.SmartCardHSMCardServiceFactory;
import de.cardcontact.opencard.terminal.smartcardio.SmartCardIOFactory;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.security.Provider;
import java.security.Security;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceFactory;
import opencard.core.service.CardServiceRegistry;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CardTerminalRegistry;
import opencard.core.util.OpenCardPropertyLoadingException;
import opencard.opt.util.PassThruCardServiceFactory;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.openscdp.scriptingserver.InteractiveShell;
import org.openscdp.scriptingserver.ScriptCardSessionFactory;
import org.openscdp.scriptingserver.ScriptingEngine;
import org.openscdp.scriptingserver.ScriptingServerStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextListener
implements ServletContextListener {
    final Logger logger = LoggerFactory.getLogger(ContextListener.class);

    public void contextInitialized(ServletContextEvent event) {
        ServletContext ctx = event.getServletContext();
        if (ctx.getInitParameter("priobc") != null) {
            Security.insertProviderAt((Provider)new BouncyCastleProvider(), 1);
        } else {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        try {
            System.setProperty("OpenCard.loaderClassName", "");
            SmartCard.start();
            CardTerminalRegistry ctr = CardTerminalRegistry.getRegistry();
            if (ctx.getInitParameter("pcsc") != null) {
                SmartCardIOFactory ctf = new SmartCardIOFactory();
                String[] param = new String[]{"*", "PCSC"};
                ctf.createCardTerminals(ctr, param);
            }
            CardServiceRegistry csr = CardServiceRegistry.getRegistry();
            SmartCardHSMCardServiceFactory csf = new SmartCardHSMCardServiceFactory();
            csr.add((CardServiceFactory)csf);
            csf = new IsoCardServiceFactory();
            csr.add((CardServiceFactory)csf);
            csf = new PassThruCardServiceFactory();
            csr.add((CardServiceFactory)csf);
            csf = new GlobalPlatformCardServiceFactory();
            csr.add((CardServiceFactory)csf);
        }
        catch (OpenCardPropertyLoadingException e) {
            this.logger.error("Error loading Opencard properties", (Throwable)e);
        }
        catch (CardServiceException e) {
            this.logger.error("Error creating card service", (Throwable)e);
        }
        catch (CardTerminalException e) {
            this.logger.error("Error creating terminal service", (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            this.logger.error("Terminal or service factory not found", (Throwable)e);
        }
        ScriptingEngine se = new ScriptingEngine(ctx);
        se.startScriptingFramework();
        ctx.setAttribute("scriptingEngine", (Object)se);
        ScriptCardSessionFactory scsf = new ScriptCardSessionFactory(se);
        ctx.setAttribute("cardSessionFactory", (Object)scsf);
        if (ctx.getInitParameter("shell") != null) {
            InteractiveShell shell = new InteractiveShell(se);
            shell.start();
        }
        if (se.getServerStatus() == ScriptingServerStatusEnum.FAILEDINIT) {
            this.logger.error("Scripting environment failed startup");
            throw new RuntimeException("Scripting environment failed startup");
        }
    }

    public void contextDestroyed(ServletContextEvent event) {
        ServletContext ctx = event.getServletContext();
        try {
            SmartCard.shutdown();
        }
        catch (CardTerminalException e) {
            this.logger.error("Error shuting down OCF", (Throwable)e);
        }
    }
}

