/*
 * Decompiled with CFR 0.152.
 */
package org.openscdp.scriptingserver.js;

import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.utils.ArgChecker;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.fileupload2.core.DiskFileItemFactory;
import org.apache.commons.fileupload2.core.FileItem;
import org.apache.commons.fileupload2.core.FileItemFactory;
import org.apache.commons.fileupload2.core.FileUploadException;
import org.apache.commons.fileupload2.jakarta.servlet5.JakartaServletFileUpload;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.openscdp.scriptingserver.js.JsHttpSession;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class JsHttpRequest
extends ScriptableObject {
    private static final long serialVersionUID = -4196677972601465719L;
    public static final String clazzName = "HttpRequest";
    private HttpServletRequest nativeRequest;
    private Scriptable parameters = null;

    public String getClassName() {
        return clazzName;
    }

    public HttpServletRequest jsGet_nativeRequest() {
        return this.nativeRequest;
    }

    public String jsGet_method() {
        return this.nativeRequest.getMethod();
    }

    public String jsGet_servletPath() {
        return this.nativeRequest.getServletPath();
    }

    public String jsGet_contextPath() {
        return this.nativeRequest.getContextPath();
    }

    public String jsGet_pathInfo() {
        return this.nativeRequest.getPathInfo();
    }

    public String jsGet_queryString() {
        return this.nativeRequest.getQueryString();
    }

    public String jsGet_contentType() {
        return this.nativeRequest.getContentType();
    }

    public int jsGet_contentLength() {
        return this.nativeRequest.getContentLength();
    }

    public int jsGet_localPort() {
        return this.nativeRequest.getLocalPort();
    }

    private void buildParametersFromMultiPart() {
        Context ctx = Context.getCurrentContext();
        this.parameters = ctx.newObject((Scriptable)this, "Object");
        DiskFileItemFactory factory = ((DiskFileItemFactory.Builder)((DiskFileItemFactory.Builder)DiskFileItemFactory.builder().setBufferSize(0x100000)).setCharset("UTF-8")).get();
        JakartaServletFileUpload upload = new JakartaServletFileUpload((FileItemFactory)factory);
        upload.setFileSizeMax(0x100000L);
        List items = null;
        try {
            items = upload.parseRequest(this.nativeRequest);
        }
        catch (FileUploadException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, (String)clazzName, (int)7, (int)0, (String)("Error during upload " + e));
        }
        for (FileItem item : items) {
            String name = item.getFieldName();
            if (item.isFormField()) {
                String value = item.getString();
                if (this.parameters.has(name, this.parameters)) {
                    value = this.parameters.get(name, this.parameters).toString().concat(",").concat(value);
                }
                this.parameters.put(name, this.parameters, (Object)value);
                continue;
            }
            this.parameters.put("_filename", this.parameters, (Object)item.getName());
            ByteString bs = ByteString.newInstance((Scriptable)this, (byte[])item.get());
            this.parameters.put(name, this.parameters, (Object)bs);
        }
    }

    private void buildParametersFromRequest() {
        Context ctx = Context.getCurrentContext();
        this.parameters = ctx.newObject((Scriptable)this, "Object");
        Enumeration params = this.nativeRequest.getParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            String value = this.nativeRequest.getParameter(name);
            this.parameters.put(name, this.parameters, (Object)value);
        }
    }

    public Scriptable jsGet_parameters() {
        if (this.parameters == null) {
            if (JakartaServletFileUpload.isMultipartContent((HttpServletRequest)this.nativeRequest)) {
                this.buildParametersFromMultiPart();
            } else {
                this.buildParametersFromRequest();
            }
        }
        return this.parameters;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) {
        ArgChecker.checkRange((Scriptable)ctorObj, (String)clazzName, (Object[])args, (int)1, (int)1);
        if (!(args[0] instanceof HttpServletRequest)) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, (String)clazzName, (int)16, (int)0, (String)"Argument must be of type javax.servlet.http.HttpServletRequest");
        }
        JsHttpRequest t = new JsHttpRequest();
        t.nativeRequest = (HttpServletRequest)args[0];
        return t;
    }

    public static String jsFunction_getEntityAsString(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)0, (int)0);
        JsHttpRequest t = (JsHttpRequest)thisObj;
        StringBuffer sb = new StringBuffer();
        try {
            int readBytes;
            BufferedReader r = t.nativeRequest.getReader();
            char[] cbuffer = new char[4096];
            while ((readBytes = r.read(cbuffer)) > 0) {
                sb.append(cbuffer, 0, readBytes);
            }
        }
        catch (IOException ioe) {
            GPError.throwAsGPErrorEx((Scriptable)thisObj, (String)clazzName, (int)7, (int)1, (String)("Error reading entity from HTTP request : " + ioe.getMessage()));
        }
        return sb.toString();
    }

    public static Scriptable jsFunction_getEntityAsXML(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)0, (int)0);
        JsHttpRequest t = (JsHttpRequest)thisObj;
        Scriptable result = null;
        try {
            ServletInputStream is = t.nativeRequest.getInputStream();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse((InputStream)is);
            Object[] arg1 = new Object[]{document};
            result = (Scriptable)ScriptableObject.callMethod((Context)cx, (Scriptable)ScriptableObject.getTopLevelScope((Scriptable)thisObj), (String)"XML", (Object[])arg1);
        }
        catch (ParserConfigurationException e) {
            GPError.throwAsGPErrorEx((Scriptable)thisObj, (String)clazzName, (int)7, (int)1, (String)("Error during parser configuration : " + e.getMessage()));
        }
        catch (SAXException e) {
            GPError.throwAsGPErrorEx((Scriptable)thisObj, (String)clazzName, (int)7, (int)1, (String)("Error during XML parsing : " + e.getMessage()));
        }
        catch (IOException e) {
            GPError.throwAsGPErrorEx((Scriptable)thisObj, (String)clazzName, (int)7, (int)1, (String)("Error reading entity from HTTP request : " + e.getMessage()));
        }
        return result;
    }

    public static Object jsFunction_getEntityAsInputStream(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)0, (int)0);
        JsHttpRequest t = (JsHttpRequest)thisObj;
        ServletInputStream is = null;
        try {
            is = t.nativeRequest.getInputStream();
        }
        catch (IOException e) {
            GPError.throwAsGPErrorEx((Scriptable)thisObj, (String)clazzName, (int)7, (int)1, (String)("Error reading entity from HTTP request : " + e.getMessage()));
        }
        return Context.javaToJS((Object)is, (Scriptable)thisObj);
    }

    public static Object jsFunction_getHeaderField(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArrayList fieldValues;
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)1, (int)1);
        JsHttpRequest t = (JsHttpRequest)thisObj;
        String fieldName = null;
        if (args[0] != null) {
            fieldName = ArgChecker.getString((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)0, null);
        }
        if ((fieldValues = Collections.list(t.nativeRequest.getHeaders(fieldName))) == null) {
            return Context.getUndefinedValue();
        }
        return cx.newArray(thisObj, fieldValues.toArray());
    }

    public static Scriptable jsFunction_getHeaderFieldList(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)0, (int)0);
        JsHttpRequest t = (JsHttpRequest)thisObj;
        ArrayList l = Collections.list(t.nativeRequest.getHeaderNames());
        return cx.newArray(thisObj, l.toArray());
    }

    public static JsHttpSession jsFunction_getSession(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)0, (int)0);
        JsHttpRequest t = (JsHttpRequest)thisObj;
        HttpSession session = t.nativeRequest.getSession();
        Object o = session.getAttribute("HttpSession");
        if (o != null) {
            return (JsHttpSession)((Object)o);
        }
        Object[] param = new Object[]{session};
        JsHttpSession jssession = (JsHttpSession)cx.newObject(thisObj, "HttpSession", param);
        session.setAttribute("HttpSession", (Object)jssession);
        return jssession;
    }

    public static String jsFunction_toString(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange((Scriptable)thisObj, (String)clazzName, (Object[])args, (int)0, (int)0);
        HttpServletRequest r = ((JsHttpRequest)thisObj).nativeRequest;
        StringBuffer sb = new StringBuffer(r.getMethod());
        String p = r.getPathInfo();
        if (p != null) {
            sb.append(" ");
            sb.append(p);
        }
        if ((p = r.getQueryString()) != null) {
            sb.append("?");
            sb.append(p);
        }
        return sb.toString();
    }
}

