/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.pkcs11;

import java.util.ArrayList;
import java.util.List;
import org.opensc.pkcs11.wrap.PKCS11Attribute;
import org.opensc.pkcs11.wrap.PKCS11Exception;
import org.opensc.pkcs11.wrap.PKCS11Object;
import org.opensc.pkcs11.wrap.PKCS11Session;

public class PKCS11GenericObject
extends PKCS11Object {
    public static final int CKO_DATA = 0;
    public static final int CKO_CERTIFICATE = 1;
    public static final int CKO_PUBLIC_KEY = 2;
    public static final int CKO_PRIVATE_KEY = 3;
    public static final int CKO_SECRET_KEY = 4;
    public static final int CKO_HW_FEATURE = 5;
    public static final int CKO_DOMAIN_PARAMETERS = 6;
    public static final int CKO_MECHANISM = 7;
    public static final int CKK_RSA = 0;
    public static final int CKK_ECDSA = 3;
    public static final int CKK_EC = 3;
    public static final int CKK_DES = 19;
    public static final int CKK_DES2 = 20;
    public static final int CKK_DES3 = 21;
    public static final int CKK_AES = 31;

    public PKCS11GenericObject(PKCS11Session session, long handle) throws PKCS11Exception {
        super(session, handle);
    }

    public static List<PKCS11GenericObject> getObjects(PKCS11Session session, PKCS11Attribute[] attrs) throws PKCS11Exception {
        long[] handles = PKCS11GenericObject.enumRawObjects((PKCS11Session)session, (PKCS11Attribute[])attrs);
        ArrayList<PKCS11GenericObject> ret = new ArrayList<PKCS11GenericObject>(handles.length);
        for (int i = 0; i < handles.length; ++i) {
            ret.add(new PKCS11GenericObject(session, handles[i]));
        }
        return ret;
    }

    public static long createObject(PKCS11Session session, PKCS11Attribute[] attrs) throws PKCS11Exception {
        return PKCS11Object.createObject((PKCS11Session)session, (PKCS11Attribute[])attrs);
    }

    public byte[] getAttribute(int attr) throws PKCS11Exception {
        return super.getRawAttribute(attr);
    }

    public int getNumberAttribute(int attr) throws PKCS11Exception {
        return super.getULongAttribute(attr);
    }

    public boolean getBooleanAttribute(int attr) throws PKCS11Exception {
        return super.getBooleanAttribute(attr);
    }
}

