/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.gp;

import de.cardcontact.opencard.security.GPKeySet;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.gp.GPKey;
import de.cardcontact.scdp.utils.ArgChecker;
import java.security.GeneralSecurityException;
import javax.crypto.SecretKey;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class GPScpKeySet
extends ScriptableObject {
    private static final String clazzName = "GPScpKeySet";
    private byte version;
    private GPKey kenc;
    private GPKey kmac;
    private GPKey krmac;
    private GPKey kdek;

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        int i;
        if (!inNewExpr) {
            Context.reportError((String)"GPScpKeySet() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 4, 5);
        GPScpKeySet o = new GPScpKeySet();
        o.version = ArgChecker.getByte((Scriptable)ctorObj, clazzName, args, 0, (byte)0);
        for (i = 1; i < args.length; ++i) {
            if (args[i] instanceof GPKey) continue;
            throw GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 16, i, "Expected GPKey argument");
        }
        i = 1;
        o.kenc = (GPKey)((Object)args[i++]);
        o.kmac = (GPKey)((Object)args[i++]);
        if (args.length == 5) {
            o.krmac = (GPKey)((Object)args[i++]);
        }
        o.kdek = (GPKey)((Object)args[i++]);
        return o;
    }

    public GPKeySet getGPKeySet() {
        try {
            SecretKey skenc = (SecretKey)this.kenc.getJCEKey(null);
            SecretKey skmac = (SecretKey)this.kmac.getJCEKey(null);
            SecretKey skdek = (SecretKey)this.kdek.getJCEKey(null);
            SecretKey skrmac = null;
            if (this.krmac != null) {
                skrmac = (SecretKey)this.krmac.getJCEKey(null);
            }
            return new GPKeySet(this.version, skenc, skmac, skrmac, skdek);
        }
        catch (GeneralSecurityException e) {
            throw GPError.throwAsGPErrorEx((Scriptable)this, clazzName, 5, 0, "Key set invalid: " + e.getMessage());
        }
    }

    public static GPKey jsFunction_getEncKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return ((GPScpKeySet)thisObj).kenc;
    }

    public static GPKey jsFunction_getMacKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return ((GPScpKeySet)thisObj).kmac;
    }

    public static GPKey jsFunction_getDekKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return ((GPScpKeySet)thisObj).kdek;
    }

    public static GPKey jsFunction_getRMacKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return ((GPScpKeySet)thisObj).krmac;
    }

    public String getClassName() {
        return clazzName;
    }
}

