/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.js;

import de.cardcontact.scdp.engine.Engine;
import de.cardcontact.scdp.engine.FileResourceContextFS;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.utils.ArgChecker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JsScript
extends ScriptableObject {
    private static final long serialVersionUID = -2896831908541463564L;
    public static final String clazzName = "JsScript";
    private Script script;

    public String getClassName() {
        return clazzName;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) {
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 1, 3);
        String filename = ArgChecker.getString((Scriptable)ctorObj, clazzName, args, 0, null);
        InputStream is = null;
        String source = null;
        int lineno = 1;
        if (args.length == 1) {
            try {
                is = new FileInputStream(filename);
            }
            catch (FileNotFoundException e) {
                GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 23, 1, "File " + filename + " not found");
            }
        } else {
            lineno = ArgChecker.getInt((Scriptable)ctorObj, clazzName, args, 1, 1);
            if (args[2] instanceof NativeJavaObject) {
                NativeJavaObject njo = (NativeJavaObject)args[0];
                is = (InputStream)njo.unwrap();
            } else {
                source = ArgChecker.getString((Scriptable)ctorObj, clazzName, args, 2, null);
            }
        }
        JsScript s = new JsScript();
        if (is != null) {
            InputStreamReader isr = new InputStreamReader(is);
            try {
                s.script = ctx.compileReader((Reader)isr, filename, lineno, null);
            }
            catch (IOException ioe) {
                GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 23, 1, "File " + filename + " can not be read: " + ioe.getMessage());
            }
        } else {
            s.script = ctx.compileString(source, filename, lineno, null);
        }
        return s;
    }

    public static Scriptable jsStaticFunction_newDynamicScope(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        String classname = ArgChecker.getString(thisObj, clazzName, args, 0, null);
        Engine engine = Engine.getEngine(thisObj);
        return engine.newDynamicScope(classname);
    }

    public static Object jsFunction_execute(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 2);
        if (!(args[0] instanceof Scriptable)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 0, "Argument must be of type Object");
        }
        Scriptable scope = (Scriptable)args[0];
        String cwd = ArgChecker.getString(thisObj, clazzName, args, 1, null);
        JsScript s = (JsScript)thisObj;
        FileResourceContextFS rcfs = null;
        if (cwd != null) {
            File cwdFile = new File(cwd);
            rcfs = new FileResourceContextFS(cwdFile);
        }
        Engine engine = Engine.getEngine(scope);
        return engine.executeScript(cx, scope, s.script, rcfs);
    }
}

