/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.gp;

import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.js.GPRuntime;
import de.cardcontact.scdp.js.GPRuntimeHelper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GPXMLParser
extends DefaultHandler {
    Scriptable root = null;
    Scriptable scope;
    Stack<Scriptable> parentStack;
    Stack<String> pathStack;
    Map<String, ArrayElementSpec> arrayElements;
    Map<String, Boolean> scriptElements;
    Context cx;
    StringBuffer collector;
    String filename;
    Locator locator;
    int startLineNumber = 0;

    public GPXMLParser(Scriptable scope) {
        this.scope = ScriptableObject.getTopLevelScope((Scriptable)scope);
        this.parentStack = new Stack();
        this.pathStack = new Stack();
        this.arrayElements = new HashMap<String, ArrayElementSpec>();
        this.scriptElements = new HashMap<String, Boolean>();
        this.cx = Context.getCurrentContext();
        this.root = this.cx.newObject(this.scope);
        this.filename = "*** Unknown ***";
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public void defineArrayElement(String path, String arrayElement, String arrayIndex) {
        this.arrayElements.put(path, new ArrayElementSpec(arrayElement, arrayIndex));
    }

    public void defineScriptElement(String path, boolean asFunction) {
        this.scriptElements.put(path, new Boolean(asFunction));
    }

    public void addRootArrayElement(String element, String arrayIndex) {
        ScriptableObject array = (ScriptableObject)this.cx.newArray(this.scope, 0);
        this.root.put(element, this.root, (Object)array);
        array.put("arrayIndex", (Scriptable)array, (Object)arrayIndex);
        array.setAttributes("arrayIndex", 2);
    }

    public void addArrayElement(String arrayElement, String arrayIndex) {
        String[] elements = arrayElement.split(",");
        String[] indices = arrayIndex.split(",");
        Scriptable obj = this.root;
        if (!this.parentStack.empty()) {
            obj = this.parentStack.peek();
        }
        for (int i = 0; i < elements.length; ++i) {
            ScriptableObject array = (ScriptableObject)this.cx.newArray(this.scope, 0);
            obj.put(elements[i], obj, (Object)array);
            array.put("arrayIndex", (Scriptable)array, (Object)(i >= indices.length ? "#" : indices[i]));
            array.setAttributes("arrayIndex", 2);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
        InputSource is = null;
        try {
            URI uri = new URI(systemId);
            String scheme = uri.getScheme();
            if (scheme.equalsIgnoreCase("file")) {
                File f = new File(uri);
                if (f.exists()) {
                    is = new InputSource(new FileInputStream(f));
                } else {
                    File thisxml = new File(this.filename);
                    String s = thisxml.getParent() + "/" + f.getName();
                    File e = new File(s);
                    if (e.exists()) {
                        is = new InputSource(new FileInputStream(e));
                    } else {
                        GPRuntime gpr = GPRuntimeHelper.getGPRuntime(this.scope);
                        String filename = gpr.mapFilename(f.getName(), 6);
                        if (filename == null) {
                            filename = gpr.mapFilename("schema/" + f.getName(), 6);
                        }
                        if (filename == null) {
                            GPError.throwAsGPErrorEx(this.scope, "GPXML", 23, 1, "File " + systemId + " not found");
                        }
                        is = new InputSource(new FileInputStream(filename));
                    }
                }
            }
        }
        catch (URISyntaxException e) {
            is = super.resolveEntity(publicId, systemId);
        }
        return is;
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) throws SAXException {
        String arrayIndex;
        Scriptable obj;
        this.collector = new StringBuffer();
        this.startLineNumber = this.locator.getLineNumber();
        Scriptable parent = null;
        Object currentPath = null;
        if (this.parentStack.empty()) {
            obj = this.root;
            currentPath = "";
        } else {
            obj = this.cx.newObject(this.scope);
            parent = this.parentStack.peek();
            Object o = parent.get(sName, parent);
            if (o != null && o != Scriptable.NOT_FOUND && o instanceof NativeArray) {
                NativeArray array = (NativeArray)o;
                Object p = array.get("arrayIndex", parent);
                if (p != null && p != Scriptable.NOT_FOUND) {
                    arrayIndex = Context.toString((Object)p);
                    if (arrayIndex.equals("#")) {
                        array.put((int)array.getLength(), (Scriptable)array, (Object)obj);
                    } else {
                        String keyvalue = attrs.getValue(arrayIndex);
                        if (keyvalue == null) {
                            throw new SAXException("Attribute " + arrayIndex + " not found in array element");
                        }
                        array.put(keyvalue, (Scriptable)array, (Object)obj);
                    }
                } else {
                    array.put((int)array.getLength(), (Scriptable)array, (Object)obj);
                }
            } else {
                parent.put(sName, parent, (Object)obj);
            }
            currentPath = this.pathStack.peek();
        }
        this.parentStack.push(obj);
        currentPath = (String)currentPath + "/" + sName;
        this.pathStack.push((String)currentPath);
        ArrayElementSpec aes = this.arrayElements.get(currentPath);
        if (aes != null) {
            this.addArrayElement(aes.getArrayElement(), aes.getArrayIndex());
        }
        for (int i = 0; i < attrs.getLength(); ++i) {
            String aName = attrs.getLocalName(i);
            if ("".equals(aName)) {
                aName = attrs.getQName(i);
            }
            if (aName.equals("arrayElement")) {
                arrayIndex = attrs.getValue("arrayIndex");
                if (arrayIndex == null) {
                    arrayIndex = "#";
                }
                this.addArrayElement(attrs.getValue(i), arrayIndex);
                continue;
            }
            if (aName.equals("arrayIndex")) continue;
            obj.put(aName, obj, (Object)attrs.getValue(i));
        }
    }

    private void processFunction() throws SAXException {
        Scriptable parent = this.parentStack.peek();
        String name = "";
        Object o = parent.get("Name", parent);
        if (o instanceof CharSequence) {
            name = ((CharSequence)o).toString();
        }
        String param = "";
        o = parent.get("Param", parent);
        if (o instanceof CharSequence) {
            param = ((CharSequence)o).toString();
        }
        this.collector.insert(0, "function (" + param + ") {");
        this.collector.append("}");
        try {
            Function f = this.cx.compileFunction(this.scope, this.collector.toString(), this.filename, this.startLineNumber, null);
            parent.put("Script", parent, (Object)f);
        }
        catch (RhinoException e) {
            throw new SAXException("ECMAScript compiler error in function \"" + name + "\" on line " + e.lineNumber() + " column " + e.columnNumber() + " - " + e.details());
        }
    }

    private void processScript() throws SAXException {
        try {
            Object[] param = new Object[]{this.filename, this.startLineNumber, this.collector.toString()};
            Scriptable script = this.cx.newObject(this.scope, "JsScript", param);
            Scriptable parent = this.parentStack.peek();
            parent.put("Script", parent, (Object)script);
        }
        catch (RhinoException e) {
            throw new SAXException("ECMAScript compiler error in script " + this.filename + " + on line " + e.lineNumber() + " column " + e.columnNumber() + " - " + e.details());
        }
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        if (this.collector != null && this.collector.length() > 0 && !this.parentStack.empty()) {
            Boolean isFunction = null;
            if (this.scriptElements.size() > 0) {
                isFunction = this.scriptElements.get(this.pathStack.peek());
            } else if (sName.equalsIgnoreCase("Script")) {
                isFunction = new Boolean(true);
            }
            if (isFunction != null) {
                if (isFunction.booleanValue()) {
                    Scriptable savedNode = null;
                    String savedPath = null;
                    if (sName.equalsIgnoreCase("Script")) {
                        savedNode = this.parentStack.pop();
                        savedPath = this.pathStack.pop();
                    }
                    this.processFunction();
                    if (sName.equalsIgnoreCase("Script")) {
                        this.parentStack.push(savedNode);
                        this.pathStack.push(savedPath);
                    }
                } else {
                    this.processScript();
                }
            } else {
                String value = this.collector.toString().trim();
                if (value.length() > 0) {
                    Scriptable obj = this.parentStack.peek();
                    obj.put("elementValue", obj, (Object)value);
                }
            }
            this.collector = null;
        }
        this.parentStack.pop();
        this.pathStack.pop();
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (this.collector != null) {
            String s = new String(buf, offset, len);
            this.collector.append(s);
        }
    }

    public Scriptable getRoot() {
        return this.root;
    }

    private class ArrayElementSpec {
        public String arrayElement;
        public String arrayIndex;

        public ArrayElementSpec(String arrayElement, String arrayIndex) {
            this.arrayElement = arrayElement;
            this.arrayIndex = arrayIndex;
        }

        public String getArrayElement() {
            return this.arrayElement;
        }

        public String getArrayIndex() {
            return this.arrayIndex;
        }
    }
}

