/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.pkcs11;

import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.gp.GPKey;
import de.cardcontact.scdp.pkcs11.JsPKCS11Object;
import de.cardcontact.scdp.pkcs11.JsPKCS11Provider;
import de.cardcontact.scdp.pkcs11.PKCS11GenericObject;
import de.cardcontact.scdp.utils.ArgChecker;
import java.util.List;
import javax.security.auth.DestroyFailedException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.opensc.pkcs11.spi.PKCS11SignatureSpi;
import org.opensc.pkcs11.wrap.PKCS11Attribute;
import org.opensc.pkcs11.wrap.PKCS11Exception;
import org.opensc.pkcs11.wrap.PKCS11Object;
import org.opensc.pkcs11.wrap.PKCS11Session;
import org.opensc.pkcs11.wrap.PKCS11Slot;

public class JsPKCS11Session
extends ScriptableObject {
    public static final String clazzName = "PKCS11Session";
    PKCS11Session session = null;
    PKCS11SignatureSpi signatureSpi = null;

    public String getClassName() {
        return clazzName;
    }

    public PKCS11Session getSession() {
        return this.session;
    }

    public static void finishInit(Scriptable scope, FunctionObject ctor, Scriptable proto) {
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RSA_PKCS_KEY_PAIR_GEN", (Object)new Integer(0), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RSA_PKCS", (Object)new Integer(1), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RSA_9796", (Object)new Integer(2), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RSA_X_509", (Object)new Integer(3), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_MD2_RSA_PKCS", (Object)new Integer(4), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_MD5_RSA_PKCS", (Object)new Integer(5), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SHA1_RSA_PKCS", (Object)new Integer(6), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RIPEMD128_RSA_PKCS", (Object)new Integer(7), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RIPEMD160_RSA_PKCS", (Object)new Integer(8), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RSA_PKCS_OAEP", (Object)new Integer(9), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RSA_X9_31_KEY_PAIR_GEN", (Object)new Integer(10), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RSA_X9_31", (Object)new Integer(11), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SHA1_RSA_X9_31", (Object)new Integer(12), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RSA_PKCS_PSS", (Object)new Integer(13), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SHA1_RSA_PKCS_PSS", (Object)new Integer(14), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_DSA_KEY_PAIR_GEN", (Object)new Integer(16), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_DSA", (Object)new Integer(17), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_DSA_SHA1", (Object)new Integer(18), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_DH_PKCS_KEY_PAIR_GEN", (Object)new Integer(32), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_DH_PKCS_DERIVE", (Object)new Integer(33), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_X9_42_DH_KEY_PAIR_GEN", (Object)new Integer(48), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_X9_42_DH_DERIVE", (Object)new Integer(49), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_X9_42_DH_HYBRID_DERIVE", (Object)new Integer(50), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_X9_42_MQV_DERIVE", (Object)new Integer(51), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SHA256_RSA_PKCS", (Object)new Integer(64), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SHA384_RSA_PKCS", (Object)new Integer(65), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SHA512_RSA_PKCS", (Object)new Integer(66), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SHA256_RSA_PKCS_PSS", (Object)new Integer(67), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SHA384_RSA_PKCS_PSS", (Object)new Integer(68), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SHA512_RSA_PKCS_PSS", (Object)new Integer(69), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RC2_KEY_GEN", (Object)new Integer(256), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RC2_ECB", (Object)new Integer(257), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RC2_CBC", (Object)new Integer(258), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RC2_MAC", (Object)new Integer(259), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RC2_MAC_GENERAL", (Object)new Integer(260), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RC2_CBC_PAD", (Object)new Integer(261), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RC4_KEY_GEN", (Object)new Integer(272), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RC4", (Object)new Integer(273), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_DES_KEY_GEN", (Object)new Integer(288), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_DES_ECB", (Object)new Integer(289), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_DES_CBC", (Object)new Integer(290), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_DES_MAC", (Object)new Integer(291), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_DES_MAC_GENERAL", (Object)new Integer(292), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_DES_CBC_PAD", (Object)new Integer(293), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_DES2_KEY_GEN", (Object)new Integer(304), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_DES3_KEY_GEN", (Object)new Integer(305), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_DES3_ECB", (Object)new Integer(306), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_DES3_CBC", (Object)new Integer(307), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_DES3_MAC", (Object)new Integer(308), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_DES3_MAC_GENERAL", (Object)new Integer(309), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_DES3_CBC_PAD", (Object)new Integer(310), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CDMF_KEY_GEN", (Object)new Integer(320), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CDMF_ECB", (Object)new Integer(321), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CDMF_CBC", (Object)new Integer(322), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CDMF_MAC", (Object)new Integer(323), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CDMF_MAC_GENERAL", (Object)new Integer(324), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CDMF_CBC_PAD", (Object)new Integer(325), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_MD2", (Object)new Integer(512), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_MD2_HMAC", (Object)new Integer(513), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_MD2_HMAC_GENERAL", (Object)new Integer(514), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_MD5", (Object)new Integer(528), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_MD5_HMAC", (Object)new Integer(529), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_MD5_HMAC_GENERAL", (Object)new Integer(530), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SHA_1", (Object)new Integer(544), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SHA_1_HMAC", (Object)new Integer(545), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SHA_1_HMAC_GENERAL", (Object)new Integer(546), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RIPEMD128", (Object)new Integer(560), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RIPEMD128_HMAC", (Object)new Integer(561), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RIPEMD128_HMAC_GENERAL", (Object)new Integer(562), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RIPEMD160", (Object)new Integer(576), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RIPEMD160_HMAC", (Object)new Integer(577), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RIPEMD160_HMAC_GENERAL", (Object)new Integer(578), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CAST_KEY_GEN", (Object)new Integer(768), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CAST_ECB", (Object)new Integer(769), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CAST_CBC", (Object)new Integer(770), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CAST_MAC", (Object)new Integer(771), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CAST_MAC_GENERAL", (Object)new Integer(772), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CAST_CBC_PAD", (Object)new Integer(773), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CAST3_KEY_GEN", (Object)new Integer(784), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CAST3_ECB", (Object)new Integer(785), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CAST3_CBC", (Object)new Integer(786), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CAST3_MAC", (Object)new Integer(787), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CAST3_MAC_GENERAL", (Object)new Integer(788), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CAST3_CBC_PAD", (Object)new Integer(789), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CAST5_KEY_GEN", (Object)new Integer(800), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CAST128_KEY_GEN", (Object)new Integer(800), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CAST5_ECB", (Object)new Integer(801), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CAST128_ECB", (Object)new Integer(801), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CAST5_CBC", (Object)new Integer(802), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CAST128_CBC", (Object)new Integer(802), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CAST5_MAC", (Object)new Integer(803), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CAST128_MAC", (Object)new Integer(803), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CAST5_MAC_GENERAL", (Object)new Integer(804), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CAST128_MAC_GENERAL", (Object)new Integer(804), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CAST5_CBC_PAD", (Object)new Integer(805), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CAST128_CBC_PAD", (Object)new Integer(805), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RC5_KEY_GEN", (Object)new Integer(816), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RC5_ECB", (Object)new Integer(817), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RC5_CBC", (Object)new Integer(818), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RC5_MAC", (Object)new Integer(819), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RC5_MAC_GENERAL", (Object)new Integer(820), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_RC5_CBC_PAD", (Object)new Integer(821), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_IDEA_KEY_GEN", (Object)new Integer(832), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_IDEA_ECB", (Object)new Integer(833), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_IDEA_CBC", (Object)new Integer(834), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_IDEA_MAC", (Object)new Integer(835), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_IDEA_MAC_GENERAL", (Object)new Integer(836), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_IDEA_CBC_PAD", (Object)new Integer(837), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_GENERIC_SECRET_KEY_GEN", (Object)new Integer(848), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CONCATENATE_BASE_AND_KEY", (Object)new Integer(864), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CONCATENATE_BASE_AND_DATA", (Object)new Integer(866), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_CONCATENATE_DATA_AND_BASE", (Object)new Integer(867), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_XOR_BASE_AND_DATA", (Object)new Integer(868), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_EXTRACT_KEY_FROM_KEY", (Object)new Integer(869), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SSL3_PRE_MASTER_KEY_GEN", (Object)new Integer(880), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SSL3_MASTER_KEY_DERIVE", (Object)new Integer(881), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SSL3_KEY_AND_MAC_DERIVE", (Object)new Integer(882), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SSL3_MASTER_KEY_DERIVE_DH", (Object)new Integer(883), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_TLS_PRE_MASTER_KEY_GEN", (Object)new Integer(884), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_TLS_MASTER_KEY_DERIVE", (Object)new Integer(885), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_TLS_KEY_AND_MAC_DERIVE", (Object)new Integer(886), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_TLS_MASTER_KEY_DERIVE_DH", (Object)new Integer(887), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SSL3_MD5_MAC", (Object)new Integer(896), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SSL3_SHA1_MAC", (Object)new Integer(897), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_MD5_KEY_DERIVATION", (Object)new Integer(912), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_MD2_KEY_DERIVATION", (Object)new Integer(913), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SHA1_KEY_DERIVATION", (Object)new Integer(914), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_PBE_MD2_DES_CBC", (Object)new Integer(928), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_PBE_MD5_DES_CBC", (Object)new Integer(929), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_PBE_MD5_CAST_CBC", (Object)new Integer(930), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_PBE_MD5_CAST3_CBC", (Object)new Integer(931), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_PBE_MD5_CAST5_CBC", (Object)new Integer(932), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_PBE_MD5_CAST128_CBC", (Object)new Integer(932), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_PBE_SHA1_CAST5_CBC", (Object)new Integer(933), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_PBE_SHA1_CAST128_CBC", (Object)new Integer(933), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_PBE_SHA1_RC4_128", (Object)new Integer(934), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_PBE_SHA1_RC4_40", (Object)new Integer(935), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_PBE_SHA1_DES3_EDE_CBC", (Object)new Integer(936), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_PBE_SHA1_DES2_EDE_CBC", (Object)new Integer(937), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_PBE_SHA1_RC2_128_CBC", (Object)new Integer(938), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_PBE_SHA1_RC2_40_CBC", (Object)new Integer(939), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_PKCS5_PBKD2", (Object)new Integer(944), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_PBA_SHA1_WITH_SHA1_HMAC", (Object)new Integer(960), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_KEY_WRAP_LYNKS", (Object)new Integer(1024), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_KEY_WRAP_SET_OAEP", (Object)new Integer(1025), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SKIPJACK_KEY_GEN", (Object)new Integer(4096), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SKIPJACK_ECB64", (Object)new Integer(4097), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SKIPJACK_CBC64", (Object)new Integer(4098), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SKIPJACK_OFB64", (Object)new Integer(4099), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SKIPJACK_CFB64", (Object)new Integer(4100), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SKIPJACK_CFB32", (Object)new Integer(4101), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SKIPJACK_CFB16", (Object)new Integer(4102), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SKIPJACK_CFB8", (Object)new Integer(4103), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SKIPJACK_WRAP", (Object)new Integer(4104), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SKIPJACK_PRIVATE_WRAP", (Object)new Integer(4105), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_SKIPJACK_RELAYX", (Object)new Integer(4106), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_KEA_KEY_PAIR_GEN", (Object)new Integer(4112), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_KEA_KEY_DERIVE", (Object)new Integer(4113), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_FORTEZZA_TIMESTAMP", (Object)new Integer(4128), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_BATON_KEY_GEN", (Object)new Integer(4144), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_BATON_ECB128", (Object)new Integer(4145), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_BATON_ECB96", (Object)new Integer(4146), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_BATON_CBC128", (Object)new Integer(4147), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_BATON_COUNTER", (Object)new Integer(4148), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_BATON_SHUFFLE", (Object)new Integer(4149), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_BATON_WRAP", (Object)new Integer(4150), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_ECDSA_KEY_PAIR_GEN", (Object)new Integer(4160), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_EC_KEY_PAIR_GEN", (Object)new Integer(4160), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_ECDSA", (Object)new Integer(4161), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_ECDSA_SHA1", (Object)new Integer(4162), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_ECDH1_DERIVE", (Object)new Integer(4176), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_ECDH1_COFACTOR_DERIVE", (Object)new Integer(4177), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_ECMQV_DERIVE", (Object)new Integer(4178), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_JUNIPER_KEY_GEN", (Object)new Integer(4192), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_JUNIPER_ECB128", (Object)new Integer(4193), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_JUNIPER_CBC128", (Object)new Integer(4194), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_JUNIPER_COUNTER", (Object)new Integer(4195), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_JUNIPER_SHUFFLE", (Object)new Integer(4196), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_JUNIPER_WRAP", (Object)new Integer(4197), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_FASTHASH", (Object)new Integer(4208), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_AES_KEY_GEN", (Object)new Integer(4224), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_AES_ECB", (Object)new Integer(4225), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_AES_CBC", (Object)new Integer(4226), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_AES_MAC", (Object)new Integer(4227), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_AES_MAC_GENERAL", (Object)new Integer(4228), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_AES_CBC_PAD", (Object)new Integer(4229), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_DSA_PARAMETER_GEN", (Object)new Integer(8192), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_DH_PKCS_PARAMETER_GEN", (Object)new Integer(8193), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CKM_X9_42_DH_PARAMETER_GEN", (Object)new Integer(8194), (int)0);
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"PKCS11Session() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 2, 3);
        if (!(args[0] instanceof JsPKCS11Provider)) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 16, 1, "Argument must be of type PKCS11Provider");
        }
        JsPKCS11Provider p = (JsPKCS11Provider)((Object)args[0]);
        int slotNo = ArgChecker.getInt((Scriptable)ctorObj, clazzName, args, 1, 0);
        boolean rw = ArgChecker.getBoolean((Scriptable)ctorObj, clazzName, args, 2, false);
        JsPKCS11Session s = new JsPKCS11Session();
        try {
            PKCS11Slot slot = new PKCS11Slot(p.provider, (long)slotNo);
            s.session = PKCS11Session.open((PKCS11Slot)slot, (int)(rw ? 1 : 0));
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 7, 0, "Opening session on PKCS#11 module failed: " + e.getMessage());
        }
        return s;
    }

    public static void jsFunction_login(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 2);
        String password = ArgChecker.getString(thisObj, clazzName, args, 0, null);
        boolean so = ArgChecker.getBoolean(thisObj, clazzName, args, 1, false);
        PKCS11Session s = ((JsPKCS11Session)thisObj).session;
        try {
            if (so) {
                s.loginSO(password.toCharArray());
            } else {
                s.loginUser(password.toCharArray());
            }
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 1, 0, e.getMessage());
        }
    }

    public static void jsFunction_initPIN(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        String password = ArgChecker.getString(thisObj, clazzName, args, 0, null);
        PKCS11Session s = ((JsPKCS11Session)thisObj).session;
        try {
            s.initPIN(password.toCharArray());
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 1, 0, e.getMessage());
        }
    }

    public static void jsFunction_setPIN(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        String oldPIN = ArgChecker.getString(thisObj, clazzName, args, 0, null);
        String newPIN = ArgChecker.getString(thisObj, clazzName, args, 1, null);
        PKCS11Session s = ((JsPKCS11Session)thisObj).session;
        try {
            s.setPIN(oldPIN.toCharArray(), newPIN.toCharArray());
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 1, 0, e.getMessage());
        }
    }

    public static Scriptable jsFunction_enumerateObjects(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        PKCS11Attribute[] attr;
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 1);
        if (args.length > 0) {
            if (!(args[0] instanceof ScriptableObject)) {
                GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 1, "Argument must be of type ScriptableObject");
            }
            attr = JsPKCS11Object.generateAttributeList(thisObj, (ScriptableObject)args[0]);
        } else {
            attr = new PKCS11Attribute[]{};
        }
        PKCS11Session s = ((JsPKCS11Session)thisObj).session;
        List<PKCS11GenericObject> objects = null;
        try {
            objects = PKCS11GenericObject.getObjects(s, attr);
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 23, 0, e.getMessage());
        }
        Object[] arrayElements = new Object[objects.size()];
        for (int i = 0; i < objects.size(); ++i) {
            Object[] cargs = new Object[]{thisObj, objects.get(i)};
            arrayElements[i] = cx.newObject(thisObj, "PKCS11Object", cargs);
        }
        return cx.newArray(thisObj, arrayElements);
    }

    public static Scriptable jsFunction_generateKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 3, 3);
        int mech = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        ByteString param = ArgChecker.getByteString(thisObj, clazzName, args, 1, null);
        if (!(args[2] instanceof ScriptableObject)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 3, "Argument must be of type ScriptableObject");
        }
        PKCS11Attribute[] attr = JsPKCS11Object.generateAttributeList(thisObj, (ScriptableObject)args[2]);
        JsPKCS11Session s = (JsPKCS11Session)thisObj;
        byte[] bs = null;
        if (param != null) {
            bs = param.getBytes();
        }
        PKCS11GenericObject key = null;
        try {
            long keyhandle = s.session.generateKey(mech, (Object)bs, attr);
            key = new PKCS11GenericObject(s.session, keyhandle);
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, e.getMessage());
        }
        Object[] arg = new Object[]{thisObj, key};
        return cx.newObject(thisObj, "PKCS11Object", arg);
    }

    public static Scriptable jsFunction_generateKeyPair(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 4, 4);
        int mech = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        ByteString param = ArgChecker.getByteString(thisObj, clazzName, args, 1, null);
        if (!(args[2] instanceof ScriptableObject)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 3, "Argument must be of type ScriptableObject");
        }
        if (!(args[3] instanceof ScriptableObject)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 4, "Argument must be of type ScriptableObject");
        }
        PKCS11Attribute[] pubAttr = JsPKCS11Object.generateAttributeList(thisObj, (ScriptableObject)args[2]);
        PKCS11Attribute[] priAttr = JsPKCS11Object.generateAttributeList(thisObj, (ScriptableObject)args[3]);
        JsPKCS11Session s = (JsPKCS11Session)thisObj;
        byte[] bs = null;
        if (param != null) {
            bs = param.getBytes();
        }
        PKCS11GenericObject pubKey = null;
        PKCS11GenericObject priKey = null;
        try {
            long[] keyhandles = null;
            keyhandles = s.session.generateKeyPair(mech, (Object)bs, pubAttr, priAttr);
            pubKey = new PKCS11GenericObject(s.session, keyhandles[0]);
            priKey = new PKCS11GenericObject(s.session, keyhandles[1]);
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, e.getMessage());
        }
        Object[] keys = new Object[2];
        Object[] arg1 = new Object[]{thisObj, pubKey};
        keys[0] = cx.newObject(thisObj, "PKCS11Object", arg1);
        Object[] arg2 = new Object[]{thisObj, priKey};
        keys[1] = cx.newObject(thisObj, "PKCS11Object", arg2);
        return cx.newArray(thisObj, keys);
    }

    public static Scriptable jsFunction_wrapKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 4, 4);
        int mech = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        ByteString param = ArgChecker.getByteString(thisObj, clazzName, args, 1, null);
        if (!(args[2] instanceof JsPKCS11Object)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 3, "Argument must be of type PKCS11Object");
        }
        if (!(args[3] instanceof JsPKCS11Object)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 4, "Argument must be of type PKCS11Object");
        }
        JsPKCS11Object wrapkey = (JsPKCS11Object)((Object)args[2]);
        JsPKCS11Object key = (JsPKCS11Object)((Object)args[3]);
        JsPKCS11Session s = (JsPKCS11Session)thisObj;
        byte[] bs = null;
        if (param != null) {
            bs = param.getBytes();
        }
        byte[] wrappedkey = null;
        try {
            wrappedkey = s.session.wrapKey(mech, (Object)bs, wrapkey.getPKCS11Object(), key.getPKCS11Object());
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, e.getMessage());
        }
        return ByteString.newInstance(thisObj, wrappedkey);
    }

    public static Scriptable jsFunction_unwrapKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 5, 5);
        int mech = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        ByteString param = ArgChecker.getByteString(thisObj, clazzName, args, 1, null);
        if (!(args[2] instanceof JsPKCS11Object)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 2, "Argument must be of type PKCS11Object");
        }
        JsPKCS11Object wrapKey = (JsPKCS11Object)((Object)args[2]);
        ByteString wrappedKey = ArgChecker.getByteString(thisObj, clazzName, args, 3, null);
        if (!(args[4] instanceof ScriptableObject)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 4, "Argument must be of type ScriptableObject");
        }
        PKCS11Attribute[] attr = JsPKCS11Object.generateAttributeList(thisObj, (ScriptableObject)args[4]);
        JsPKCS11Session s = (JsPKCS11Session)thisObj;
        byte[] bs = null;
        if (param != null) {
            bs = param.getBytes();
        }
        PKCS11GenericObject key = null;
        try {
            long keyhandle = s.session.unwrapKey(mech, (Object)bs, wrapKey.getPKCS11Object(), wrappedKey.getBytes(), attr);
            key = new PKCS11GenericObject(s.session, keyhandle);
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, e.getMessage());
        }
        Object[] arg = new Object[]{thisObj, key};
        return cx.newObject(thisObj, "PKCS11Object", arg);
    }

    public static Scriptable jsFunction_deriveKey(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 4, 4);
        int mech = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        ByteString param = ArgChecker.getByteString(thisObj, clazzName, args, 1, null);
        if (!(args[2] instanceof JsPKCS11Object)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 2, "Argument must be of type PKCS11Object");
        }
        JsPKCS11Object baseKey = (JsPKCS11Object)((Object)args[2]);
        if (!(args[3] instanceof ScriptableObject)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 3, "Argument must be of type ScriptableObject");
        }
        PKCS11Attribute[] attr = JsPKCS11Object.generateAttributeList(thisObj, (ScriptableObject)args[3]);
        JsPKCS11Session s = (JsPKCS11Session)thisObj;
        byte[] bs = null;
        if (param != null) {
            bs = param.getBytes();
        }
        PKCS11GenericObject key = null;
        try {
            long keyhandle = s.session.deriveKey(mech, (Object)bs, baseKey.getPKCS11Object(), attr);
            key = new PKCS11GenericObject(s.session, keyhandle);
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, e.getMessage());
        }
        Object[] arg = new Object[]{thisObj, key};
        return cx.newObject(thisObj, "PKCS11Object", arg);
    }

    public static void jsFunction_signInit(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 3);
        int mech = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        PKCS11Object p11o = null;
        if (args[1] instanceof JsPKCS11Object) {
            p11o = ((JsPKCS11Object)((Object)args[1])).getPKCS11Object();
        } else if (args[1] instanceof GPKey) {
            try {
                p11o = (PKCS11Object)((GPKey)((Object)args[1])).getJCEKey(null);
            }
            catch (Exception e) {
                GPError.throwAsGPErrorEx(thisObj, clazzName, 9, 1, "Argument is not a valid PKCS#11 key");
            }
        } else {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 1, "Argument must be of type PKCS11Object or Key");
        }
        ByteString bs = ArgChecker.getByteString(thisObj, clazzName, args, 2, null);
        byte[] parameter = bs == null ? null : bs.getBytes();
        JsPKCS11Session s = (JsPKCS11Session)thisObj;
        try {
            s.session.signInit(p11o, mech, parameter);
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "C_SignInit failed: " + e.getMessage());
        }
    }

    public static Scriptable jsFunction_sign(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        byte[] message = ArgChecker.getByteString(thisObj, clazzName, args, 0, null).getBytes();
        JsPKCS11Session s = (JsPKCS11Session)thisObj;
        byte[] signature = null;
        try {
            signature = s.session.sign(message, 0, message.length);
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "C_Sign failed: " + e.getMessage());
        }
        return ByteString.newInstance(thisObj, signature);
    }

    public static void jsFunction_signUpdate(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        byte[] message = ArgChecker.getByteString(thisObj, clazzName, args, 0, null).getBytes();
        JsPKCS11Session s = (JsPKCS11Session)thisObj;
        try {
            s.session.signUpdate(message, 0, message.length);
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "C_SignUpdate failed: " + e.getMessage());
        }
    }

    public static ByteString jsFunction_signFinal(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsPKCS11Session s = (JsPKCS11Session)thisObj;
        byte[] signature = null;
        try {
            signature = s.session.signFinal();
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "C_SignFinal failed: " + e.getMessage());
        }
        return ByteString.newInstance(thisObj, signature);
    }

    public static void jsFunction_verifyInit(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 3);
        int mech = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        PKCS11Object p11o = null;
        if (args[1] instanceof JsPKCS11Object) {
            p11o = ((JsPKCS11Object)((Object)args[1])).getPKCS11Object();
        } else if (args[1] instanceof GPKey) {
            try {
                p11o = (PKCS11Object)((GPKey)((Object)args[1])).getJCEKey(null);
            }
            catch (Exception e) {
                GPError.throwAsGPErrorEx(thisObj, clazzName, 9, 1, "Argument is not a valid PKCS#11 key");
            }
        } else {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 1, "Argument must be of type PKCS11Object or Key");
        }
        ByteString bs = ArgChecker.getByteString(thisObj, clazzName, args, 2, null);
        byte[] parameter = bs == null ? null : bs.getBytes();
        JsPKCS11Session s = (JsPKCS11Session)thisObj;
        try {
            s.session.verifyInit(p11o, mech, parameter);
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "C_VerifyInit failed: " + e.getMessage());
        }
    }

    public static boolean jsFunction_verify(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        byte[] message = ArgChecker.getByteString(thisObj, clazzName, args, 0, null).getBytes();
        byte[] signature = ArgChecker.getByteString(thisObj, clazzName, args, 1, null).getBytes();
        JsPKCS11Session s = (JsPKCS11Session)thisObj;
        boolean result = false;
        try {
            result = s.session.verify(message, 0, message.length, signature);
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "C_Verify failed: " + e.getMessage());
        }
        return result;
    }

    public static void jsFunction_verifyUpdate(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        byte[] message = ArgChecker.getByteString(thisObj, clazzName, args, 0, null).getBytes();
        JsPKCS11Session s = (JsPKCS11Session)thisObj;
        try {
            s.session.verifyUpdate(message, 0, message.length);
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "C_VerifyUpdate failed: " + e.getMessage());
        }
    }

    public static boolean jsFunction_verifyFinal(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        byte[] signature = ArgChecker.getByteString(thisObj, clazzName, args, 0, null).getBytes();
        JsPKCS11Session s = (JsPKCS11Session)thisObj;
        boolean result = false;
        try {
            result = s.session.verifyFinal(signature);
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "C_VerifyFinal failed: " + e.getMessage());
        }
        return result;
    }

    public static void jsFunction_encryptInit(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 3);
        int mech = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        PKCS11Object p11o = null;
        if (args[1] instanceof JsPKCS11Object) {
            p11o = ((JsPKCS11Object)((Object)args[1])).getPKCS11Object();
        } else if (args[1] instanceof GPKey) {
            try {
                p11o = (PKCS11Object)((GPKey)((Object)args[1])).getJCEKey(null);
            }
            catch (Exception e) {
                GPError.throwAsGPErrorEx(thisObj, clazzName, 9, 1, "Argument is not a valid PKCS#11 key");
            }
        } else {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 1, "Argument must be of type PKCS11Object or Key");
        }
        ByteString bs = ArgChecker.getByteString(thisObj, clazzName, args, 2, null);
        byte[] parameter = bs == null ? null : bs.getBytes();
        JsPKCS11Session s = (JsPKCS11Session)thisObj;
        try {
            s.session.encryptInit(p11o, mech, parameter);
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "C_EncryptInit failed: " + e.getMessage());
        }
    }

    public static ByteString jsFunction_encrypt(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        byte[] message = ArgChecker.getByteString(thisObj, clazzName, args, 0, null).getBytes();
        JsPKCS11Session s = (JsPKCS11Session)thisObj;
        byte[] cipher = null;
        try {
            cipher = s.session.encrypt(message, 0, message.length);
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "C_Encrypt failed: " + e.getMessage());
        }
        return ByteString.newInstance(thisObj, cipher);
    }

    public static ByteString jsFunction_encryptUpdate(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        byte[] message = ArgChecker.getByteString(thisObj, clazzName, args, 0, null).getBytes();
        JsPKCS11Session s = (JsPKCS11Session)thisObj;
        byte[] cipher = null;
        try {
            cipher = s.session.encryptUpdate(message, 0, message.length);
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "C_EncryptUpdate failed: " + e.getMessage());
        }
        return ByteString.newInstance(thisObj, cipher);
    }

    public static ByteString jsFunction_encryptFinal(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsPKCS11Session s = (JsPKCS11Session)thisObj;
        byte[] cipher = null;
        try {
            cipher = s.session.encryptFinal();
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "C_EncryptFinal failed: " + e.getMessage());
        }
        if (cipher == null) {
            return null;
        }
        return ByteString.newInstance(thisObj, cipher);
    }

    public static void jsFunction_decryptInit(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 3);
        int mech = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        PKCS11Object p11o = null;
        if (args[1] instanceof JsPKCS11Object) {
            p11o = ((JsPKCS11Object)((Object)args[1])).getPKCS11Object();
        } else if (args[1] instanceof GPKey) {
            try {
                p11o = (PKCS11Object)((GPKey)((Object)args[1])).getJCEKey(null);
            }
            catch (Exception e) {
                GPError.throwAsGPErrorEx(thisObj, clazzName, 9, 1, "Argument is not a valid PKCS#11 key");
            }
        } else {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 1, "Argument must be of type PKCS11Object or Key");
        }
        ByteString bs = ArgChecker.getByteString(thisObj, clazzName, args, 2, null);
        byte[] parameter = bs == null ? null : bs.getBytes();
        JsPKCS11Session s = (JsPKCS11Session)thisObj;
        try {
            s.session.decryptInit(p11o, mech, parameter);
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "C_DecryptInit failed: " + e.getMessage());
        }
    }

    public static ByteString jsFunction_decrypt(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        byte[] message = ArgChecker.getByteString(thisObj, clazzName, args, 0, null).getBytes();
        JsPKCS11Session s = (JsPKCS11Session)thisObj;
        byte[] cipher = null;
        try {
            cipher = s.session.decrypt(message, 0, message.length);
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "C_Decrypt failed: " + e.getMessage());
        }
        return ByteString.newInstance(thisObj, cipher);
    }

    public static ByteString jsFunction_decryptUpdate(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        byte[] message = ArgChecker.getByteString(thisObj, clazzName, args, 0, null).getBytes();
        JsPKCS11Session s = (JsPKCS11Session)thisObj;
        byte[] cipher = null;
        try {
            cipher = s.session.decryptUpdate(message, 0, message.length);
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "C_DecryptUpdate failed: " + e.getMessage());
        }
        return ByteString.newInstance(thisObj, cipher);
    }

    public static ByteString jsFunction_decryptFinal(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsPKCS11Session s = (JsPKCS11Session)thisObj;
        byte[] cipher = null;
        try {
            cipher = s.session.decryptFinal();
        }
        catch (PKCS11Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "C_DecryptFinal failed: " + e.getMessage());
        }
        if (cipher == null) {
            return null;
        }
        return ByteString.newInstance(thisObj, cipher);
    }

    public static void jsFunction_close(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        PKCS11Session s = ((JsPKCS11Session)thisObj).session;
        try {
            s.destroy();
        }
        catch (DestroyFailedException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 1, 0, e.getMessage());
        }
    }
}

