/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.ocsp;

import de.cardcontact.scdp.ocsp.OCSPQueryException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.UnknownStatus;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentVerifierProviderBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.x509.extension.X509ExtensionUtil;

public class OCSPQuery {
    public static final int GOOD = 0;
    public static final int UNKNOWN = 1;
    public static final int REVOKED = 100;
    public static final int KEYCOMPROMISE = 101;
    public static final int CACOMPROMISE = 102;
    public static final int AFFILIATIONCHANGED = 103;
    public static final int SUPERSEDED = 104;
    public static final int CESSATIONOFOPERATION = 105;
    public static final int CERTIFICATEHOLD = 106;
    public static final int REMOVEFROMCRL = 108;
    public static final int PRIVILEGEWITHDRAWN = 109;
    public static final int AACOMPROMISE = 110;
    X509Certificate issuercert;
    X509Certificate rootcert;
    HashMap map;
    HashMap cs;
    DigestCalculatorProvider digCalcProv;
    byte[] ocspResponse;

    public OCSPQuery(X509Certificate rootcert, X509Certificate issuercert) {
        this.issuercert = issuercert;
        this.rootcert = rootcert;
        this.map = new HashMap();
        this.cs = null;
        try {
            this.digCalcProv = new JcaDigestCalculatorProviderBuilder().setProvider("BC").build();
        }
        catch (OperatorCreationException e) {
            e.printStackTrace();
        }
    }

    public static String reasonText(int reason) {
        String rt = "Invalid reason code";
        switch (reason) {
            case 0: {
                rt = "Good";
                break;
            }
            case 1: {
                rt = "Unknown";
                break;
            }
            case 100: {
                rt = "Revoked(0)";
                break;
            }
            case 101: {
                rt = "Key compromise(1)";
                break;
            }
            case 102: {
                rt = "CA compromise(2)";
                break;
            }
            case 103: {
                rt = "Affilitation changed(3)";
                break;
            }
            case 104: {
                rt = "Superseded(4)";
                break;
            }
            case 105: {
                rt = "Cessation of operation(5)";
                break;
            }
            case 106: {
                rt = "Certificate hold(6)";
                break;
            }
            case 108: {
                rt = "Remove from CRL(8)";
                break;
            }
            case 109: {
                rt = "Privilege withdrawn(9)";
                break;
            }
            case 110: {
                rt = "AA compromise(10)";
            }
        }
        return rt;
    }

    public void addCertificate(X509Certificate cert) throws OCSPQueryException {
        try {
            cert.verify(this.issuercert.getPublicKey());
            JcaX509CertificateHolder certholder = new JcaX509CertificateHolder(cert);
            CertificateID certid = new CertificateID(this.digCalcProv.get(CertificateID.HASH_SHA1), (X509CertificateHolder)certholder, cert.getSerialNumber());
            this.map.put(certid, cert);
        }
        catch (Exception e) {
            throw new OCSPQueryException(e.toString());
        }
    }

    public byte[] getRequest() throws OCSPQueryException {
        byte[] request = null;
        try {
            OCSPReqBuilder gen = new OCSPReqBuilder();
            for (CertificateID certid : this.map.keySet()) {
                gen.addRequest(certid);
            }
            request = gen.build().getEncoded();
        }
        catch (Exception e) {
            throw new OCSPQueryException(e.toString());
        }
        return request;
    }

    public byte[] getResponse() throws OCSPQueryException {
        return this.ocspResponse;
    }

    public byte[] post(String urlstring, byte[] request, String[] header) throws OCSPQueryException {
        try {
            URL url = new URL(urlstring);
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setAllowUserInteraction(false);
            con.setDoInput(true);
            con.setDoOutput(true);
            con.setUseCaches(false);
            con.setInstanceFollowRedirects(false);
            con.setRequestMethod("POST");
            if (header == null) {
                con.setRequestProperty("Content-Length", Integer.toString(request.length));
                con.setRequestProperty("Content-Type", "application/ocsp-request");
            } else {
                for (int i = 0; i < header.length; ++i) {
                    String field = header[i];
                    int pos = field.indexOf(58);
                    if (pos == -1) {
                        throw new OCSPQueryException("HTTP header must be in format '<key>: <value>'");
                    }
                    String key = field.substring(0, pos);
                    String value = field.substring(pos + 2);
                    con.setRequestProperty(key, value);
                }
            }
            con.connect();
            OutputStream os = con.getOutputStream();
            os.write(request);
            os.close();
            if (con.getResponseCode() != 200) {
                throw new OCSPQueryException("Server did not respond with HTTP_OK(200) but with " + con.getResponseCode());
            }
            if (con.getContentType() == null || !con.getContentType().equals("application/ocsp-response")) {
                throw new OCSPQueryException("Response MIME type is not application/ocsp-response");
            }
            InputStream reader = con.getInputStream();
            int resplen = con.getContentLength();
            if (resplen < 0) {
                resplen = 32768;
            }
            this.ocspResponse = new byte[resplen];
            int offset = 0;
            int bread = 0;
            while (resplen > 0 && (bread = reader.read(this.ocspResponse, offset, resplen)) != -1) {
                offset += bread;
                resplen -= bread;
            }
            reader.close();
            con.disconnect();
            if (bread == -1) {
                byte[] tr = new byte[offset];
                System.arraycopy(this.ocspResponse, 0, tr, 0, offset);
                this.ocspResponse = tr;
            } else if (resplen > 0) {
                throw new OCSPQueryException("Could not read full response");
            }
        }
        catch (OCSPQueryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OCSPQueryException("Error talking to OCSP responder: " + e.getMessage());
        }
        this.cs = null;
        return this.ocspResponse;
    }

    public byte[] post(String urlstring, byte[] request) throws OCSPQueryException {
        return this.post(urlstring, request, null);
    }

    public void decodeResponse(byte[] response) throws OCSPQueryException {
        try {
            this.ocspResponse = response;
            OCSPResp ocspresp = new OCSPResp(response);
            switch (ocspresp.getStatus()) {
                case 0: {
                    break;
                }
                case 2: {
                    throw new OCSPQueryException("Internal OCSP server error");
                }
                case 1: {
                    throw new OCSPQueryException("Malformed request");
                }
                case 5: {
                    throw new OCSPQueryException("Signature required for request");
                }
                case 3: {
                    throw new OCSPQueryException("The server was too busy to answer");
                }
                case 6: {
                    throw new OCSPQueryException("Not authorised to access server");
                }
                default: {
                    throw new OCSPQueryException("Unknown OCSPResponse status code");
                }
            }
            BasicOCSPResp bresp = (BasicOCSPResp)ocspresp.getResponseObject();
            if (bresp == null) {
                throw new OCSPQueryException("No BasicOCSPResponse found in response");
            }
            X509CertificateHolder[] ocspcerts = bresp.getCerts();
            if (!bresp.isSignatureValid(new JcaContentVerifierProviderBuilder().setProvider("BC").build(ocspcerts[0]))) {
                throw new OCSPQueryException("OCSP Signature verification failed");
            }
            SingleResp[] certstat = bresp.getResponses();
            this.cs = new HashMap(certstat.length);
            for (int i = 0; i < certstat.length; ++i) {
                CertificateID certID = certstat[i].getCertID();
                this.cs.put(certID, certstat[i]);
            }
        }
        catch (OCSPQueryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OCSPQueryException("OCSP decode error: " + String.valueOf(e));
        }
    }

    public void execute(String url) throws OCSPQueryException {
        try {
            this.ocspResponse = this.post(url, this.getRequest());
            this.decodeResponse(this.ocspResponse);
        }
        catch (OCSPQueryException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OCSPQueryException("OCSP.execute() error: " + String.valueOf(e));
        }
    }

    public void execute() throws OCSPQueryException {
        String urlstr;
        try {
            byte[] ocspext = this.issuercert.getExtensionValue("1.3.6.1.5.5.7.1.1");
            ASN1Sequence asn1 = (ASN1Sequence)X509ExtensionUtil.fromExtensionValue((byte[])ocspext);
            asn1 = (ASN1Sequence)asn1.getObjectAt(0);
            ASN1TaggedObject tasn1 = (ASN1TaggedObject)asn1.getObjectAt(1);
            DEROctetString ostr = (DEROctetString)tasn1.getObject();
            urlstr = new String(ostr.getOctets());
        }
        catch (Exception e) {
            throw new OCSPQueryException("OCSP.execute() error: " + String.valueOf(e));
        }
        this.execute(urlstr);
    }

    public int certStatus(X509Certificate cert) throws OCSPQueryException {
        if (this.cs == null) {
            this.decodeResponse(this.ocspResponse);
        }
        int rc = 0;
        try {
            JcaX509CertificateHolder certholder = new JcaX509CertificateHolder(this.issuercert);
            CertificateID certid = new CertificateID(this.digCalcProv.get(CertificateID.HASH_SHA1), (X509CertificateHolder)certholder, cert.getSerialNumber());
            SingleResp sr = (SingleResp)this.cs.get(certid);
            if (sr == null) {
                throw new OCSPQueryException("Certificate not contained in query");
            }
            CertificateStatus ro = sr.getCertStatus();
            if (ro != null) {
                if (ro instanceof RevokedStatus) {
                    RevokedStatus ri = (RevokedStatus)ro;
                    rc = 100;
                    if (ri.hasRevocationReason()) {
                        rc = ri.getRevocationReason() + 100;
                    }
                } else if (ro instanceof UnknownStatus) {
                    rc = 1;
                }
            }
        }
        catch (Exception e) {
            throw new OCSPQueryException("OCSP.certStatus() error: " + String.valueOf(e));
        }
        return rc;
    }

    public Date getRevocationTime(X509Certificate cert) throws OCSPQueryException {
        if (this.cs == null) {
            this.decodeResponse(this.ocspResponse);
        }
        Date rd = null;
        try {
            JcaX509CertificateHolder certholder = new JcaX509CertificateHolder(this.issuercert);
            CertificateID certid = new CertificateID(this.digCalcProv.get(CertificateID.HASH_SHA1), (X509CertificateHolder)certholder, cert.getSerialNumber());
            SingleResp sr = (SingleResp)this.cs.get(certid);
            CertificateStatus ro = sr.getCertStatus();
            if (ro != null && ro instanceof RevokedStatus) {
                RevokedStatus ri = (RevokedStatus)ro;
                rd = ri.getRevocationTime();
            }
        }
        catch (Exception e) {
            throw new OCSPQueryException("OCSP.certStatus() error: " + String.valueOf(e));
        }
        return rd;
    }
}

