/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.js;

import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.js.JsURLConnection;
import de.cardcontact.scdp.js.URLConnectionStreamHandler;
import de.cardcontact.scdp.utils.ArgChecker;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPConnectionFactory;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.xml.XMLObject;
import org.mozilla.javascript.xmlimpl.XMLLibImpl;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class JsSOAPConnection
extends ScriptableObject {
    private static final long serialVersionUID = -8705315852635417771L;
    private SOAPConnection connection;
    private String soapVersion = "SOAP 1.2 Protocol";
    public static final String clazzName = "SOAPConnection";

    public String getClassName() {
        return clazzName;
    }

    public static void finishInit(Scriptable scope, FunctionObject ctor, Scriptable proto) {
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SOAP11", (Object)"SOAP 1.1 Protocol", (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SOAP12", (Object)"SOAP 1.2 Protocol", (int)0);
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) {
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 0, 1);
        JsSOAPConnection t = new JsSOAPConnection();
        t.soapVersion = ArgChecker.getString((Scriptable)ctorObj, clazzName, args, 0, "SOAP 1.2 Protocol");
        try {
            SOAPConnectionFactory scf = SOAPConnectionFactory.newInstance();
            t.connection = scf.createConnection();
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 19, 0, "Creating SOAPConnection failed : " + e.getMessage());
        }
        return t;
    }

    private XMLObject call(Context cx, URL url, XMLObject xmlRequest) {
        Node domRequest = XMLLibImpl.toDomNode((Object)xmlRequest);
        XMLObject xmlResult = null;
        try {
            MessageFactory mf = MessageFactory.newInstance((String)this.soapVersion);
            SOAPMessage message = mf.createMessage();
            SOAPBody body = message.getSOAPBody();
            Document soapDocument = body.getOwnerDocument();
            Node importedNode = soapDocument.importNode(domRequest, true);
            body.appendChild(importedNode);
            SOAPMessage response = this.connection.call(message, (Object)url);
            Document doc = response.getSOAPBody().extractContentAsDocument();
            Object[] param = new Object[]{doc};
            xmlResult = (XMLObject)cx.newObject((Scriptable)this, "XML", param);
        }
        catch (SOAPException e) {
            Throwable ce = e.getCause();
            if (ce == null) {
                ce = e;
            }
            GPError.throwAsGPErrorEx((Scriptable)this, clazzName, 7, 0, "Error processing SOAP request: " + ce.getMessage());
        }
        return xmlResult;
    }

    public static XMLObject jsFunction_call(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        URL url = null;
        try {
            if (args[0] instanceof JsURLConnection) {
                JsURLConnection conn = (JsURLConnection)((Object)args[0]);
                url = new URL(conn.getURL(), "", new URLConnectionStreamHandler(conn));
            } else {
                String urlString = ArgChecker.getString(thisObj, clazzName, args, 0, null);
                url = new URL(urlString);
            }
        }
        catch (MalformedURLException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 9, 0, "MalformedURLException: " + String.valueOf(e));
        }
        if (!(args[1] instanceof XMLObject)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 0, "Argument must be of type XML");
        }
        JsSOAPConnection t = (JsSOAPConnection)thisObj;
        return t.call(cx, url, (XMLObject)args[1]);
    }

    public static void jsFunction_close(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsSOAPConnection t = (JsSOAPConnection)thisObj;
        try {
            t.connection.close();
        }
        catch (SOAPException e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 7, 0, "Error closing SOAP connection: " + e.getMessage());
        }
    }
}

