/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.gp;

import de.cardcontact.scdp.engine.Engine;
import de.cardcontact.scdp.engine.Shell;
import de.cardcontact.scdp.gp.GPError;
import java.io.PrintStream;
import opencard.core.event.CTListener;
import opencard.core.event.CardTerminalEvent;
import opencard.core.terminal.CardTerminalException;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class CardEventListenerAdapter
implements CTListener {
    private Scriptable parentScope;
    private Scriptable jsObject;
    private Function cardInserted;
    private Function cardRemoved;
    private Function cardNotification;
    public static final String clazzName = "CardEventListerAdapter";

    public CardEventListenerAdapter(Scriptable parentScope, Scriptable jsObject) {
        this.parentScope = parentScope;
        this.jsObject = jsObject;
        Object o = ScriptableObject.getProperty((Scriptable)jsObject, (String)"cardInserted");
        if (o == Scriptable.NOT_FOUND || !(o instanceof Function)) {
            GPError.throwAsGPErrorEx(parentScope, clazzName, 9, 1, "Method 'cardInserted' not found or of wrong type");
        }
        this.cardInserted = (Function)o;
        o = ScriptableObject.getProperty((Scriptable)jsObject, (String)"cardRemoved");
        if (o == Scriptable.NOT_FOUND || !(o instanceof Function)) {
            GPError.throwAsGPErrorEx(parentScope, clazzName, 9, 1, "Method 'cardRemoved' not found or of wrong type");
        }
        this.cardRemoved = (Function)o;
        this.cardNotification = null;
        o = ScriptableObject.getProperty((Scriptable)jsObject, (String)"cardNotification");
        if (o != Scriptable.NOT_FOUND && o instanceof Function) {
            this.cardNotification = (Function)o;
        }
    }

    private void call(Context cx, Function f, Object[] param) {
        try {
            f.call(cx, this.parentScope, this.jsObject, param);
        }
        catch (RhinoException re) {
            PrintStream ps = Shell.getOutputStreamForObject((ScriptableObject)this.parentScope);
            if (ps == null) {
                Engine engine = Engine.getEngine(this.parentScope);
                ps = engine.getTracePrintStream();
            }
            Engine.printRhinoExceptionMessage(re, ps);
        }
    }

    public void cardInserted(CardTerminalEvent arg0) throws CardTerminalException {
        Context cx = Context.enter();
        String readerName = arg0.getCardTerminal().getName();
        Object[] param = new Object[]{readerName};
        this.call(cx, this.cardInserted, param);
    }

    public void cardRemoved(CardTerminalEvent arg0) throws CardTerminalException {
        Context cx = Context.enter();
        String readerName = arg0.getCardTerminal().getName();
        Object[] param = new Object[]{readerName};
        this.call(cx, this.cardRemoved, param);
    }

    public void cardNotification(String readerName) {
        if (this.cardNotification == null) {
            return;
        }
        Context cx = Context.enter();
        Object[] param = new Object[]{readerName};
        this.call(cx, this.cardNotification, param);
    }
}

