/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.engine;

import de.cardcontact.scdp.engine.FileResourceContext;
import de.cardcontact.scdp.engine.FileResourceLocator;
import de.cardcontact.scdp.engine.PrintStreamTracer;
import de.cardcontact.scdp.engine.SCDPErrorReporter;
import de.cardcontact.scdp.engine.VersionInfo;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.js.GPRuntime;
import de.cardcontact.scdp.js.GPTracer;
import de.cardcontact.scdp.js.JsWrapFactory;
import de.cardcontact.tlv.ObjectIdentifier;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.net.URI;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.WrapFactory;
import org.mozilla.javascript.commonjs.module.ModuleScript;
import org.mozilla.javascript.commonjs.module.ModuleScriptProvider;
import org.mozilla.javascript.commonjs.module.Require;

public class Engine
implements GPRuntime,
ModuleScriptProvider {
    protected static final Integer ID_ENGINE = new Integer(65473652);
    protected static final Integer ID_TRACER = new Integer(65478745);
    protected int runtimeEnvironmentType = 1;
    protected FileResourceLocator fileResourceLocator;
    protected ScriptableObject sharedScope;
    private PrintStream ps;
    private GPTracer tracer = null;

    public Engine() {
        Context cx = Context.enter();
        cx.setLanguageVersion(200);
        this.sharedScope = cx.initStandardObjects(null, true);
        this.sharedScope.associateValue((Object)ID_ENGINE, (Object)this);
        this.sharedScope.associateValue((Object)GPRuntime.ID_GPRUNTIME, (Object)this);
        Method[] methods = this.getClass().getMethods();
        this.addStaticMethod(methods, "defineClass", this.sharedScope);
        this.addStaticMethod(methods, "load", this.sharedScope);
        this.sharedScope.defineProperty("HEX", (Object)new Integer(16), 7);
        this.sharedScope.defineProperty("UTF8", (Object)new Integer(2), 7);
        this.sharedScope.defineProperty("ASCII", (Object)new Integer(3), 7);
        this.sharedScope.defineProperty("BASE64", (Object)new Integer(4), 7);
        this.sharedScope.defineProperty("CN", (Object)new Integer(5), 7);
        this.sharedScope.defineProperty("OID", (Object)new Integer(6), 7);
        this.sharedScope.defineProperty("SC_CLOSE", (Object)new Integer(7), 7);
        this.sharedScope.defineProperty("SC_INITIALIZE", (Object)new Integer(8), 7);
        this.sharedScope.defineProperty("SC_OPEN", (Object)new Integer(9), 7);
        Context.exit();
    }

    public void setRuntimeEnvironmentType(int type) {
        this.runtimeEnvironmentType = type;
    }

    private static Method findMethod(Method[] methods, String name) {
        for (Method m : methods) {
            if (!name.equals(m.getName())) continue;
            return m;
        }
        return null;
    }

    private void addStaticMethod(Method[] methods, String name, ScriptableObject scope) {
        Method m = Engine.findMethod(methods, name);
        FunctionObject func = new FunctionObject(name, (Member)m, (Scriptable)scope);
        scope.defineProperty(name, (Object)func, 2);
    }

    public static void defineClass(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IllegalAccessException, InstantiationException, InvocationTargetException, ClassNotFoundException {
        Class<?> clazz = Class.forName(Context.toString((Object)args[0]));
        ScriptableObject.defineClass((Scriptable)thisObj, clazz);
    }

    public static void load(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException {
        Engine engine = Engine.getEngine(thisObj);
        for (int i = 0; i < args.length; ++i) {
            engine.executeScript(cx, thisObj, Context.toString((Object)args[i]));
        }
    }

    public static Engine getEngine(Scriptable o) {
        Engine engine = (Engine)ScriptableObject.getTopScopeValue((Scriptable)o, (Object)ID_ENGINE);
        return engine;
    }

    public void setFileResourceLocator(FileResourceLocator frl) {
        this.fileResourceLocator = frl;
    }

    public FileResourceLocator getFileResourceLocator() {
        return this.fileResourceLocator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeScript(Context cx, Scriptable scope, String scriptName) throws IOException {
        String fullfilename = this.fileResourceLocator.mapFilename(scriptName, 6);
        if (fullfilename == null) {
            throw new FileNotFoundException("Script " + scriptName + " not found");
        }
        FileResourceContext savedContext = this.fileResourceLocator.getResourceContext();
        InputStream is = null;
        Object result = null;
        try {
            is = this.fileResourceLocator.openFileResource(fullfilename, true);
            InputStreamReader in = new InputStreamReader(is, "UTF-8");
            result = cx.evaluateReader(scope, (Reader)in, fullfilename, 1, null);
        }
        finally {
            this.fileResourceLocator.setResourceContext(savedContext);
            if (is != null) {
                is.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeScript(Context cx, Scriptable scope, Script script, FileResourceContext scriptFileCtx) {
        FileResourceContext savedContext = this.fileResourceLocator.getResourceContext();
        Object result = null;
        try {
            if (scriptFileCtx != null) {
                this.fileResourceLocator.setResourceContext(scriptFileCtx);
            }
            result = script.exec(cx, scope);
        }
        finally {
            this.fileResourceLocator.setResourceContext(savedContext);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object executeSetupScript(String scriptName) throws IOException {
        String fullfilename = this.fileResourceLocator.mapFilename(scriptName, 6);
        if (fullfilename == null) {
            throw new FileNotFoundException("Script " + scriptName + " not found");
        }
        Context cx = Context.enter();
        cx.setErrorReporter((ErrorReporter)new SCDPErrorReporter(this.tracer));
        FileResourceContext savedContext = this.fileResourceLocator.getResourceContext();
        InputStream is = null;
        Object result = null;
        try {
            is = this.fileResourceLocator.openFileResource(fullfilename, true);
            if (is == null) {
                throw new FileNotFoundException(fullfilename);
            }
            InputStreamReader in = new InputStreamReader(is, "UTF-8");
            result = cx.evaluateReader((Scriptable)this.sharedScope, (Reader)in, fullfilename, 1, null);
        }
        finally {
            this.fileResourceLocator.setResourceContext(savedContext);
            if (is != null) {
                is.close();
            }
            Context.exit();
        }
        return result;
    }

    public void initializeModule(ScriptableObject scope) {
        Context cx = Context.enter();
        Require require = new Require(cx, (Scriptable)scope, (ModuleScriptProvider)this, null, null, false);
        require.install((Scriptable)scope);
        Context.exit();
    }

    public void initializeModule() {
        this.initializeModule(this.sharedScope);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ModuleScript getModuleScript(Context cx, String moduleId, URI moduleUri, URI baseUri, Scriptable paths) throws Exception {
        String fullfilename;
        if (moduleUri == null) {
            fullfilename = this.fileResourceLocator.mapFilename(moduleId + ".js", 6);
            if (fullfilename == null) {
                return null;
            }
        } else {
            File f = new File(moduleUri);
            fullfilename = f.getAbsolutePath().concat(".js");
        }
        Script script = null;
        try (InputStream is = null;){
            is = this.fileResourceLocator.openFileResource(fullfilename, false);
            InputStreamReader in = new InputStreamReader(is, "UTF-8");
            script = cx.compileReader((Reader)in, fullfilename, 1, null);
        }
        URI moduri = new File(fullfilename).toURI();
        ModuleScript ms = new ModuleScript(script, moduri, null);
        return ms;
    }

    public void doneWithSetup() {
        Context.enter();
        this.sharedScope.sealObject();
        Context.exit();
    }

    public ScriptableObject getSharedScope() {
        return this.sharedScope;
    }

    public Scriptable newDynamicScope(String className, Object[] args) {
        Context cx = Context.enter();
        Scriptable newScope = cx.newObject((Scriptable)this.sharedScope, className, args);
        newScope.setPrototype((Scriptable)this.sharedScope);
        newScope.setParentScope(null);
        Context.exit();
        return newScope;
    }

    public Scriptable newDynamicScope(String className) {
        return this.newDynamicScope(className, Context.emptyArgs);
    }

    @Override
    public byte[] getSystemID() {
        String str = "1.3.6.1.4.1.24991.1." + this.runtimeEnvironmentType + "." + VersionInfo.MAJOR + "." + VersionInfo.MINOR + "." + VersionInfo.BUILD + ".0";
        ObjectIdentifier oid = new ObjectIdentifier(str);
        return oid.getValue();
    }

    public void setTracePrintStream(PrintStream p) {
        this.ps = p;
        this.tracer = new PrintStreamTracer(p);
    }

    @Override
    public PrintStream getTracePrintStream() {
        return this.ps;
    }

    @Override
    public String mapFilename(String filename, int location) {
        return this.fileResourceLocator.mapFilename(filename, location);
    }

    @Override
    public InputStream openFileResource(String fileName) throws FileNotFoundException {
        return this.fileResourceLocator.openFileResource(fileName, false);
    }

    public static void printRhinoExceptionMessage(RhinoException re, PrintStream s) {
        if (re instanceof JavaScriptException) {
            JavaScriptException jse = (JavaScriptException)re;
            Object o = jse.getValue();
            if (o != null) {
                if (o instanceof GPError) {
                    GPError gpe = (GPError)((Object)o);
                    s.println("GPError: " + gpe.toString());
                    s.flush();
                    return;
                }
                s.println(jse);
            }
        } else {
            s.println((Object)re);
        }
        StackTraceElement[] st = re.getStackTrace();
        for (int i = 0; i < st.length; ++i) {
            int linenumber;
            String filename = st[i].getFileName();
            if (filename == null || !filename.endsWith(".js") && !filename.endsWith(".xml") || (linenumber = st[i].getLineNumber()) < 1) continue;
            s.println("    at " + filename + "#" + linenumber);
        }
        s.flush();
    }

    public void setTracer(GPTracer tracer) {
        this.tracer = tracer;
    }

    public void setTracerForContext(Context ctx, GPTracer tracer) {
        ctx.removeThreadLocal((Object)ID_TRACER);
        ctx.putThreadLocal((Object)ID_TRACER, (Object)tracer);
        ctx.setErrorReporter((ErrorReporter)new SCDPErrorReporter(tracer));
    }

    @Override
    public GPTracer getTracer() {
        Context ctx = Context.getCurrentContext();
        if (ctx == null) {
            return this.tracer;
        }
        Object o = ctx.getThreadLocal((Object)ID_TRACER);
        if (o == null) {
            return this.tracer;
        }
        return (GPTracer)o;
    }

    static {
        ContextFactory.initGlobal((ContextFactory)new MyFactory());
    }

    static class MyFactory
    extends ContextFactory {
        JsWrapFactory wrapFactory = new JsWrapFactory();

        MyFactory() {
        }

        protected boolean hasFeature(Context cx, int featureIndex) {
            if (featureIndex == 7) {
                return true;
            }
            if (featureIndex == 8) {
                return true;
            }
            return super.hasFeature(cx, featureIndex);
        }

        protected Context makeContext() {
            Context cx = super.makeContext();
            cx.setWrapFactory((WrapFactory)this.wrapFactory);
            return cx;
        }
    }
}

