/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.utils;

import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class ArgChecker {
    public static void checkRange(Scriptable thisObj, String clazzName, Object[] args, int min, int max) {
        if (args.length < min) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 2, args.length, "Too few arguments");
        }
        if (args.length > max) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 8, args.length, "Too many arguments");
        }
    }

    public static int getInt(Scriptable thisObj, String clazzName, Object[] args, int index, int defaultValue) {
        if (args.length > index) {
            if (args[index] instanceof Number) {
                return ((Number)args[index]).intValue();
            }
            throw GPError.throwAsGPErrorEx(thisObj, clazzName, 16, index, "Expected number argument");
        }
        return defaultValue;
    }

    public static long getLong(Scriptable thisObj, String clazzName, Object[] args, int index, long defaultValue) {
        if (args.length > index) {
            if (args[index] instanceof Number) {
                return ((Number)args[index]).longValue();
            }
            throw GPError.throwAsGPErrorEx(thisObj, clazzName, 16, index, "Expected number argument");
        }
        return defaultValue;
    }

    public static byte getByte(Scriptable thisObj, String clazzName, Object[] args, int index, byte defaultValue) {
        if (args.length > index) {
            if (args[index] instanceof Number) {
                return ((Number)args[index]).byteValue();
            }
            throw GPError.throwAsGPErrorEx(thisObj, clazzName, 16, index, "Expected number argument");
        }
        return defaultValue;
    }

    public static String getString(Scriptable thisObj, String clazzName, Object[] args, int index, String defaultValue) {
        if (args.length > index) {
            if (args[index] instanceof CharSequence) {
                return Context.toString((Object)args[index]);
            }
            if (args[index] == Context.getUndefinedValue()) {
                return defaultValue;
            }
            throw GPError.throwAsGPErrorEx(thisObj, clazzName, 16, index, "Expected string argument");
        }
        return defaultValue;
    }

    public static boolean getBoolean(Scriptable thisObj, String clazzName, Object[] args, int index, boolean defaultValue) {
        if (args.length > index) {
            if (args[index] instanceof Boolean) {
                return (Boolean)args[index];
            }
            throw GPError.throwAsGPErrorEx(thisObj, clazzName, 16, index, "Expected number argument");
        }
        return defaultValue;
    }

    public static ByteString getByteString(Scriptable thisObj, String clazzName, Object[] args, int index, ByteString defaultValue) {
        if (args.length > index) {
            if (args[index] == null) {
                return null;
            }
            if (args[index] instanceof ByteString) {
                return (ByteString)((Object)args[index]);
            }
            throw GPError.throwAsGPErrorEx(thisObj, clazzName, 16, index, "Expected ByteString argument");
        }
        return defaultValue;
    }
}

