/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.cryptoscript;

import de.cardcontact.scdp.cryptoscript.CryptoInterface;

public class ScriptInterpreter {
    private byte[] stack = null;
    private short stacktop = 0;
    private CryptoInterface ci;

    public ScriptInterpreter(CryptoInterface ci, byte[] stack, short initialsize) {
        this.ci = ci;
        this.stack = stack;
        this.stacktop = initialsize;
        if (initialsize > 0) {
            this.stacktop = this.setShort(this.stack, this.stacktop, initialsize);
        }
    }

    private void arraycopy(byte[] src, short srcPos, byte[] dest, short destPos, short length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
    }

    private short makeShort(byte msb, byte lsb) {
        return (short)((msb & 0xFF) << 8 | lsb & 0xFF);
    }

    private short setShort(byte[] bs, short ofs, short val) {
        short s = ofs;
        ofs = (short)(ofs + 1);
        bs[s] = (byte)(val >> 8);
        short s2 = ofs;
        ofs = (short)(ofs + 1);
        bs[s2] = (byte)(val & 0xFF);
        return ofs;
    }

    public void push(byte[] operand, short ofs, short len) throws Exception {
        if (operand == null || len > 255) {
            throw new Exception("Invalid operand");
        }
        if (this.stack.length < this.stacktop + len + 2) {
            throw new Exception("Stack overflow");
        }
        this.arraycopy(operand, ofs, this.stack, this.stacktop, len);
        this.stacktop = (short)(this.stacktop + len);
        this.stacktop = this.setShort(this.stack, this.stacktop, len);
    }

    public void push(byte[] operand) throws Exception {
        this.push(operand, (short)0, (short)operand.length);
    }

    public short getStackPointer() {
        return this.stacktop;
    }

    public short getOperandOffset(short top) {
        return (short)(top - this.getOperandLength(top) - 2);
    }

    public short getOperandOffset() throws Exception {
        this.checkone();
        return this.getOperandOffset(this.stacktop);
    }

    public short getOperandLength(short top) {
        return this.makeShort(this.stack[top - 2], this.stack[top - 1]);
    }

    public short getOperandLength() throws Exception {
        this.checkone();
        return this.getOperandLength(this.stacktop);
    }

    public void pop() throws Exception {
        this.checkone();
        this.stacktop = (short)(this.stacktop - (this.getOperandLength(this.stacktop) + 2));
    }

    public boolean isempty() {
        return this.stacktop == 0;
    }

    public void checkone() throws Exception {
        if (this.stacktop == 0) {
            throw new Exception("Stack is empty");
        }
    }

    public void checktwo() throws Exception {
        if (this.stacktop == 0 || this.getOperandLength(this.stacktop) == this.stacktop - 2) {
            throw new Exception("No two operands on stack");
        }
    }

    public void dup() throws Exception {
        short len = this.getOperandLength();
        short ofs = this.getOperandOffset();
        this.push(this.stack, ofs, len);
    }

    public void swap() throws Exception {
        this.checktwo();
        short len2 = this.getOperandLength(this.stacktop);
        short ofs2 = (short)(this.stacktop - len2 - 2);
        short len1 = this.getOperandLength(ofs2);
        short ofs1 = (short)(this.stacktop - len1 - len2 - 4);
        this.push(this.stack, ofs1, len1);
        this.arraycopy(this.stack, ofs2, this.stack, ofs1, (short)(len1 + len2 + 4));
        this.stacktop = (short)(this.stacktop - (len1 + 2));
    }

    public void concat() throws Exception {
        this.checktwo();
        short len2 = this.getOperandLength(this.stacktop);
        short ofs2 = (short)(this.stacktop - len2 - 2);
        short len1 = this.getOperandLength(ofs2);
        this.arraycopy(this.stack, ofs2, this.stack, (short)(ofs2 - 2), len2);
        this.stacktop = (short)(this.stacktop - 4);
        this.stacktop = this.setShort(this.stack, this.stacktop, (short)(len1 + len2));
    }

    public void range(short from, short length) throws Exception {
        this.checkone();
        short len = this.getOperandLength(this.stacktop);
        short ofs = (short)(this.stacktop - len - 2);
        if (from < -len || from > len) {
            throw new Exception("From argument out of range");
        }
        if (from < 0) {
            from = (short)(len + from);
        }
        if (length < 0 || from + length > len) {
            throw new Exception("Length argument out of range");
        }
        this.push(this.stack, (short)(ofs + from), length);
    }

    public void xor() throws Exception {
        this.checktwo();
        short slen = this.getOperandLength(this.stacktop);
        short sofs = (short)(this.stacktop - slen - 2);
        short dlen = this.getOperandLength(sofs);
        short dofs = (short)(sofs - dlen - 2);
        if (dlen < slen) {
            short a = dofs;
            dofs = sofs;
            sofs = a;
            a = dlen;
            dlen = slen;
            slen = a;
        }
        if (slen <= 0) {
            throw new Exception("Shorter operand is empty");
        }
        short o = sofs;
        short j = dlen;
        while (true) {
            short s = j;
            j = (short)(j - 1);
            if (s <= 0) break;
            short s2 = dofs;
            dofs = (short)(dofs + 1);
            short s3 = o;
            o = (short)(o + 1);
            this.stack[s2] = (byte)(this.stack[s2] ^ this.stack[s3]);
            if (o < sofs + slen) continue;
            o = sofs;
        }
        if ((dofs = (short)(dofs - dlen)) > sofs) {
            this.arraycopy(this.stack, dofs, this.stack, sofs, dlen);
            dofs = sofs;
        }
        this.stacktop = (short)(dofs + dlen);
        this.stacktop = this.setShort(this.stack, this.stacktop, dlen);
    }

    public void digest(byte op) throws Exception {
        short len = this.getOperandLength(this.stacktop);
        short ofs = (short)(this.stacktop - len - 2);
        short dl = this.ci.digest(op, this.stack, ofs, len, this.stack, this.stacktop);
        this.stacktop = (short)(this.stacktop + dl);
        this.stacktop = this.setShort(this.stack, this.stacktop, dl);
    }

    public void eval(byte keyid, byte[] code) throws Exception {
        short i = 0;
        while (i < code.length) {
            short s = i;
            i = (short)(i + 1);
            byte op = code[s];
            switch (op) {
                case 0: {
                    return;
                }
                case -16: {
                    short s2 = i;
                    i = (short)(i + 1);
                    byte len = code[s2];
                    this.push(code, i, (short)(len & 0xFF));
                    i = (short)(i + len);
                    break;
                }
                case -15: {
                    this.pop();
                    break;
                }
                case -14: {
                    this.swap();
                    break;
                }
                case -13: {
                    this.dup();
                    break;
                }
                case -12: {
                    this.concat();
                    break;
                }
                case -11: {
                    this.range(this.makeShort(code[i], code[i + 1]), this.makeShort(code[i + 2], code[i + 3]));
                    i = (short)(i + 4);
                    break;
                }
                case -10: {
                    this.xor();
                    break;
                }
                case 1: 
                case 3: {
                    this.digest(op);
                }
            }
        }
    }
}

