/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.cardsim;

import de.cardcontact.scdp.cardsim.CardSimulationException;
import de.cardcontact.scdp.cardsim.ICardSimulationAdapter;
import de.cardcontact.scdp.cardsim.ICardSimulator;
import de.cardcontact.scdp.cardsim.jcop.JCOPSimulationAdapter;
import de.cardcontact.scdp.engine.Engine;
import de.cardcontact.scdp.engine.Shell;
import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.utils.ArgChecker;
import java.io.PrintStream;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JsCardSimulationAdapter
extends ScriptableObject
implements ICardSimulator {
    private static final long serialVersionUID = 4940238054118141157L;
    public static final String clazzName = "CardSimulationAdapter";
    private ICardSimulationAdapter adapter;
    private ScriptableObject simulationObject = null;
    private Function processAPDU;
    private Function reset;
    private Function actionListener = null;

    public String getClassName() {
        return clazzName;
    }

    public String jsFunction_toString() {
        return this.adapter.toString();
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) {
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 2, 2);
        String adapterName = ArgChecker.getString((Scriptable)ctorObj, clazzName, args, 0, null);
        String parameter = ArgChecker.getString((Scriptable)ctorObj, clazzName, args, 1, null);
        JsCardSimulationAdapter t = new JsCardSimulationAdapter();
        t.adapter = null;
        if (adapterName.equals("JCOPSimulation")) {
            t.adapter = new JCOPSimulationAdapter(parameter);
            t.adapter.setCardSimulator(t);
        } else {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 23, 1, "Simulation adapter " + adapterName + " unknown");
        }
        return t;
    }

    public static void jsFunction_start(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsCardSimulationAdapter t = (JsCardSimulationAdapter)thisObj;
        if (t.simulationObject == null) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 14, 0, "No simulation object set");
        }
        t.adapter.start();
    }

    public static void jsFunction_stop(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsCardSimulationAdapter t = (JsCardSimulationAdapter)thisObj;
        t.adapter.stop();
    }

    public static void jsFunction_run(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsCardSimulationAdapter t = (JsCardSimulationAdapter)thisObj;
        t.adapter.run();
    }

    public static void jsFunction_actionListener(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        JsCardSimulationAdapter t = (JsCardSimulationAdapter)thisObj;
        if (t.actionListener != null) {
            t.actionListener.call(cx, thisObj.getParentScope(), thisObj, args);
        }
    }

    public static void jsFunction_setSimulationObject(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof ScriptableObject)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 1, "Argument must be an object");
        }
        JsCardSimulationAdapter t = (JsCardSimulationAdapter)thisObj;
        ScriptableObject so = (ScriptableObject)args[0];
        Object o = ScriptableObject.getProperty((Scriptable)so, (String)"processAPDU");
        if (o == NOT_FOUND || !(o instanceof Function)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 9, 1, "Method 'processAPDU' not found or of wrong type");
        }
        t.processAPDU = (Function)o;
        o = ScriptableObject.getProperty((Scriptable)so, (String)"reset");
        if (o == NOT_FOUND || !(o instanceof Function)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 9, 1, "Method 'reset' not found or of wrong type");
        }
        t.reset = (Function)o;
        o = ScriptableObject.getProperty((Scriptable)so, (String)"actionListener");
        t.actionListener = o != NOT_FOUND && o instanceof Function ? (Function)o : null;
        t.simulationObject = so;
    }

    private byte[] call(Context cx, Function f, Object[] param) throws CardSimulationException {
        byte[] result = new byte[]{};
        try {
            Object o = f.call(cx, this.getParentScope(), (Scriptable)this.simulationObject, param);
            if (!(o instanceof ByteString)) {
                GPError.throwAsGPErrorEx((Scriptable)this, clazzName, 16, 1, "Function must return object of type ByteString");
            }
            result = ((ByteString)((Object)o)).getBytes();
        }
        catch (RhinoException re) {
            PrintStream ps = Shell.getOutputStreamForObject(this);
            if (ps == null) {
                Engine engine = Engine.getEngine((Scriptable)this);
                ps = engine.getTracePrintStream();
            }
            Engine.printRhinoExceptionMessage(re, ps);
            throw new CardSimulationException("Simulation encountered a fatal error");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] processAPDU(byte[] capdu) throws CardSimulationException {
        Context cx = Context.enter();
        byte[] result = new byte[]{};
        try {
            Object[] param = new Object[]{ByteString.newInstance((Scriptable)this, capdu)};
            result = this.call(cx, this.processAPDU, param);
        }
        finally {
            Context.exit();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] reset(ICardSimulator.ResetType resetType) throws CardSimulationException {
        Context cx = Context.enter();
        byte[] result = new byte[]{};
        try {
            Object[] param = new Object[]{new Integer(resetType.ordinal())};
            result = this.call(cx, this.reset, param);
        }
        finally {
            Context.exit();
        }
        return result;
    }
}

