/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.engine;

import de.cardcontact.scdp.engine.Engine;
import de.cardcontact.scdp.engine.ExecuteRequest;
import de.cardcontact.scdp.engine.ScriptCompletionListener;
import de.cardcontact.scdp.engine.ScriptExecutor;
import de.cardcontact.scdp.engine.Shell;
import de.cardcontact.scdp.engine.VersionInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

public class BaseCommandProcessor
extends Thread
implements ScriptCompletionListener {
    PrintStream ostream = null;
    PrintStream estream = null;
    InputStream istream = null;
    private static final long serialVersionUID = -366457048667206297L;
    private String prompt = ">";
    public static final int RUNNING = 0;
    public static final int QUIT = 1;
    public static final int RESTART = 2;
    private int lifeCycle = 0;
    private ScriptExecutor se;
    Shell shell;

    public BaseCommandProcessor() {
        this.setName("CommandProcessor");
    }

    public void setInputStream(InputStream in) {
        this.istream = in;
    }

    public void setOutputStream(PrintStream out) {
        this.ostream = out;
        this.estream = out;
    }

    public void setErrorOutputStream(PrintStream eout) {
        this.estream = eout;
    }

    public void setScriptExecutor(ScriptExecutor se) {
        this.se = se;
    }

    public void setShellObject(Shell s) {
        this.shell = s;
    }

    public int getLifeCycle() {
        return this.lifeCycle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int process() throws IOException, InterruptedException {
        Context cx = Context.enter();
        BufferedReader in = new BufferedReader(new InputStreamReader(this.istream));
        this.ostream.print(VersionInfo.getBanner());
        this.ostream.print(this.prompt);
        this.ostream.flush();
        this.lifeCycle = 0;
        try {
            do {
                Object command = "";
                try {
                    do {
                        String line = null;
                        try {
                            line = in.readLine();
                        }
                        catch (IOException e) {
                            this.lifeCycle = 1;
                        }
                        if (line == null) {
                            this.lifeCycle = 1;
                            continue;
                        }
                        command = (String)command + line + "\n";
                    } while (this.lifeCycle != 1 && !cx.stringIsCompilableUnit((String)command));
                    this.ostream.flush();
                    if (((String)command).equalsIgnoreCase("quit\n") || ((String)command).equalsIgnoreCase("q\n")) {
                        this.lifeCycle = 1;
                        continue;
                    }
                    if (((String)command).equalsIgnoreCase("restart\n")) {
                        this.lifeCycle = 2;
                        continue;
                    }
                    if (((String)command).equals(".\n")) {
                        this.se.abort();
                        this.ostream.print("[Abort]" + this.prompt);
                        this.ostream.flush();
                        continue;
                    }
                    if (this.lifeCycle != 0) continue;
                    Script s = cx.compileString((String)command, "shell", 0, null);
                    this.se.addRequest(new ExecuteRequest(this.shell, s, null, this));
                }
                catch (RhinoException e) {
                    Engine.printRhinoExceptionMessage(e, this.estream);
                    this.ostream.print(this.prompt);
                    this.ostream.flush();
                }
            } while (this.lifeCycle == 0);
        }
        finally {
            Context.exit();
            this.ostream.println("Shell closed.");
            this.ostream.flush();
        }
        return this.lifeCycle;
    }

    @Override
    public void scriptCompleted(Object result) {
        if (result instanceof RhinoException) {
            Engine.printRhinoExceptionMessage((RhinoException)((Object)result), this.estream);
        } else if (result != Context.getUndefinedValue()) {
            this.shell.put("lastresult", (Scriptable)this.shell, result);
            this.ostream.println(Context.toString((Object)result));
        }
        this.ostream.print(this.prompt);
        this.ostream.flush();
    }

    @Override
    public void run() {
        this.lifeCycle = 0;
        try {
            this.process();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

