/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.js;

import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.js.JsKeyStore;
import de.cardcontact.scdp.utils.ArgChecker;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JsURLConnection
extends ScriptableObject {
    private static final long serialVersionUID = -8705315852635417743L;
    private URL url;
    private int responseCode = -1;
    private String responseMessage = null;
    private Certificate[] serverCertificates = null;
    private String contentEncoding = null;
    private int contentLength = -1;
    private String contentType = null;
    private long date = 0L;
    private long expiration = 0L;
    private long lastModified = 0L;
    private String serverErrorMessage = null;
    private KeyStore truststore = null;
    private KeyStore keystore = null;
    private String keypassword = null;
    private int connectTimeout = -1;
    private int readTimeout = -1;
    private Map<String, List<String>> inboundHeaderFields;
    private List<String[]> outboundHeaderList = new Vector<String[]>();
    public static final String clazzName = "URLConnection";

    public String getClassName() {
        return clazzName;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) {
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 1, 1);
        String urlString = ArgChecker.getString((Scriptable)ctorObj, clazzName, args, 0, null);
        JsURLConnection t = new JsURLConnection();
        try {
            t.url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 9, 1, "Invalid URL " + urlString + " : " + e.getMessage());
        }
        return t;
    }

    public int jsGet_responseCode() {
        return this.responseCode;
    }

    public String jsGet_responseMessage() {
        return this.responseMessage;
    }

    public Object jsGet_serverCertificates() throws CertificateEncodingException {
        if (this.serverCertificates == null) {
            return Context.getUndefinedValue();
        }
        Object[] x509list = new Object[this.serverCertificates.length];
        Context cx = Context.getCurrentContext();
        for (int i = 0; i < this.serverCertificates.length; ++i) {
            byte[] bs = this.serverCertificates[i].getEncoded();
            Object[] param = new Object[]{ByteString.newInstance((Scriptable)this, bs)};
            x509list[i] = cx.newObject((Scriptable)this, "X509", param);
        }
        return cx.newArray((Scriptable)this, x509list);
    }

    public String jsGet_contentEncoding() {
        return this.contentEncoding;
    }

    public int jsGet_contentLength() {
        return this.contentLength;
    }

    public String jsGet_contentType() {
        return this.contentType;
    }

    public Object jsGet_date() {
        if (this.date == 0L) {
            return Context.getUndefinedValue();
        }
        Context cx = Context.getCurrentContext();
        Object[] param = new Object[]{new Long(this.date)};
        Scriptable d = cx.newObject((Scriptable)this, "Date", param);
        return d;
    }

    public Object jsGet_lastModified() {
        if (this.lastModified == 0L) {
            return Context.getUndefinedValue();
        }
        Context cx = Context.getCurrentContext();
        Object[] param = new Object[]{new Long(this.lastModified)};
        Scriptable d = cx.newObject((Scriptable)this, "Date", param);
        return d;
    }

    public Object jsGet_expiration() {
        if (this.expiration == 0L) {
            return Context.getUndefinedValue();
        }
        Context cx = Context.getCurrentContext();
        Object[] param = new Object[]{new Long(this.expiration)};
        Scriptable d = cx.newObject((Scriptable)this, "Date", param);
        return d;
    }

    public String jsGet_serverErrorMessage() {
        return this.serverErrorMessage;
    }

    public URL getURL() {
        return this.url;
    }

    public URLConnection prepareConnection() throws IOException {
        URLConnection c = this.url.openConnection();
        if (this.connectTimeout != -1) {
            c.setConnectTimeout(this.connectTimeout);
        }
        if (this.readTimeout != -1) {
            c.setReadTimeout(this.readTimeout);
        }
        for (String[] field : this.outboundHeaderList) {
            c.addRequestProperty(field[0], field[1]);
        }
        if (c instanceof HttpsURLConnection && (this.truststore != null || this.keystore != null)) {
            HttpsURLConnection sslc = (HttpsURLConnection)c;
            try {
                SSLContext ctx = SSLContext.getInstance("TLS");
                KeyManager[] km = null;
                TrustManager[] tm = null;
                if (this.truststore != null) {
                    TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                    tmf.init(this.truststore);
                    tm = tmf.getTrustManagers();
                }
                if (this.keystore != null) {
                    KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                    kmf.init(this.keystore, this.keypassword.toCharArray());
                    km = kmf.getKeyManagers();
                }
                ctx.init(km, tm, null);
                sslc.setSSLSocketFactory(ctx.getSocketFactory());
            }
            catch (NoSuchAlgorithmException nsae) {
                GPError.throwAsGPErrorEx((Scriptable)this, clazzName, 7, 1, "Invalid algorithm for TLS : " + nsae.getMessage());
            }
            catch (KeyManagementException kme) {
                GPError.throwAsGPErrorEx((Scriptable)this, clazzName, 7, 1, "Error in key management for TLS : " + kme.getMessage());
            }
            catch (KeyStoreException kse) {
                GPError.throwAsGPErrorEx((Scriptable)this, clazzName, 7, 1, "Error in key store for TLS : " + kse.getMessage());
            }
            catch (UnrecoverableKeyException uke) {
                GPError.throwAsGPErrorEx((Scriptable)this, clazzName, 7, 1, "Error recovering private key for TLS : " + uke.getMessage());
            }
        }
        return c;
    }

    private URLConnection open() throws IOException {
        URLConnection c = this.prepareConnection();
        if (c instanceof HttpURLConnection) {
            HttpURLConnection hc = (HttpURLConnection)c;
            hc.setInstanceFollowRedirects(false);
        }
        return c;
    }

    private void extractHttpInfos(HttpURLConnection c) throws IOException {
        this.responseCode = c.getResponseCode();
        this.responseMessage = c.getResponseMessage();
    }

    private void extractConnectionInfos(URLConnection c) throws IOException {
        this.contentEncoding = c.getContentEncoding();
        this.contentLength = c.getContentLength();
        this.contentType = c.getContentType();
        this.date = c.getDate();
        this.expiration = c.getExpiration();
        this.lastModified = c.getLastModified();
        this.inboundHeaderFields = c.getHeaderFields();
    }

    private void readServerErrorMessage(URLConnection connection) {
        this.serverErrorMessage = null;
        if (connection != null && connection instanceof HttpURLConnection) {
            HttpURLConnection c = (HttpURLConnection)connection;
            try {
                InputStream is = c.getErrorStream();
                if (is != null) {
                    this.serverErrorMessage = JsURLConnection.getAsString(is);
                }
                this.extractHttpInfos(c);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static String getAsString(InputStream is) throws IOException {
        String line;
        StringBuffer str = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        while ((line = reader.readLine()) != null) {
            str.append(line);
            str.append('\n');
        }
        return str.toString();
    }

    private String getAsString() {
        String result = null;
        URLConnection connection = null;
        try {
            connection = this.open();
            connection.connect();
            if (connection instanceof HttpsURLConnection) {
                HttpsURLConnection sc = (HttpsURLConnection)connection;
                this.serverCertificates = sc.getServerCertificates();
            }
            InputStream is = connection.getInputStream();
            result = JsURLConnection.getAsString(is);
            is.close();
            this.extractConnectionInfos(connection);
            if (connection instanceof HttpURLConnection) {
                this.extractHttpInfos((HttpURLConnection)connection);
            }
        }
        catch (IOException e) {
            this.readServerErrorMessage(connection);
            GPError.throwAsGPErrorEx((Scriptable)this, clazzName, 7, this.responseCode, "Error reading resource : " + String.valueOf(e));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getAsByteArray() {
        ByteArrayOutputStream tmpOutputBufferStream = null;
        URLConnection connection = null;
        InputStream in = null;
        try {
            int len;
            connection = this.open();
            connection.connect();
            if (connection instanceof HttpsURLConnection) {
                HttpsURLConnection sc = (HttpsURLConnection)connection;
                this.serverCertificates = sc.getServerCertificates();
            }
            int contentLength = connection.getContentLength();
            in = connection.getInputStream();
            byte[] readBuffer = new byte[8192];
            tmpOutputBufferStream = new ByteArrayOutputStream();
            while ((len = in.read(readBuffer)) != -1) {
                tmpOutputBufferStream.write(readBuffer, 0, len);
            }
            tmpOutputBufferStream.close();
            if (contentLength >= 0 && tmpOutputBufferStream.size() != contentLength) {
                GPError.throwAsGPErrorEx((Scriptable)this, clazzName, 7, 1, "Error reading resource : content-length (" + contentLength + ") does not match actual read buffer size (" + tmpOutputBufferStream.size() + ")");
            }
        }
        catch (IOException e) {
            this.readServerErrorMessage(connection);
            GPError.throwAsGPErrorEx((Scriptable)this, clazzName, 7, 1, "Error reading resource : " + e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return tmpOutputBufferStream.toByteArray();
    }

    private String post(String str) {
        String result = null;
        URLConnection connection = null;
        try {
            connection = this.open();
            connection.setDoOutput(true);
            connection.connect();
            if (connection instanceof HttpsURLConnection) {
                HttpsURLConnection sc = (HttpsURLConnection)connection;
                this.serverCertificates = sc.getServerCertificates();
            }
            OutputStream os = connection.getOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter(os);
            osw.write(str);
            osw.close();
            InputStream is = connection.getInputStream();
            result = JsURLConnection.getAsString(is);
            is.close();
            this.extractConnectionInfos(connection);
            if (connection instanceof HttpURLConnection) {
                this.extractHttpInfos((HttpURLConnection)connection);
            }
        }
        catch (IOException e) {
            this.readServerErrorMessage(connection);
            GPError.throwAsGPErrorEx((Scriptable)this, clazzName, 7, this.responseCode, "Error writing resource : " + e.getMessage());
        }
        return result;
    }

    private byte[] post(byte[] data) {
        URLConnection connection = null;
        ByteArrayOutputStream tmpOutputBufferStream = null;
        try {
            int len;
            connection = this.open();
            connection.setDoOutput(true);
            connection.connect();
            if (connection instanceof HttpsURLConnection) {
                HttpsURLConnection sc = (HttpsURLConnection)connection;
                this.serverCertificates = sc.getServerCertificates();
            }
            OutputStream os = connection.getOutputStream();
            os.write(data);
            os.close();
            int contentLength = connection.getContentLength();
            InputStream in = connection.getInputStream();
            byte[] readBuffer = new byte[8192];
            tmpOutputBufferStream = new ByteArrayOutputStream();
            while ((len = in.read(readBuffer)) != -1) {
                tmpOutputBufferStream.write(readBuffer, 0, len);
            }
            tmpOutputBufferStream.close();
            if (contentLength >= 0 && tmpOutputBufferStream.size() != contentLength) {
                GPError.throwAsGPErrorEx((Scriptable)this, clazzName, 7, 1, "Error reading resource : content-length (" + contentLength + ") does not match actual read buffer size (" + tmpOutputBufferStream.size() + ")");
            }
            this.extractConnectionInfos(connection);
            if (connection instanceof HttpURLConnection) {
                this.extractHttpInfos((HttpURLConnection)connection);
            }
        }
        catch (IOException e) {
            this.readServerErrorMessage(connection);
            GPError.throwAsGPErrorEx((Scriptable)this, clazzName, 7, this.responseCode, "Error writing resource : " + e.getMessage());
        }
        return tmpOutputBufferStream.toByteArray();
    }

    private void delete() {
        URLConnection connection = null;
        try {
            connection = this.open();
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection c = (HttpURLConnection)connection;
                c.setRequestMethod("DELETE");
            } else {
                GPError.throwAsGPErrorEx((Scriptable)this, clazzName, 14, 1, "Delete operation only available for HTTP connections");
            }
            this.extractConnectionInfos(connection);
            if (connection instanceof HttpURLConnection) {
                this.extractHttpInfos((HttpURLConnection)connection);
            }
        }
        catch (IOException e) {
            this.readServerErrorMessage(connection);
            GPError.throwAsGPErrorEx((Scriptable)this, clazzName, 7, this.responseCode, "Error deleting resource : " + e.getMessage());
        }
    }

    private void put(String str) {
        try {
            URLConnection connection = this.open();
            if (connection instanceof HttpURLConnection) {
                HttpURLConnection c = (HttpURLConnection)connection;
                c.setRequestMethod("PUT");
            }
            connection.setDoOutput(true);
            OutputStream os = connection.getOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter(os);
            osw.write(str);
            osw.close();
            this.extractConnectionInfos(connection);
            if (connection instanceof HttpURLConnection) {
                this.extractHttpInfos((HttpURLConnection)connection);
            }
        }
        catch (IOException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, clazzName, 7, this.responseCode, "Error putting resource : " + e.getMessage());
        }
    }

    public static String jsFunction_get(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsURLConnection t = (JsURLConnection)thisObj;
        return t.getAsString();
    }

    public static ByteString jsFunction_getBinary(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsURLConnection t = (JsURLConnection)thisObj;
        byte[] data = t.getAsByteArray();
        return ByteString.newInstance(thisObj, data);
    }

    public static ByteString jsFunction_getAsByteString(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        return JsURLConnection.jsFunction_getBinary(cx, thisObj, args, funObj);
    }

    public static void jsFunction_put(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        JsURLConnection t = (JsURLConnection)thisObj;
        String str = Context.toString((Object)args[0]);
        t.put(str);
    }

    public static String jsFunction_post(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        JsURLConnection t = (JsURLConnection)thisObj;
        String str = Context.toString((Object)args[0]);
        return t.post(str);
    }

    public static ByteString jsFunction_postBinary(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 1, "Argument must be of type ByteString");
        }
        JsURLConnection t = (JsURLConnection)thisObj;
        return ByteString.newInstance(thisObj, t.post(((ByteString)((Object)args[0])).getBytes()));
    }

    public static void jsFunction_deleteResource(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsURLConnection t = (JsURLConnection)thisObj;
        t.delete();
    }

    public static void jsFunction_setTLSKeyStores(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 3);
        if (!(args[0] instanceof JsKeyStore)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 1, "Argument must be of type KeyStore");
        }
        JsKeyStore jstruststore = (JsKeyStore)((Object)args[0]);
        JsKeyStore jskeystore = null;
        String keypassword = null;
        if (args.length > 1) {
            if (!(args[1] instanceof JsKeyStore)) {
                GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 2, "Argument must be of type KeyStore");
            }
            jskeystore = (JsKeyStore)((Object)args[1]);
            keypassword = ArgChecker.getString(thisObj, clazzName, args, 2, null);
        }
        JsURLConnection t = (JsURLConnection)thisObj;
        t.truststore = jstruststore.jsGet_native();
        if (jskeystore != null) {
            t.keystore = jskeystore.jsGet_native();
            t.keypassword = keypassword;
        }
    }

    public static void jsFunction_setConnectTimeout(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        JsURLConnection t = (JsURLConnection)thisObj;
        t.connectTimeout = ArgChecker.getInt(thisObj, clazzName, args, 0, -1);
    }

    public static void jsFunction_setReadTimeout(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        JsURLConnection t = (JsURLConnection)thisObj;
        t.readTimeout = ArgChecker.getInt(thisObj, clazzName, args, 0, -1);
    }

    public static void jsFunction_addHeaderField(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        JsURLConnection t = (JsURLConnection)thisObj;
        String fieldName = ArgChecker.getString(thisObj, clazzName, args, 0, null);
        String value = ArgChecker.getString(thisObj, clazzName, args, 1, null);
        t.outboundHeaderList.add(new String[]{fieldName, value});
    }

    public static Object jsFunction_getHeaderField(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        List<String> fieldValues;
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        JsURLConnection t = (JsURLConnection)thisObj;
        String fieldName = null;
        if (args[0] != null) {
            fieldName = ArgChecker.getString(thisObj, clazzName, args, 0, null);
        }
        if ((fieldValues = t.inboundHeaderFields.get(fieldName)) == null) {
            return Context.getUndefinedValue();
        }
        return cx.newArray(thisObj, fieldValues.toArray());
    }

    public static Scriptable jsFunction_getHeaderFieldList(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsURLConnection t = (JsURLConnection)thisObj;
        return cx.newArray(thisObj, t.inboundHeaderFields.keySet().toArray());
    }

    public String jsFunction_toString() {
        return this.url.toString();
    }
}

