/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.gp;

import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.utils.ArgChecker;
import de.cardcontact.scdp.utils.Base64;
import de.cardcontact.scdp.utils.ByteBuffer;
import de.cardcontact.tlv.HexString;
import de.cardcontact.tlv.ObjectIdentifier;
import de.cardcontact.tlv.ObjectIdentifierRegistry;
import de.cardcontact.tlv.TLV;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Arrays;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Wrapper;

public class ByteString
extends ScriptableObject
implements Wrapper {
    private static final long serialVersionUID = -6854015159610389347L;
    public static final int HEX = 16;
    public static final int UTF8 = 2;
    public static final int ASCII = 3;
    public static final int BASE64 = 4;
    public static final int CN = 5;
    public static final int OID = 6;
    public static final String[] encodingList = new String[]{"HEX", "UTF8", "ASCII", "BASE64", "CN", "OID"};
    public static final int[] encodingMap = new int[]{16, 2, 3, 4, 5, 6};
    public static final int XOR = 1;
    public static final int OR = 2;
    public static final int AND = 3;
    static final String clazzName = "ByteString";
    byte[] bs = null;

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (!inNewExpr) {
            Context.reportError((String)"ByteString() can not be called as function");
        }
        ByteString t = new ByteString();
        t.defineProperty("clazz", ((Object)((Object)t)).getClass(), 0);
        t.defineProperty("value", ((Object)((Object)t)).getClass(), 0);
        if (args[0] instanceof byte[]) {
            t.bs = (byte[])args[0];
        } else {
            ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 2, 2);
            int encoding = ArgChecker.getInt((Scriptable)ctorObj, clazzName, args, 1, 0);
            String str = Context.toString((Object)args[0]);
            switch (encoding) {
                case 16: {
                    try {
                        t.bs = HexString.parseHexString((String)str);
                    }
                    catch (NumberFormatException e) {
                        GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 9, 0, "String contains invalid hexadecimal data: " + e.getMessage());
                    }
                    break;
                }
                case 2: {
                    try {
                        t.bs = str.getBytes("UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 9, 0, "String contains invalid UTF-8 characters");
                    }
                    break;
                }
                case 3: {
                    try {
                        t.bs = str.getBytes("8859_1");
                    }
                    catch (UnsupportedEncodingException e) {
                        GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 9, 0, "String contains invalid Latin-1 characters");
                    }
                    break;
                }
                case 4: {
                    try {
                        t.bs = Base64.decode(str);
                    }
                    catch (UnsupportedEncodingException e) {
                        GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 9, 0, "String contains invalid Base64 characters");
                    }
                    break;
                }
                case 5: {
                    Context.reportError((String)"ByteString.CN not yet implemented");
                    break;
                }
                case 6: {
                    try {
                        t.bs = ObjectIdentifierRegistry.parseObjectIdentifier((String)str);
                    }
                    catch (IllegalArgumentException e) {
                        GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 9, 0, "String contains invalid object identifier : " + e.getMessage());
                    }
                    break;
                }
                default: {
                    GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 10, 0, "Invalid encoding type");
                }
            }
        }
        return t;
    }

    public static void finishInit(Scriptable scope, FunctionObject ctor, Scriptable proto) {
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"XOR", (Object)new Integer(1), (int)0);
    }

    public static ByteString newInstance(Scriptable scope, byte[] bytes) {
        Object[] params = new Object[]{bytes};
        Context cx = Context.getCurrentContext();
        return (ByteString)cx.newObject(scope, clazzName, params);
    }

    public static ByteString newInstance(Scriptable scope, String data, int encoding) {
        Object[] params = new Object[]{data, new Integer(encoding)};
        Context cx = Context.getCurrentContext();
        return (ByteString)cx.newObject(scope, clazzName, params);
    }

    public String getClassName() {
        return clazzName;
    }

    public int jsGet_length() {
        return this.bs.length;
    }

    public String getClazz() {
        return clazzName;
    }

    public String getValue() {
        return HexString.hexifyByteArray((byte[])this.bs);
    }

    public static ByteString jsStaticFunction_fromJSON(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Scriptable o;
        Object p;
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof Scriptable)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "Argument must be an object");
        }
        if ((p = (o = (Scriptable)args[0]).get("clazz", o)) == null || !Context.toString((Object)p).equals(clazzName)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "JSON object does not contain property clazz with content ByteString");
        }
        if ((p = o.get("value", o)) == null) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "JSON object does not contain property value");
        }
        byte[] bs = HexString.parseHexString((String)Context.toString((Object)p));
        return ByteString.newInstance(thisObj, bs);
    }

    public byte[] getBytes() {
        return this.bs;
    }

    public Object unwrap() {
        return this.bs;
    }

    static Scriptable bitwiseOperation(Context cx, Scriptable thisObj, Object[] args, int op) {
        byte[] o;
        byte[] a;
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "Argument is not of class ByteString");
        }
        if ((a = ((ByteString)((Object)args[0])).bs).length != (o = ((ByteString)thisObj).bs).length) {
            GPError.throwAsGPErrorEx(thisObj, 13, a.length, "Object and argument have different length");
        }
        byte[] result = new byte[o.length];
        switch (op) {
            case 2: {
                for (int i = 0; i < result.length; ++i) {
                    result[i] = (byte)(o[i] | a[i]);
                }
                break;
            }
            case 3: {
                for (int i = 0; i < result.length; ++i) {
                    result[i] = (byte)(o[i] & a[i]);
                }
                break;
            }
            case 1: {
                for (int i = 0; i < result.length; ++i) {
                    result[i] = (byte)(o[i] ^ a[i]);
                }
                break;
            }
        }
        return ByteString.newInstance(thisObj, result);
    }

    public static Scriptable jsFunction_and(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        return ByteString.bitwiseOperation(cx, thisObj, args, 3);
    }

    public static Scriptable jsFunction_or(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        return ByteString.bitwiseOperation(cx, thisObj, args, 2);
    }

    public static Scriptable jsFunction_xor(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        return ByteString.bitwiseOperation(cx, thisObj, args, 1);
    }

    public static double jsFunction_byteAt(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int offset = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        byte[] o = ((ByteString)thisObj).bs;
        if (offset < 0 || offset >= o.length) {
            GPError.throwAsGPErrorEx(thisObj, 11, offset, "Offset for byteAt() out of range");
        }
        return o[offset] & 0xFF;
    }

    public static Scriptable jsFunction_bytes(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        byte[] b = ((ByteString)thisObj).bs;
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 2);
        int offset = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        int count = ArgChecker.getInt(thisObj, clazzName, args, 1, b.length - offset);
        if (offset < 0 || offset > b.length) {
            GPError.throwAsGPErrorEx(thisObj, 11, offset, "Offset for bytes() out of range");
        }
        if (count < 0 || offset + count > b.length) {
            GPError.throwAsGPErrorEx(thisObj, 13, count, "Count for bytes() out of range");
        }
        byte[] result = new byte[count];
        System.arraycopy(b, offset, result, 0, count);
        return ByteString.newInstance(thisObj, result);
    }

    public static ByteString jsFunction_concat(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "Argument for concat() must be ByteString");
        }
        byte[] b = ((ByteString)thisObj).bs;
        byte[] v = ((ByteString)((Object)args[0])).bs;
        byte[] result = new byte[b.length + v.length];
        System.arraycopy(b, 0, result, 0, b.length);
        System.arraycopy(v, 0, result, b.length, v.length);
        return ByteString.newInstance(thisObj, result);
    }

    public static Scriptable jsFunction_crc(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int method = ArgChecker.getInt(thisObj, clazzName, args, 0, -1);
        byte[] b = ((ByteString)thisObj).bs;
        byte[] result = null;
        switch (method) {
            case 1: {
                byte lrc = 0;
                for (int i = 0; i < b.length; ++i) {
                    lrc = (byte)(lrc ^ b[i]);
                }
                result = new byte[]{lrc};
                break;
            }
            default: {
                GPError.throwAsGPErrorEx(thisObj, 14, method, "Invalid mechanism specified for crc()");
            }
        }
        return ByteString.newInstance(thisObj, result);
    }

    public static boolean jsFunction_equals(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "Argument for equals() must be ByteString");
        }
        byte[] b = ((ByteString)thisObj).bs;
        byte[] v = ((ByteString)((Object)args[0])).bs;
        return Arrays.equals(b, v);
    }

    public static double jsFunction_find(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 2);
        if (!(args[0] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "First argument for find() must be ByteString");
        }
        int offset = ArgChecker.getInt(thisObj, clazzName, args, 1, 0);
        byte[] b = ((ByteString)thisObj).bs;
        byte[] v = ((ByteString)((Object)args[0])).bs;
        if (offset < 0) {
            offset = 0;
        }
        if (offset > b.length) {
            GPError.throwAsGPErrorEx(thisObj, 11, offset, "Offset for find() out of range");
        }
        return ByteBuffer.find(b, v, offset);
    }

    public static ByteString jsFunction_getL(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        byte[] b = ((ByteString)thisObj).bs;
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int mech = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        byte[] result = null;
        if (mech == 1) {
            result = TLV.getLengthFieldAsByteArray((int)b.length, (boolean)false);
        } else if (mech == 2) {
            if (b.length > 65535) {
                GPError.throwAsGPErrorEx(thisObj, 13, b.length, "Length must not exceed 65535 for DGI encoding");
            }
            result = TLV.getLengthFieldAsByteArray((int)b.length, (boolean)true);
        } else {
            GPError.throwAsGPErrorEx(thisObj, 14, mech, "Invalid mechanism");
        }
        return ByteString.newInstance(thisObj, result);
    }

    public static ByteString jsFunction_getLV(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ByteString b = ByteString.jsFunction_getL(cx, thisObj, args, funObj);
        Object[] param = new Object[]{thisObj};
        return ByteString.jsFunction_concat(cx, (Scriptable)b, param, funObj);
    }

    public static Scriptable jsFunction_left(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        byte[] b = ((ByteString)thisObj).bs;
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int count = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        if (count > b.length) {
            count = b.length;
        }
        if (count < 0) {
            GPError.throwAsGPErrorEx(thisObj, 13, count, "Count for left() out of range");
        }
        byte[] result = new byte[count];
        System.arraycopy(b, 0, result, 0, count);
        return ByteString.newInstance(thisObj, result);
    }

    public static Scriptable jsFunction_neg(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        byte[] b = ((ByteString)thisObj).bs;
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 1);
        int count = ArgChecker.getInt(thisObj, clazzName, args, 0, b.length);
        if (count < b.length) {
            GPError.throwAsGPErrorEx(thisObj, 13, count, "Argument for neg() smaller than ByteString");
        }
        byte[] result = new byte[count];
        System.arraycopy(b, 0, result, count - b.length, b.length);
        int carry = 1;
        for (int i = result.length - 1; i >= 0; --i) {
            result[i] = (byte)(~result[i] + carry);
            carry = result[i] == 0 ? 1 : 0;
        }
        return ByteString.newInstance(thisObj, result);
    }

    public static Scriptable jsFunction_not(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        byte[] b = ((ByteString)thisObj).bs;
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        byte[] result = new byte[b.length];
        System.arraycopy(b, 0, result, 0, b.length);
        for (int i = result.length - 1; i >= 0; --i) {
            result[i] = ~result[i];
        }
        return ByteString.newInstance(thisObj, result);
    }

    public static Scriptable jsFunction_pad(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        byte[] b = ((ByteString)thisObj).bs;
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 2);
        int mech = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        boolean optional = ArgChecker.getBoolean(thisObj, clazzName, args, 1, false);
        if (mech != 11 && mech != 12 && mech != 58 && mech != 59) {
            GPError.throwAsGPErrorEx(thisObj, 14, mech, "Invalid padding method");
        }
        int blksize = 8;
        if (mech == 58 || mech == 59) {
            blksize = 16;
        }
        if (optional && (b.length & blksize - 1) == 0) {
            return thisObj;
        }
        byte[] result = new byte[(b.length & ~(blksize - 1)) + blksize];
        System.arraycopy(b, 0, result, 0, b.length);
        if (mech == 12 || mech == 59) {
            result[b.length] = -128;
        }
        return ByteString.newInstance(thisObj, result);
    }

    public static Scriptable jsFunction_right(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        byte[] b = ((ByteString)thisObj).bs;
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int count = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        if (count > b.length) {
            count = b.length;
        }
        if (count < 0) {
            GPError.throwAsGPErrorEx(thisObj, 13, count, "Count for right() out of range");
        }
        byte[] result = new byte[count];
        System.arraycopy(b, b.length - count, result, 0, count);
        return ByteString.newInstance(thisObj, result);
    }

    public static double jsFunction_startsWith(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        int i;
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "Argument for startsWith() must be ByteString");
        }
        byte[] b = ((ByteString)thisObj).bs;
        byte[] v = ((ByteString)((Object)args[0])).bs;
        for (i = 0; i < b.length && i < v.length && b[i] == v[i]; ++i) {
        }
        return i;
    }

    public static ByteString jsFunction_toBase64(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        byte[] b = ((ByteString)thisObj).bs;
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 1);
        boolean linebreak = ArgChecker.getBoolean(thisObj, clazzName, args, 0, false);
        String str = Base64.encode(b, linebreak);
        byte[] result = null;
        try {
            result = str.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return ByteString.newInstance(thisObj, result);
    }

    public static Scriptable jsFunction_toBcd(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 1);
        byte[] b = ((ByteString)thisObj).bs;
        long akku = 0L;
        for (int i = 0; i < b.length; ++i) {
            akku = akku << 8 | (long)(b[i] & 0xFF);
        }
        String str = Long.toString(akku);
        int count = str.length();
        count = count + (count & 1) >> 1;
        if ((count = ArgChecker.getInt(thisObj, clazzName, args, 0, count)) < 0) {
            GPError.throwAsGPErrorEx(thisObj, 13, count, "Argument for toBcd() is negative");
        }
        byte[] result = new byte[count];
        int j = str.length() - 1;
        for (int i = count - 1; i >= 0 && j >= 0; --i, --j) {
            int n = i;
            result[n] = (byte)(result[n] | str.charAt(j) - 48);
            if (j <= 0) continue;
            int n2 = i;
            result[n2] = (byte)(result[n2] | str.charAt(--j) - 48 << 4);
        }
        return ByteString.newInstance(thisObj, result);
    }

    public static Scriptable jsFunction_toHex(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        int i;
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 1);
        byte[] b = ((ByteString)thisObj).bs;
        int count = ArgChecker.getInt(thisObj, clazzName, args, 0, b.length << 1);
        if (count < 0) {
            GPError.throwAsGPErrorEx(thisObj, 13, count, "Argument for toHex() is negative");
        }
        byte[] result = new byte[count];
        int j = b.length - 1;
        for (i = count - 1; i >= 0 && j >= 0; --i, --j) {
            result[i] = (byte)(48 + (b[j] & 0xF));
            if (i <= 0) continue;
            result[--i] = (byte)(48 + (b[j] >> 4 & 0xF));
        }
        while (i >= 0) {
            result[i] = 48;
            --i;
        }
        return ByteString.newInstance(thisObj, result);
    }

    public static double jsFunction_toSigned(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 1);
        boolean littleEndian = ArgChecker.getBoolean(thisObj, clazzName, args, 0, false);
        byte[] b = ((ByteString)thisObj).bs;
        int akku = 0;
        int lastakku = 0;
        if (littleEndian) {
            if (b.length > 0 && b[b.length - 1] < 0) {
                akku = -1;
            }
            for (int i = b.length - 1; i >= 0; --i) {
                lastakku = akku;
                akku <<= 8;
                if (lastakku == (akku |= b[i] & 0xFF) || i <= 3) continue;
                GPError.throwAsGPErrorEx(thisObj, 6, b.length, "Data does not fit into 32 bits");
            }
        } else {
            if (b.length > 0 && b[0] < 0) {
                akku = -1;
            }
            for (int i = 0; i < b.length; ++i) {
                lastakku = akku;
                akku <<= 8;
                if (lastakku == (akku |= b[i] & 0xFF) || b.length - i <= 4) continue;
                GPError.throwAsGPErrorEx(thisObj, 6, b.length, "Data does not fit into 32 bits");
            }
        }
        return akku;
    }

    public static double jsFunction_toUnsigned(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 1);
        boolean littleEndian = ArgChecker.getBoolean(thisObj, clazzName, args, 0, false);
        byte[] b = ((ByteString)thisObj).bs;
        long akku = 0L;
        long lastakku = 0L;
        if (littleEndian) {
            for (int i = b.length - 1; i >= 0; --i) {
                lastakku = akku;
                akku <<= 8;
                if ((akku |= (long)(b[i] & 0xFF)) >= 0L && (lastakku == akku || i <= 7)) continue;
                GPError.throwAsGPErrorEx(thisObj, 6, b.length, "Data does not fit into 64 bits");
            }
        } else {
            for (int i = 0; i < b.length; ++i) {
                lastakku = akku;
                akku <<= 8;
                if ((akku |= (long)(b[i] & 0xFF)) >= 0L && (lastakku == akku || b.length - i <= 8)) continue;
                GPError.throwAsGPErrorEx(thisObj, 6, b.length, "Data does not fit into 64 bits");
            }
        }
        return akku;
    }

    public static Scriptable jsFunction_asSigned(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        byte[] res;
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        byte[] b = ((ByteString)thisObj).bs;
        if ((b[0] & 0x80) > 0) {
            res = new byte[b.length + 1];
            System.arraycopy(b, 0, res, 1, b.length);
        } else {
            res = b;
        }
        return ByteString.newInstance(thisObj, res);
    }

    public static Scriptable jsFunction_asUnsigned(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        int i;
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 1);
        int length = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        byte[] b = ((ByteString)thisObj).bs;
        if (length == b.length) {
            return ByteString.newInstance(thisObj, b);
        }
        if (length > b.length) {
            byte[] res = new byte[length];
            System.arraycopy(b, 0, res, length - b.length, b.length);
            return ByteString.newInstance(thisObj, res);
        }
        if ((b[0] & 0xFF) > 0) {
            return ByteString.newInstance(thisObj, b);
        }
        int size = length > 0 ? length : b.length;
        for (i = size; i > 0 && b[b.length - i] == 0; --i) {
        }
        if (b[b.length - i - 1] != 0) {
            GPError.throwAsGPErrorEx(thisObj, 6, b.length, "Data does not fit into " + length + " bytes");
        }
        if (i == 0) {
            i = 1;
        }
        if (length == 0) {
            size = i;
        }
        byte[] res = new byte[size];
        System.arraycopy(b, b.length - i, res, size - i, i);
        return ByteString.newInstance(thisObj, res);
    }

    public static Scriptable jsFunction_add(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        int length;
        int rofs;
        int riofs;
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int value = ArgChecker.getInt(thisObj, clazzName, args, 0, -1);
        byte[] bs = ((ByteString)thisObj).bs;
        BigInteger b = new BigInteger(1, bs);
        BigInteger v = BigInteger.valueOf(value);
        b = b.add(v);
        byte[] r = new byte[bs.length];
        byte[] ri = b.toByteArray();
        if (ri.length > r.length) {
            riofs = ri.length - r.length;
            rofs = 0;
            length = r.length;
        } else {
            riofs = 0;
            rofs = r.length - ri.length;
            length = ri.length;
        }
        System.arraycopy(ri, riofs, r, rofs, length);
        return ByteString.newInstance(thisObj, r);
    }

    public static Scriptable jsFunction_biAdd(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 0, "Argument is not of class ByteString");
        }
        byte[] bs = ((ByteString)thisObj).bs;
        BigInteger v = new BigInteger(((ByteString)((Object)args[0])).bs);
        BigInteger b = new BigInteger(bs);
        b = b.add(v);
        return ByteString.newInstance(thisObj, b.toByteArray());
    }

    public static Scriptable jsFunction_sub(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 0, "Argument is not of class ByteString");
        }
        BigInteger v = new BigInteger(((ByteString)((Object)args[0])).bs);
        byte[] bs = ((ByteString)thisObj).bs;
        BigInteger b = new BigInteger(bs);
        b = b.subtract(v);
        return ByteString.newInstance(thisObj, b.toByteArray());
    }

    public static Scriptable jsFunction_mod(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 0, "Argument is not of class ByteString");
        }
        BigInteger v = new BigInteger(1, ((ByteString)((Object)args[0])).bs);
        byte[] bs = ((ByteString)thisObj).bs;
        BigInteger b = new BigInteger(bs);
        b = b.mod(v);
        return ByteString.newInstance(thisObj, b.toByteArray());
    }

    public static Scriptable jsFunction_modInverse(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 0, "Argument is not of class ByteString");
        }
        BigInteger v = new BigInteger(1, ((ByteString)((Object)args[0])).bs);
        byte[] bs = ((ByteString)thisObj).bs;
        BigInteger b = new BigInteger(bs);
        b = b.modInverse(v);
        return ByteString.newInstance(thisObj, b.toByteArray());
    }

    public static Scriptable jsFunction_modPow(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        if (!(args[0] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 0, "Argument is not of class ByteString");
        }
        if (!(args[1] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "Argument is not of class ByteString");
        }
        BigInteger exp = new BigInteger(((ByteString)((Object)args[0])).bs);
        BigInteger mod = new BigInteger(1, ((ByteString)((Object)args[1])).bs);
        byte[] bs = ((ByteString)thisObj).bs;
        BigInteger b = new BigInteger(bs);
        b = b.modPow(exp, mod);
        return ByteString.newInstance(thisObj, b.toByteArray());
    }

    public static Scriptable jsFunction_multiply(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 0, "Argument is not of class ByteString");
        }
        BigInteger v = new BigInteger(((ByteString)((Object)args[0])).bs);
        byte[] bs = ((ByteString)thisObj).bs;
        BigInteger b = new BigInteger(bs);
        b = b.multiply(v);
        return ByteString.newInstance(thisObj, b.toByteArray());
    }

    public static Scriptable jsFunction_divide(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 0, "Argument is not of class ByteString");
        }
        BigInteger v = new BigInteger(((ByteString)((Object)args[0])).bs);
        byte[] bs = ((ByteString)thisObj).bs;
        BigInteger b = new BigInteger(bs);
        b = b.divide(v);
        return ByteString.newInstance(thisObj, b.toByteArray());
    }

    public static ByteString jsStaticFunction_valueOf(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        int i;
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 2);
        long value = ArgChecker.getLong(thisObj, clazzName, args, 0, 0L);
        int len = ArgChecker.getInt(thisObj, clazzName, args, 1, 0);
        byte[] r = new byte[len > 0 ? len : 8];
        if (value == 0L) {
            --i;
        } else {
            for (i = r.length - 1; value != 0L && i >= 0; value >>= 8, --i) {
                r[i] = (byte)(value & 0xFFL);
            }
        }
        if (len <= 0) {
            int ln = r.length - ++i;
            byte[] r2 = new byte[ln];
            System.arraycopy(r, i, r2, 0, ln);
            r = r2;
        }
        return ByteString.newInstance(thisObj, r);
    }

    public String jsFunction_toString(int encoding) {
        String response = null;
        switch (encoding) {
            case -1: {
                response = HexString.dump((byte[])this.bs);
                break;
            }
            case 0: {
                response = HexString.hexifyByteArray((byte[])this.bs, (char)' ');
                break;
            }
            case 16: {
                response = HexString.hexifyByteArray((byte[])this.bs);
                break;
            }
            case 2: {
                try {
                    response = new String(this.bs, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "ByteString contains invalid UTF-8 characters");
                }
                break;
            }
            case 3: {
                try {
                    response = new String(this.bs, "8859_1");
                }
                catch (UnsupportedEncodingException e) {
                    GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "ByteString contains invalid UTF-8 characters");
                }
                break;
            }
            case 4: {
                response = Base64.encode(this.bs, false);
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                response = ObjectIdentifier.getObjectIdentifierAsString((int[])ObjectIdentifier.convertBytesToOID((byte[])this.bs));
                break;
            }
            default: {
                GPError.throwAsGPErrorEx((Scriptable)this, 10, 0, "Invalid encoding type");
            }
        }
        return response;
    }

    public void jsFunction_clear() {
        Arrays.fill(this.bs, (byte)0);
    }

    public String toString() {
        return HexString.hexifyByteArray((byte[])this.bs);
    }
}

