/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.engine;

import de.cardcontact.scdp.js.GPTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GPTracerSLFAdapter
implements GPTracer {
    private StringBuffer traceCopy = null;
    private int traceCopyCapacity = 0;

    public GPTracerSLFAdapter(int capacity) {
        this.traceCopyCapacity = capacity;
    }

    @Override
    public boolean isTraceEnabled(String source, GPTracer.LogLevel loglevel) {
        Logger logger = LoggerFactory.getLogger((String)source);
        switch (loglevel) {
            case DEBUG: {
                return logger.isDebugEnabled();
            }
            case INFO: {
                return logger.isInfoEnabled();
            }
            case WARN: {
                return logger.isWarnEnabled();
            }
            case ERROR: 
            case FATAL: {
                return logger.isErrorEnabled();
            }
        }
        return false;
    }

    @Override
    public void setTraceLevel(String source, GPTracer.LogLevel logLevel) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean trace(String source, GPTracer.LogLevel loglevel, Object obj) {
        Logger logger = LoggerFactory.getLogger((String)source);
        switch (loglevel) {
            case DEBUG: {
                if (!logger.isDebugEnabled()) {
                    return false;
                }
                if (obj instanceof Throwable) {
                    logger.debug("Java exception", (Throwable)obj);
                    break;
                }
                logger.debug(obj.toString());
                break;
            }
            case INFO: {
                if (!logger.isInfoEnabled()) {
                    return false;
                }
                if (obj instanceof Throwable) {
                    logger.info("Java exception", (Throwable)obj);
                    break;
                }
                logger.info(obj.toString());
                break;
            }
            case WARN: {
                if (!logger.isWarnEnabled()) {
                    return false;
                }
                if (obj instanceof Throwable) {
                    logger.warn("Java exception", (Throwable)obj);
                    break;
                }
                logger.warn(obj.toString());
                break;
            }
            case ERROR: 
            case FATAL: {
                if (!logger.isErrorEnabled()) {
                    return false;
                }
                if (obj instanceof Throwable) {
                    logger.error("Java exception", (Throwable)obj);
                    break;
                }
                logger.error(obj.toString());
            }
        }
        if (this.traceCopy != null) {
            StringBuffer stringBuffer = this.traceCopy;
            synchronized (stringBuffer) {
                if (this.traceCopyCapacity > 0 && this.traceCopy.length() > this.traceCopyCapacity) {
                    this.traceCopy.delete(3, this.traceCopyCapacity >> 3);
                    this.traceCopy.setCharAt(0, '.');
                    this.traceCopy.setCharAt(1, '.');
                    this.traceCopy.setCharAt(2, '.');
                }
                this.traceCopy.append(obj);
                this.traceCopy.append('\n');
            }
        }
        return true;
    }

    @Override
    public String copy() {
        if (this.traceCopy == null) {
            return null;
        }
        return this.traceCopy.toString();
    }

    @Override
    public void mark() {
        this.traceCopy = this.traceCopyCapacity > 0 ? new StringBuffer(this.traceCopyCapacity) : new StringBuffer(16384);
    }
}

