/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.gp.crypto;

import de.cardcontact.scdp.gp.GPErrorException;
import de.cardcontact.scdp.gp.GPKey;

public interface ICrypto {
    public static final int DES = 1;
    public static final int DES_CBC = 2;
    public static final int DES_CBC_LP = 3;
    public static final int DES_CBC_P = 4;
    public static final int DES_ECB = 5;
    public static final int DES_ECB_LP = 6;
    public static final int DES_ECB_P = 7;
    public static final int DES_MAC = 8;
    public static final int DES_MAC_EMV = 9;
    public static final int DES_DES2 = 10;
    public static final int ISO9797_METHOD_1 = 11;
    public static final int ISO9797_METHOD_2 = 12;
    public static final int MD5 = 13;
    public static final int RSA = 14;
    public static final int RSA_ISO9796_2 = 15;
    public static final int SHA_1 = 16;
    public static final int EC = 17;
    public static final int ECDSA = 18;
    public static final int ECDH = 19;
    public static final int ECDHC = 20;
    public static final int ECDHP = 21;
    public static final int EC_MULTIPLY_ADD = 22;
    public static final int DSA = 23;
    public static final int SHA_224 = 24;
    public static final int SHA_256 = 25;
    public static final int SHA_384 = 26;
    public static final int SHA_512 = 27;
    public static final int ECDSA_SHA1 = 28;
    public static final int ECDSA_SHA224 = 29;
    public static final int ECDSA_SHA256 = 30;
    public static final int ECDSA_SHA384 = 31;
    public static final int ECDSA_SHA512 = 32;
    public static final int RSA_SHA1 = 33;
    public static final int RSA_SHA224 = 34;
    public static final int RSA_SHA256 = 35;
    public static final int RSA_SHA384 = 36;
    public static final int RSA_SHA512 = 37;
    public static final int RSA_OAEP = 38;
    public static final int RSA_OAEP_SHA224 = 39;
    public static final int RSA_OAEP_SHA256 = 40;
    public static final int RSA_OAEP_SHA384 = 41;
    public static final int RSA_OAEP_SHA512 = 42;
    public static final int RSA_PKCS1 = 43;
    public static final int RSA_PSS = 44;
    public static final int RSA_PSS_SHA1 = 45;
    public static final int RSA_PSS_SHA224 = 46;
    public static final int RSA_PSS_SHA256 = 47;
    public static final int RSA_PSS_SHA384 = 48;
    public static final int RSA_PSS_SHA512 = 49;
    public static final int AES_ECB = 50;
    public static final int AES_CBC = 51;
    public static final int AES_CTR = 52;
    public static final int AES_MAC = 53;
    public static final int AES_CMAC = 54;
    public static final int HMAC_SHA1 = 55;
    public static final int HMAC_SHA256 = 56;
    public static final int HMAC_MD5 = 57;
    public static final int ISO9797_METHOD_1_16 = 58;
    public static final int ISO9797_METHOD_2_16 = 59;
    public static final int ECELGAMAL = 60;
    public static final int HMAC_SHA384 = 61;
    public static final int EC_MULTIPLY_SUB = 62;

    public byte[] encrypt(GPKey var1, int var2, byte[] var3, byte[] var4) throws GPErrorException;

    public byte[] decrypt(GPKey var1, int var2, byte[] var3, byte[] var4) throws GPErrorException;

    public byte[] sign(GPKey var1, int var2, byte[] var3, byte[] var4) throws GPErrorException;

    public boolean verify(GPKey var1, int var2, byte[] var3, byte[] var4, byte[] var5) throws GPErrorException;

    public void deriveKey(GPKey var1, int var2, byte[] var3, GPKey var4) throws GPErrorException;

    public byte[] generateRandom(int var1) throws GPErrorException;

    public void generateKeyPair(int var1, GPKey var2, GPKey var3) throws GPErrorException;

    public byte[] digest(int var1, byte[] var2) throws GPErrorException;
}

