/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.cms;

import de.cardcontact.opencard.service.smartcardhsm.SmartCardHSMKey;
import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.gp.GPKey;
import de.cardcontact.scdp.js.JsX509;
import de.cardcontact.scdp.utils.ArgChecker;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import java.util.List;
import javax.crypto.spec.OAEPParameterSpec;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509ExtensionUtils;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.RecipientInfoGenerator;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.cms.jcajce.JceCMSContentEncryptorBuilder;
import org.bouncycastle.cms.jcajce.JceKeyTransRecipientInfoGenerator;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaAlgorithmParametersConverter;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JsCMSGenerator
extends ScriptableObject {
    private static final long serialVersionUID = 541218970602060992L;
    private CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
    private byte[] data;
    List<X509Certificate> certList = new ArrayList<X509Certificate>();
    List<X509Certificate> recipientList = new ArrayList<X509Certificate>();
    static final String clazzName = "CMSGenerator";
    private int type;
    public static final int SIGNED_DATA = 1;
    public static final int ENVELOPED_DATA = 2;
    public static final int DIGESTED_DATA = 3;
    public static final int ENCRYPTED_DATA = 4;
    public static final int AUTHENTICATED_DATA = 5;

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"CMSGenerator() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 1, 1);
        int type = ArgChecker.getInt((Scriptable)ctorObj, clazzName, args, 0, 0);
        if (type != 1 && type != 2) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, 16, type, "Type not supported yet.");
        }
        JsCMSGenerator generator = new JsCMSGenerator();
        generator.type = type;
        return generator;
    }

    public static void finishInit(Scriptable scope, FunctionObject ctor, Scriptable proto) {
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"TYPE_SIGNED_DATA", (Object)1, (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"TYPE_ENVELOPED_DATA", (Object)2, (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"TYPE_DIGESTED_DATA", (Object)3, (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"TYPE_ENCRYPTED_DATA", (Object)4, (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"TYPE_AUTHENTICATED_DATA", (Object)5, (int)0);
    }

    public static void jsFunction_setDataContent(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        ByteString data = ArgChecker.getByteString(thisObj, clazzName, args, 0, null);
        JsCMSGenerator g = (JsCMSGenerator)thisObj;
        g.data = data.getBytes();
    }

    public static void jsFunction_addCertificate(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof JsX509)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 0, "Argument 0 must be a x509 certificate.");
        }
        JsX509 cert = (JsX509)((Object)args[0]);
        JsCMSGenerator g = (JsCMSGenerator)thisObj;
        try {
            g.certList.add(cert.getCertificate());
        }
        catch (IllegalArgumentException e) {
            GPError.throwAsGPErrorEx(thisObj, 8, 0, e.getLocalizedMessage());
        }
    }

    public static void jsFunction_addRecipient(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof JsX509)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 0, "Argument 0 must be a x509 certificate.");
        }
        JsX509 cert = (JsX509)((Object)args[0]);
        JsCMSGenerator g = (JsCMSGenerator)thisObj;
        try {
            g.recipientList.add(cert.getCertificate());
        }
        catch (IllegalArgumentException e) {
            GPError.throwAsGPErrorEx(thisObj, 8, 0, e.getLocalizedMessage());
        }
    }

    public static void jsFunction_addSigner(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 3, 4);
        if (!(args[0] instanceof GPKey)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 16, "Argument 1 must be a key.");
        }
        GPKey privateKey = (GPKey)((Object)args[0]);
        JsX509 cert = null;
        ByteString keyidentifier = null;
        if (!(args[1] instanceof JsX509)) {
            if (!(args[1] instanceof ByteString)) {
                GPError.throwAsGPErrorEx(thisObj, 16, 16, "Argument 2 must be a x509 certificate or ByteString.");
            }
            keyidentifier = (ByteString)((Object)args[1]);
        } else {
            cert = (JsX509)((Object)args[1]);
        }
        if (args[2] instanceof ByteString) {
            GPError.throwAsGPErrorEx(thisObj, 16, 16, "Passing a digestAlgorithmOID is deprecated. Please use a Java signing algorithm string (e.g. \"SHA256withRSA\") instead");
        }
        String signAlg = ArgChecker.getString(thisObj, clazzName, args, 2, null);
        boolean includeInCMS = ArgChecker.getBoolean(thisObj, clazzName, args, 3, false);
        JsCMSGenerator g = (JsCMSGenerator)thisObj;
        try {
            JcaContentSignerBuilder csb = new JcaContentSignerBuilder(signAlg);
            PrivateKey k = (PrivateKey)privateKey.getJCEKey(null);
            if (k instanceof SmartCardHSMKey) {
                Provider prov = privateKey.getProvider();
                if (prov != null) {
                    csb.setProvider(prov);
                } else {
                    csb.setProvider("SmartCardHSM");
                }
            } else {
                csb.setProvider("BC");
            }
            ContentSigner signer = csb.build(k);
            JcaDigestCalculatorProviderBuilder dcpb = new JcaDigestCalculatorProviderBuilder();
            dcpb.setProvider("BC");
            JcaSignerInfoGeneratorBuilder sigb = new JcaSignerInfoGeneratorBuilder(dcpb.build());
            if (cert != null) {
                g.gen.addSignerInfoGenerator(sigb.build(signer, cert.getCertificate()));
                if (includeInCMS) {
                    g.certList.add(cert.getCertificate());
                }
            } else {
                g.gen.addSignerInfoGenerator(sigb.build(signer, keyidentifier.getBytes()));
            }
        }
        catch (IllegalArgumentException e) {
            GPError.throwAsGPErrorEx(thisObj, 8, 0, e.getLocalizedMessage());
        }
        catch (GeneralSecurityException e) {
            GPError.throwAsGPErrorEx(thisObj, 16, 0, e.getLocalizedMessage());
        }
        catch (OperatorCreationException e) {
            GPError.throwAsGPErrorEx(thisObj, 8, 0, e.getLocalizedMessage());
        }
    }

    private byte[] generateEnvelopedData(ASN1ObjectIdentifier oid) throws InvalidAlgorithmParameterException, IOException, CMSException, CertificateException {
        JcaAlgorithmParametersConverter paramsConverter = new JcaAlgorithmParametersConverter();
        AlgorithmIdentifier algorithmId = paramsConverter.getAlgorithmIdentifier(PKCSObjectIdentifiers.id_RSAES_OAEP, (AlgorithmParameterSpec)OAEPParameterSpec.DEFAULT);
        CMSEnvelopedDataGenerator edGen = new CMSEnvelopedDataGenerator();
        for (X509Certificate cert : this.recipientList) {
            byte[] skid = cert.getExtensionValue(Extension.subjectKeyIdentifier.getId());
            if (skid == null) {
                throw new CertificateException("Certificate has no Subject Key Identifier");
            }
            ASN1Primitive asn1SKID = JcaX509ExtensionUtils.parseExtensionValue((byte[])skid);
            byte[] keyId = ASN1OctetString.getInstance((Object)asn1SKID.getEncoded()).getOctets();
            JceKeyTransRecipientInfoGenerator recipientInfoGen = new JceKeyTransRecipientInfoGenerator(keyId, algorithmId, cert.getPublicKey());
            recipientInfoGen.setProvider("BC");
            edGen.addRecipientInfoGenerator((RecipientInfoGenerator)recipientInfoGen);
        }
        JceCMSContentEncryptorBuilder builder = new JceCMSContentEncryptorBuilder(CMSAlgorithm.AES128_GCM);
        builder.setProvider("BC");
        CMSProcessableByteArray cmsData = oid == null ? new CMSProcessableByteArray(this.data) : new CMSProcessableByteArray(oid, this.data);
        CMSEnvelopedData ed = edGen.generate((CMSTypedData)cmsData, builder.build());
        return ed.getEncoded();
    }

    private byte[] generateSignedData(ASN1ObjectIdentifier oid) throws CertificateEncodingException, CMSException, IOException {
        this.gen.addCertificates((Store)new JcaCertStore(this.certList));
        CMSProcessableByteArray cmsData = oid == null ? new CMSProcessableByteArray(this.data) : new CMSProcessableByteArray(oid, this.data);
        CMSSignedData s = this.gen.generate((CMSTypedData)cmsData, true);
        return s.getEncoded();
    }

    public static ByteString jsFunction_generate(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 1);
        JsCMSGenerator g = (JsCMSGenerator)thisObj;
        ByteString bs = null;
        ByteString contentOID = ArgChecker.getByteString(thisObj, clazzName, args, 0, null);
        ASN1ObjectIdentifier oid = null;
        if (contentOID != null) {
            byte[] v = contentOID.getBytes();
            byte[] b = new byte[2 + v.length];
            b[0] = 6;
            b[1] = (byte)(v.length & 0xFF);
            System.arraycopy(v, 0, b, 2, v.length);
            oid = ASN1ObjectIdentifier.getInstance((Object)b);
        }
        try {
            byte[] result = g.type == 2 ? g.generateEnvelopedData(oid) : g.generateSignedData(oid);
            bs = ByteString.newInstance(thisObj, result);
        }
        catch (CMSException e) {
            GPError.throwAsGPErrorEx(thisObj, 9, 0, e.getLocalizedMessage());
        }
        catch (IOException e) {
            GPError.throwAsGPErrorEx(thisObj, 5, 0, e.getLocalizedMessage());
        }
        catch (CertificateEncodingException e) {
            GPError.throwAsGPErrorEx(thisObj, 9, 0, e.getLocalizedMessage());
        }
        catch (InvalidAlgorithmParameterException e) {
            GPError.throwAsGPErrorEx(thisObj, 5, 0, e.getLocalizedMessage());
        }
        catch (CertificateException e) {
            GPError.throwAsGPErrorEx(thisObj, 5, 0, e.getLocalizedMessage());
        }
        return bs;
    }

    public String getClassName() {
        return clazzName;
    }
}

