/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.gp;

import de.cardcontact.scdp.gp.GPTLV_Generic;
import de.cardcontact.scdp.gp.TLVDataSizeException;
import de.cardcontact.scdp.gp.TagSizeException;

public class GPTLV_L16
extends GPTLV_Generic {
    public GPTLV_L16(int tag, byte[] data) throws TagSizeException, TLVDataSizeException {
        super(tag, data);
        if (tag < 0 || tag >= 65536) {
            throw new TagSizeException("Illegal tag size! L16 supports only two byte tags!");
        }
        if (this.getLengthFieldSizeHelper() == -1) {
            throw new TLVDataSizeException("Illegal data size! L16 supports only two byte length!");
        }
    }

    @Override
    public int getLengthFieldSizeHelper() {
        return 2;
    }

    @Override
    public byte[] encodeLength() {
        int size = this.getLengthFieldSizeHelper();
        byte[] encodedLength = new byte[size];
        encodedLength[0] = (byte)(this.data.length >> 8);
        encodedLength[1] = (byte)(this.data.length & 0xFF);
        return encodedLength;
    }

    @Override
    public byte[] encodeTag() {
        byte[] t = new byte[]{(byte)(this.tag >> 8), (byte)(this.tag & 0xFF)};
        return t;
    }

    @Override
    public int getTagFieldSizeHelper() {
        return 2;
    }
}

