/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.xmldsig;

import de.cardcontact.scdp.gp.GPCrypto;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.gp.GPKey;
import de.cardcontact.scdp.js.GPRuntime;
import de.cardcontact.scdp.js.GPRuntimeHelper;
import de.cardcontact.scdp.utils.ArgChecker;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.DigestMethod;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class JsXMLSignature
extends ScriptableObject {
    private static final long serialVersionUID = -4765973471162810252L;
    static final String clazzName = "XMLSignature";
    static XMLSignatureFactory sigFactory = null;
    private Document document;
    String baseURI;
    ArrayList<Reference> references = null;

    public String getClassName() {
        return clazzName;
    }

    public static void finishInit(Scriptable scope, FunctionObject ctor, Scriptable proto) {
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"INCLUSIVE", (Object)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"INCLUSIVE_WITH_COMMENTS", (Object)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments", (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"EXCLUSIVE", (Object)"http://www.w3.org/2001/10/xml-exc-c14n#", (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"EXCLUSIVE_WITH_COMMENTS", (Object)"http://www.w3.org/2001/10/xml-exc-c14n#WithComments", (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"ENVELOPED", (Object)"http://www.w3.org/2000/09/xmldsig#enveloped-signature", (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"BASE64", (Object)"http://www.w3.org/2000/09/xmldsig#base64", (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"XPATH", (Object)"http://www.w3.org/TR/1999/REC-xpath-19991116", (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"XPATH2", (Object)"http://www.w3.org/2002/06/xmldsig-filter2", (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"XSLT", (Object)"http://www.w3.org/TR/1999/REC-xslt-19991116", (int)0);
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"XMLSignature() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 0, 1);
        if (sigFactory == null) {
            sigFactory = XMLSignatureFactory.getInstance("DOM");
        }
        JsXMLSignature t = new JsXMLSignature();
        if (args.length > 0) {
            String relfilename = ArgChecker.getString((Scriptable)ctorObj, clazzName, args, 0, null);
            GPRuntime gpr = GPRuntimeHelper.getGPRuntime((Scriptable)ctorObj);
            String absfilename = gpr.mapFilename(relfilename, 6);
            if (absfilename == null) {
                GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 23, 1, "File " + relfilename + " not found");
            }
            File f = new File(absfilename);
            File p = new File(f.getParent());
            t.baseURI = p.toURI().toString();
            try {
                t.readSignatureFile(absfilename);
            }
            catch (Exception e) {
                GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 9, 1, "File " + relfilename + " could not be read: " + e.getMessage());
            }
        }
        return t;
    }

    public static void jsFunction_addReference(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 3);
        String uri = ArgChecker.getString(thisObj, clazzName, args, 0, null);
        int digestMech = ArgChecker.getInt(thisObj, clazzName, args, 1, 0);
        String dm = null;
        switch (digestMech) {
            case 16: {
                dm = "http://www.w3.org/2000/09/xmldsig#sha1";
                break;
            }
            case 25: {
                dm = "http://www.w3.org/2001/04/xmlenc#sha256";
                break;
            }
            case 27: {
                dm = "http://www.w3.org/2001/04/xmlenc#sha512";
                break;
            }
            case 13: {
                dm = "http://www.w3.org/2001/04/xmlenc#ripemd160";
                break;
            }
            default: {
                GPError.throwAsGPErrorEx(thisObj, clazzName, 14, digestMech, "Invalid digest mechanism");
            }
        }
        ArrayList<String> tl = new ArrayList<String>();
        if (args.length == 3) {
            if (!(args[2] instanceof NativeArray)) {
                GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 2, "The argument must be of type array");
            }
            NativeArray na = (NativeArray)args[2];
            int i = 0;
            while ((long)i < na.getLength()) {
                Object entry = na.get(i, (Scriptable)na);
                if (!(entry instanceof CharSequence)) {
                    GPError.throwAsGPErrorEx(thisObj, 16, i, "Entry in transformation array is not of type String");
                }
                tl.add(((CharSequence)entry).toString());
                ++i;
            }
        }
        JsXMLSignature t = (JsXMLSignature)thisObj;
        try {
            t.addReference(uri, dm, tl);
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 9, 0, "Error adding reference to signature: " + e.getMessage());
        }
    }

    public static void jsFunction_sign(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 5, 5);
        if (!(args[0] instanceof GPCrypto)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 1, "Argument must be of type Crypto");
        }
        GPCrypto crypto = (GPCrypto)((Object)args[0]);
        String c14n = ArgChecker.getString(thisObj, clazzName, args, 1, null);
        int signMech = ArgChecker.getInt(thisObj, clazzName, args, 2, 0);
        if (!(args[3] instanceof GPKey)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 4, "Argument must be of type Key");
        }
        GPKey priKey = (GPKey)((Object)args[3]);
        GPKey pubKey = (GPKey)((Object)args[4]);
        JsXMLSignature t = (JsXMLSignature)thisObj;
        String mechStr = null;
        switch (signMech) {
            case 33: {
                mechStr = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
                break;
            }
            case 35: {
                mechStr = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256";
                break;
            }
            case 36: {
                mechStr = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha384";
                break;
            }
            case 37: {
                mechStr = "http://www.w3.org/2001/04/xmldsig-more#rsa-sha512";
                break;
            }
            case 28: {
                mechStr = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
                break;
            }
            case 30: {
                mechStr = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha256";
                break;
            }
            case 31: {
                mechStr = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha384";
                break;
            }
            case 32: {
                mechStr = "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha512";
                break;
            }
            default: {
                GPError.throwAsGPErrorEx(thisObj, clazzName, 14, signMech, "Invalid signature mechanism");
            }
        }
        String provider = crypto.getProviderName();
        try {
            t.sign(c14n, provider, mechStr, (PrivateKey)priKey.getJCEKey(provider), (PublicKey)pubKey.getJCEKey(provider));
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "Error signing: " + e.getMessage());
        }
    }

    public static boolean jsFunction_verify(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        if (!(args[0] instanceof GPCrypto)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 1, "Argument must be of type Crypto");
        }
        GPCrypto crypto = (GPCrypto)((Object)args[0]);
        if (!(args[1] instanceof GPKey)) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 16, 2, "Argument must be of type Key");
        }
        GPKey pubKey = (GPKey)((Object)args[1]);
        JsXMLSignature t = (JsXMLSignature)thisObj;
        String provider = crypto.getProviderName();
        boolean result = false;
        try {
            result = t.verify(provider, (PublicKey)pubKey.getJCEKey(provider));
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 5, 0, "Error verifying signature: " + e.getMessage());
        }
        return result;
    }

    public static void jsFunction_saveAs(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        String filename = ArgChecker.getString(thisObj, clazzName, args, 0, null);
        JsXMLSignature t = (JsXMLSignature)thisObj;
        try {
            t.writeSignatureFile(filename);
        }
        catch (Exception e) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 9, 1, "File " + filename + " can not be written: " + e.getMessage());
        }
    }

    private void readSignatureFile(String filename) throws ParserConfigurationException, FileNotFoundException, SAXException, IOException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder builder = dbf.newDocumentBuilder();
        this.document = builder.parse(new FileInputStream(filename));
    }

    private void addReference(String uri, String digestMech, List<String> transformations) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        if (this.references == null) {
            this.references = new ArrayList();
        }
        ArrayList<Transform> tl = new ArrayList<Transform>();
        for (String i : transformations) {
            tl.add(sigFactory.newTransform(i, (TransformParameterSpec)null));
        }
        DigestMethod dm = sigFactory.newDigestMethod(digestMech, null);
        this.references.add(sigFactory.newReference(uri, dm, tl, null, null));
    }

    private void sign(String c14n, String provider, String mech, PrivateKey priKey, PublicKey pubKey) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, KeyException, MarshalException, XMLSignatureException {
        DOMSignContext dsc = new DOMSignContext(priKey, (Node)this.document.getDocumentElement());
        dsc.setBaseURI(this.baseURI);
        Provider p = Security.getProvider(provider);
        dsc.setProperty("org.jcprev.xml.dsig.internal.dom.SignatureProvider", p);
        CanonicalizationMethod can = sigFactory.newCanonicalizationMethod(c14n, (C14NMethodParameterSpec)null);
        SignatureMethod sigMethod = sigFactory.newSignatureMethod(mech, null);
        SignedInfo si = sigFactory.newSignedInfo(can, sigMethod, this.references);
        KeyInfoFactory kif = sigFactory.getKeyInfoFactory();
        KeyValue kv = kif.newKeyValue(pubKey);
        KeyInfo ki = kif.newKeyInfo(Collections.singletonList(kv));
        XMLSignature signature = sigFactory.newXMLSignature(si, ki);
        signature.sign(dsc);
    }

    private boolean verify(String provider, PublicKey pubKey) throws Exception {
        NodeList nl = this.document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl.getLength() == 0) {
            throw new Exception("Cannot find Signature element");
        }
        DOMValidateContext vc = new DOMValidateContext(pubKey, nl.item(0));
        vc.setBaseURI(this.baseURI);
        Provider p = Security.getProvider(provider);
        vc.setProperty("org.jcprev.xml.dsig.internal.dom.SignatureProvider", p);
        XMLSignature signature = sigFactory.unmarshalXMLSignature(vc);
        boolean coreValidity = signature.validate(vc);
        return coreValidity;
    }

    private void writeSignatureFile(String filename) throws IOException, TransformerException {
        FileOutputStream os = new FileOutputStream(filename);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer trans = tf.newTransformer();
        trans.transform(new DOMSource(this.document), new StreamResult(os));
        ((OutputStream)os).close();
    }
}

