/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.js;

import de.cardcontact.opencard.security.IsoCredentialStore;
import de.cardcontact.opencard.security.IsoSecureChannelCredential;
import de.cardcontact.opencard.security.SecureChannel;
import de.cardcontact.opencard.security.SecureChannelCredential;
import de.cardcontact.opencard.service.CardServiceUnexpectedStatusWordException;
import de.cardcontact.opencard.service.StatusWordTable;
import de.cardcontact.opencard.service.isocard.FileSystemSendAPDU;
import de.cardcontact.opencard.service.isocard.IsoFileSystemCardService;
import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.Card;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.js.JsIsoSecureChannel;
import de.cardcontact.scdp.js.SecureChannelCredentialWrapper;
import de.cardcontact.scdp.utils.ArgChecker;
import java.io.FileNotFoundException;
import opencard.core.service.CardServiceException;
import opencard.core.service.CardServiceInvalidCredentialException;
import opencard.core.service.CardServiceOperationFailedException;
import opencard.core.service.InvalidCardChannelException;
import opencard.core.service.SmartCard;
import opencard.core.terminal.CardNotPresentException;
import opencard.core.terminal.CardTerminalException;
import opencard.core.terminal.CommandAPDU;
import opencard.core.terminal.ResponseAPDU;
import opencard.opt.iso.fs.CardFile;
import opencard.opt.iso.fs.CardFilePath;
import opencard.opt.iso.fs.CardFilePathComponent;
import opencard.opt.iso.fs.CardIOException;
import opencard.opt.iso.fs.FileAccessCardService;
import opencard.opt.iso.fs.FileSystemCardService;
import opencard.opt.security.CHVCardService;
import opencard.opt.security.CredentialBag;
import opencard.opt.security.CredentialStore;
import opencard.opt.security.SecurityDomain;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionObject;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JsCardFile
extends ScriptableObject {
    public static final String clazzName = "CardFile";
    JsCardFile parent;
    FileAccessCardService facs;
    FileSystemCardService fscs;
    CHVCardService chvcs;
    CardFile cardfile;
    Card card;
    IsoCredentialStore credentialStore;

    public String getClassName() {
        return clazzName;
    }

    public static void finishInit(Scriptable scope, FunctionObject ctor, Scriptable proto) {
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"SELECT", (Object)new Integer(1), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"READ", (Object)new Integer(2), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"UPDATE", (Object)new Integer(4), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"APPEND", (Object)new Integer(8), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"CREATE", (Object)new Integer(16), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"DELETE", (Object)new Integer(32), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"ACTIVATE", (Object)new Integer(64), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"DEACTIVATE", (Object)new Integer(128), (int)0);
        ScriptableObject.defineProperty((Scriptable)ctor, (String)"ALL", (Object)new Integer(65535), (int)0);
    }

    public Object jsGet_nativeFileAccessCardService() {
        return Context.javaToJS((Object)this.facs, (Scriptable)this);
    }

    public Object jsGet_nativeFileSystemCardService() {
        return Context.javaToJS((Object)this.fscs, (Scriptable)this);
    }

    public Object jsGet_nativeCHVCardService() {
        return Context.javaToJS((Object)this.chvcs, (Scriptable)this);
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"CardFile() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 2, 2);
        JsCardFile jso = new JsCardFile();
        jso.parent = null;
        jso.card = null;
        if (args[0] instanceof JsCardFile) {
            jso.parent = (JsCardFile)((Object)args[0]);
        } else if (args[0] instanceof Card) {
            jso.card = (Card)((Object)args[0]);
        } else {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 16, 0, "Expected either Card or CardFile object as argument");
        }
        String path = ArgChecker.getString((Scriptable)ctorObj, clazzName, args, 1, null);
        try {
            if (jso.parent == null) {
                SmartCard sc = jso.card.getSmartCard();
                jso.facs = (FileAccessCardService)sc.getCardService(FileAccessCardService.class, true);
                jso.fscs = (FileSystemCardService)sc.getCardService(FileSystemCardService.class, true);
                jso.chvcs = (CHVCardService)sc.getCardService(CHVCardService.class, true);
                jso.cardfile = new CardFile(jso.facs, new CardFilePath(path));
                CredentialBag credentialBag = new CredentialBag();
                jso.credentialStore = new IsoCredentialStore();
                credentialBag.addCredentialStore((CredentialStore)jso.credentialStore);
                try {
                    jso.facs.provideCredentials((SecurityDomain)jso.cardfile.getPath(), credentialBag);
                    jso.fscs.provideCredentials((SecurityDomain)jso.cardfile.getPath(), credentialBag);
                }
                catch (CardServiceException e) {
                    GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 3, 0, e.getMessage());
                }
            } else {
                jso.cardfile = path.charAt(0) == '#' ? new CardFile(jso.parent.facs, new CardFilePath(path)) : new CardFile(jso.parent.cardfile, new CardFilePath(path));
                jso.card = jso.parent.card;
                jso.facs = jso.parent.facs;
                jso.fscs = jso.parent.fscs;
                jso.chvcs = jso.parent.chvcs;
                jso.credentialStore = jso.parent.credentialStore;
            }
        }
        catch (CardServiceUnexpectedStatusWordException e) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, 3, e.getSW(), e.getMessage());
        }
        catch (FileNotFoundException e) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 23, 0, "File not found");
        }
        catch (CardTerminalException e) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 3, 0, e.getMessage());
        }
        return jso;
    }

    public ByteString readBinary(int offset, int length) {
        ByteString result = null;
        try {
            result = ByteString.newInstance((Scriptable)this, this.facs.read(this.cardfile.getAbsolutePath(), offset, length));
        }
        catch (CardServiceUnexpectedStatusWordException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 3, e.getSW(), e.getMessage());
        }
        catch (CardServiceException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 17, 0, e.getMessage());
        }
        catch (CardTerminalException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 7, 0, e.getMessage());
        }
        return result;
    }

    public static ByteString jsFunction_readBinary(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 2);
        int offset = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        int length = ArgChecker.getInt(thisObj, clazzName, args, 1, -1);
        return ((JsCardFile)thisObj).readBinary(offset, length);
    }

    public void updateBinary(int offset, ByteString data) {
        try {
            this.facs.write(this.cardfile.getAbsolutePath(), offset, data.getBytes());
        }
        catch (CardServiceUnexpectedStatusWordException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 3, e.getSW(), e.getMessage());
        }
        catch (CardServiceException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 17, 0, e.getMessage());
        }
        catch (CardTerminalException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 7, 0, e.getMessage());
        }
    }

    public static void jsFunction_updateBinary(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        int offset = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        if (!(args[1] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "Argument must be of type ByteString");
        }
        ByteString data = (ByteString)((Object)args[1]);
        ((JsCardFile)thisObj).updateBinary(offset, data);
    }

    public static void jsFunction_writeBinary(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        JsCardFile.jsFunction_updateBinary(cx, thisObj, args, funObj);
    }

    public ByteString readRecord(int record) {
        ByteString result = null;
        try {
            result = ByteString.newInstance((Scriptable)this, this.facs.readRecord(this.cardfile.getAbsolutePath(), record));
        }
        catch (CardServiceUnexpectedStatusWordException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 3, e.getSW(), e.getMessage());
        }
        catch (CardServiceException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 17, 0, e.getMessage());
        }
        catch (CardTerminalException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 7, 0, e.getMessage());
        }
        return result;
    }

    public static ByteString jsFunction_readRecord(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int record = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        return ((JsCardFile)thisObj).readRecord(record);
    }

    public void updateRecord(int record, ByteString data) {
        try {
            this.facs.writeRecord(this.cardfile.getAbsolutePath(), record - 1, data.getBytes());
        }
        catch (CardServiceUnexpectedStatusWordException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 3, e.getSW(), e.getMessage());
        }
        catch (CardServiceException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 17, 0, e.getMessage());
        }
        catch (CardTerminalException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 7, 0, e.getMessage());
        }
    }

    public static void jsFunction_updateRecord(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        int record = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        if (!(args[1] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 1, "Argument must be of type ByteString");
        }
        ByteString data = (ByteString)((Object)args[1]);
        ((JsCardFile)thisObj).updateRecord(record, data);
    }

    public static void jsFunction_writeRecord(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        JsCardFile.jsFunction_updateRecord(cx, thisObj, args, funObj);
    }

    public void appendRecord(ByteString data) {
        try {
            this.facs.appendRecord(this.cardfile.getAbsolutePath(), data.getBytes());
        }
        catch (CardServiceUnexpectedStatusWordException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 3, e.getSW(), e.getMessage());
        }
        catch (CardServiceException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 17, 0, e.getMessage());
        }
        catch (CardTerminalException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 7, 0, e.getMessage());
        }
    }

    public static void jsFunction_appendRecord(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        if (!(args[0] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 0, "Argument must be of type ByteString");
        }
        ByteString data = (ByteString)((Object)args[0]);
        ((JsCardFile)thisObj).appendRecord(data);
    }

    public void createFile(int fdb, ByteString data) {
        try {
            if (this.fscs instanceof IsoFileSystemCardService) {
                ((IsoFileSystemCardService)this.fscs).create(this.cardfile.getAbsolutePath(), (byte)fdb, (byte)0, data.getBytes());
            } else {
                this.fscs.create(this.cardfile.getAbsolutePath(), data.getBytes());
            }
        }
        catch (CardServiceUnexpectedStatusWordException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 3, e.getSW(), e.getMessage());
        }
        catch (CardServiceException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 17, 0, e.getMessage());
        }
        catch (CardTerminalException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 7, 0, e.getMessage());
        }
    }

    public static void jsFunction_createFile(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 2);
        int fdb = ArgChecker.getInt(thisObj, clazzName, args, 1, 0);
        if (!(args[0] instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 0, "Argument must be of type ByteString");
        }
        ByteString data = (ByteString)((Object)args[0]);
        ((JsCardFile)thisObj).createFile(fdb, data);
    }

    public void deleteFile(CardFilePathComponent child, boolean isDF) {
        try {
            if (this.fscs instanceof IsoFileSystemCardService) {
                ((IsoFileSystemCardService)this.fscs).delete(this.cardfile.getAbsolutePath(), child, isDF);
            } else {
                this.fscs.delete(this.cardfile.getAbsolutePath());
            }
        }
        catch (CardServiceUnexpectedStatusWordException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 3, e.getSW(), e.getMessage());
        }
        catch (CardServiceException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 17, 0, e.getMessage());
        }
        catch (CardTerminalException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 7, 0, e.getMessage());
        }
    }

    public static void jsFunction_deleteFile(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 2);
        String fid = ArgChecker.getString(thisObj, clazzName, args, 0, null);
        boolean isDF = ArgChecker.getBoolean(thisObj, clazzName, args, 1, false);
        CardFilePathComponent child = null;
        if (fid != null) {
            try {
                CardFilePath cfp = new CardFilePath(fid);
                if (cfp.numberOfComponents() != 1) {
                    GPError.throwAsGPErrorEx(thisObj, 9, 0, "fileIdentifier must not be a path");
                }
                child = cfp.tail();
            }
            catch (CardIOException e) {
                GPError.throwAsGPErrorEx(thisObj, 17, 0, e.getMessage());
            }
        }
        ((JsCardFile)thisObj).deleteFile(child, isDF);
    }

    public void activateFile() {
        try {
            this.fscs.rehabilitate(this.cardfile.getAbsolutePath());
        }
        catch (CardServiceUnexpectedStatusWordException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 3, e.getSW(), e.getMessage());
        }
        catch (CardServiceException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 17, 0, e.getMessage());
        }
        catch (CardTerminalException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 7, 0, e.getMessage());
        }
    }

    public static void jsFunction_activateFile(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        ((JsCardFile)thisObj).activateFile();
    }

    public void deactivateFile() {
        try {
            this.fscs.invalidate(this.cardfile.getAbsolutePath());
        }
        catch (CardServiceUnexpectedStatusWordException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 3, e.getSW(), e.getMessage());
        }
        catch (CardServiceException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 17, 0, e.getMessage());
        }
        catch (CardTerminalException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 7, 0, e.getMessage());
        }
    }

    public static void jsFunction_deactivateFile(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        ((JsCardFile)thisObj).deactivateFile();
    }

    public ByteString getFCPBytes() {
        byte[] fcp = null;
        fcp = this.cardfile.getHeader();
        if (fcp == null) {
            return null;
        }
        return ByteString.newInstance((Scriptable)this, fcp);
    }

    public static ByteString jsFunction_getFCPBytes(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return ((JsCardFile)thisObj).getFCPBytes();
    }

    public static double jsFunction_getFileID(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return ((JsCardFile)thisObj).cardfile.getFileID() & 0xFFFF;
    }

    public static boolean jsFunction_isDirectory(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return ((JsCardFile)thisObj).cardfile.isDirectory();
    }

    public static boolean jsFunction_isTransparent(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return ((JsCardFile)thisObj).cardfile.isTransparent();
    }

    public static boolean jsFunction_isCyclic(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return ((JsCardFile)thisObj).cardfile.isCyclic();
    }

    public static double jsFunction_getLength(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return ((JsCardFile)thisObj).cardfile.getLength();
    }

    public static double jsFunction_getRecordSize(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return ((JsCardFile)thisObj).cardfile.getRecordSize();
    }

    public static boolean jsFunction_exists(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        CardFilePath cfp = new CardFilePath(ArgChecker.getString(thisObj, clazzName, args, 0, null));
        return ((JsCardFile)thisObj).cardfile.exists(cfp);
    }

    public boolean performCHV(boolean global, int pin, byte[] value) {
        CardFilePath sd = null;
        if (!global) {
            sd = this.cardfile.getPath();
        }
        boolean result = false;
        try {
            result = this.chvcs.verifyPassword((SecurityDomain)sd, pin, value);
        }
        catch (CardServiceUnexpectedStatusWordException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 3, e.getSW(), e.getMessage());
        }
        catch (InvalidCardChannelException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 32, 0, e.getMessage());
        }
        catch (CardNotPresentException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 32, 0, e.getMessage());
        }
        catch (CardTerminalException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 7, 0, e.getMessage());
        }
        catch (CardServiceInvalidCredentialException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 29, 0, e.getMessage());
        }
        catch (CardServiceOperationFailedException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 33, 0, e.getMessage());
        }
        catch (CardServiceException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 3, 0, e.getMessage());
        }
        return result;
    }

    public static boolean jsFunction_performCHV(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 3);
        boolean global = Context.toBoolean((Object)args[0]);
        int pin = ArgChecker.getInt(thisObj, clazzName, args, 1, 0);
        byte[] value = null;
        if (args.length == 3 && args[2] instanceof ByteString) {
            value = ((ByteString)((Object)args[2])).getBytes();
        }
        return ((JsCardFile)thisObj).performCHV(global, pin, value);
    }

    public void setCredential(int accessMode, int usageQualifier, ScriptableObject credential) {
        SecureChannelCredentialWrapper sc;
        CardFilePath path = this.cardfile.getPath();
        if (credential instanceof JsIsoSecureChannel) {
            JsIsoSecureChannel jisc = (JsIsoSecureChannel)credential;
            sc = new IsoSecureChannelCredential(usageQualifier, (SecureChannel)jisc.getIsoSecureChannel());
        } else {
            sc = new SecureChannelCredentialWrapper(usageQualifier, credential);
        }
        this.credentialStore.setSecureChannelCredential((SecurityDomain)path, accessMode, (SecureChannelCredential)sc);
    }

    public static void jsFunction_setCredential(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 3, 3);
        int am = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        int uq = ArgChecker.getInt(thisObj, clazzName, args, 1, 0);
        if (!(args[2] instanceof ScriptableObject)) {
            GPError.throwAsGPErrorEx(thisObj, 16, 3, "Argument must be a JavaScript object");
        }
        ((JsCardFile)thisObj).setCredential(am, uq, (ScriptableObject)args[2]);
    }

    public static Scriptable jsFunction_sendApdu(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 4, 7);
        byte cla = ArgChecker.getByte(thisObj, clazzName, args, 0, (byte)0);
        byte ins = ArgChecker.getByte(thisObj, clazzName, args, 1, (byte)0);
        byte p1 = ArgChecker.getByte(thisObj, clazzName, args, 2, (byte)0);
        byte p2 = ArgChecker.getByte(thisObj, clazzName, args, 3, (byte)0);
        int index = 4;
        ByteString data = null;
        if (args.length > index && args[index] instanceof ByteString) {
            data = (ByteString)((Object)args[index]);
            ++index;
        }
        int le = -1;
        if (args.length > index && args[index] instanceof Number) {
            le = (int)Context.toNumber((Object)args[index]);
            ++index;
        }
        NativeArray validSW = null;
        if (args.length > index && args[index] instanceof NativeArray) {
            validSW = (NativeArray)args[index];
            ++index;
        }
        if (index != args.length) {
            GPError.throwAsGPErrorEx(thisObj, 16, index, "Type of argument does not match");
        }
        JsCardFile jso = (JsCardFile)thisObj;
        return jso.sendApdu(cla, ins, p1, p2, data, le, validSW, 0);
    }

    public static Scriptable jsFunction_sendSecMsgApdu(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 5, 8);
        int usageQualifier = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        byte cla = ArgChecker.getByte(thisObj, clazzName, args, 1, (byte)0);
        byte ins = ArgChecker.getByte(thisObj, clazzName, args, 2, (byte)0);
        byte p1 = ArgChecker.getByte(thisObj, clazzName, args, 3, (byte)0);
        byte p2 = ArgChecker.getByte(thisObj, clazzName, args, 4, (byte)0);
        int index = 5;
        ByteString data = null;
        if (args.length > index && args[index] instanceof ByteString) {
            data = (ByteString)((Object)args[index]);
            ++index;
        }
        int le = -1;
        if (args.length > index && args[index] instanceof Number) {
            le = (int)Context.toNumber((Object)args[index]);
            ++index;
        }
        NativeArray validSW = null;
        if (args.length > index && args[index] instanceof NativeArray) {
            validSW = (NativeArray)args[index];
            ++index;
        }
        if (index != args.length) {
            GPError.throwAsGPErrorEx(thisObj, 16, index, "Type of argument does not match");
        }
        JsCardFile jso = (JsCardFile)thisObj;
        return jso.sendApdu(cla, ins, p1, p2, data, le, validSW, usageQualifier);
    }

    public ByteString sendApdu(byte cla, byte ins, byte p1, byte p2, ByteString data, int le, NativeArray validSW, int usageQualifier) {
        if (!(this.facs instanceof FileSystemSendAPDU)) {
            GPError.throwAsGPErrorEx((Scriptable)this, 17, 0, "Card service does not support sending APDUs directly");
        }
        FileSystemSendAPDU ics = (FileSystemSendAPDU)this.facs;
        byte[] com = Card.encodeApdu((Scriptable)this, cla, ins, p1, p2, data, le);
        CommandAPDU capdu = new CommandAPDU(com);
        ResponseAPDU rapdu = null;
        try {
            rapdu = ics.sendCommandAPDU(this.cardfile.getPath(), capdu, usageQualifier);
        }
        catch (CardServiceUnexpectedStatusWordException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 3, e.getSW(), e.getMessage());
        }
        catch (CardServiceException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 17, 0, e.getMessage());
        }
        catch (CardNotPresentException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 32, 0, e.getMessage());
        }
        catch (CardTerminalException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 7, 0, e.getMessage());
        }
        catch (InvalidCardChannelException e) {
            GPError.throwAsGPErrorEx((Scriptable)this, 32, 0, e.getMessage());
        }
        byte[] resp = rapdu.data();
        int sw = rapdu.sw();
        if (resp == null) {
            resp = new byte[]{};
        }
        ByteString result = ByteString.newInstance((Scriptable)this, resp);
        this.put("response", (Scriptable)this, (Object)result);
        this.put("SW", (Scriptable)this, new Integer(sw));
        this.put("SW1", (Scriptable)this, new Integer(sw >> 8));
        this.put("SW2", (Scriptable)this, new Integer(sw & 0xFF));
        this.put("SWMSG", (Scriptable)this, StatusWordTable.StringForSW((int)sw));
        if (validSW != null) {
            boolean found = false;
            int i = 0;
            while ((long)i < validSW.getLength()) {
                Object entry = validSW.get(i, (Scriptable)validSW);
                if (!(entry instanceof Number)) {
                    GPError.throwAsGPErrorEx((Scriptable)this, 16, i, "Entry in SW array is not of type Number");
                }
                if ((int)Context.toNumber((Object)entry) == sw) {
                    found = true;
                }
                ++i;
            }
            if (!found) {
                GPError.throwAsGPErrorEx((Scriptable)this, 4, sw, "Unexpected " + StatusWordTable.MessageForSW((int)sw) + " received");
            }
        }
        return result;
    }

    public String toString() {
        return this.cardfile.toString();
    }

    public static String jsFunction_toString(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        return ((JsCardFile)thisObj).toString();
    }
}

