/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.gp;

import de.cardcontact.scdp.gp.ApplicationFactory;
import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.Card;
import de.cardcontact.scdp.gp.GPCrypto;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.gp.GPTLV;
import de.cardcontact.scdp.gp.GPXML;
import de.cardcontact.scdp.utils.ArgChecker;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Application
extends ScriptableObject {
    private static final long serialVersionUID = 1544429935342602087L;
    static final String clazzName = "Application";
    ApplicationFactory applicationFactory = null;
    Card card = null;
    GPCrypto crypto = null;
    ScriptableObject dataMapper = null;

    public String getClassName() {
        return clazzName;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"Application() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 1, 6);
        Application appl = new Application();
        appl.initialize(ctx, args, ctorObj);
        return appl;
    }

    public void initialize(Context ctx, Object[] args, Function ctorObj) {
        Scriptable profile = null;
        int i = 0;
        if (args[0] instanceof ApplicationFactory) {
            this.applicationFactory = (ApplicationFactory)((Object)args[0]);
            if (!(args[1] instanceof Scriptable)) {
                GPError.throwAsGPErrorEx((Scriptable)ctorObj, 16, 2, "Argument must be of type Object");
            }
            profile = (Scriptable)args[1];
            i = 2;
        } else if (args[0] instanceof CharSequence) {
            String applProfileName = ArgChecker.getString((Scriptable)ctorObj, clazzName, args, 0, null);
            profile = GPXML.parseApplicationProfile((Scriptable)ctorObj, applProfileName);
            i = 1;
        } else {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, 16, 1, "Argument must be of type String");
        }
        this.put("profile", (Scriptable)this, profile);
        if (i < args.length) {
            if (!(args[i] instanceof ByteString)) {
                GPError.throwAsGPErrorEx((Scriptable)ctorObj, 16, i + 1, "Argument aid must be of type ByteString");
            }
            ByteString aid = (ByteString)((Object)args[i]);
            this.put("aid", (Scriptable)this, (Object)aid);
            ++i;
        }
        if (i < args.length) {
            if (args[i] != null) {
                if (!(args[i] instanceof Card)) {
                    GPError.throwAsGPErrorEx((Scriptable)ctorObj, 16, i + 1, "Argument card must be of type Card");
                }
                this.card = (Card)((Object)args[i]);
                this.put("card", (Scriptable)this, (Object)this.card);
            }
            ++i;
        }
        if (i < args.length) {
            if (!(args[i] instanceof GPCrypto)) {
                GPError.throwAsGPErrorEx((Scriptable)ctorObj, 16, i + 1, "Argument crypto must be of type Crypto");
            }
            this.crypto = (GPCrypto)((Object)args[i]);
            this.put("crypto", (Scriptable)this, (Object)this.crypto);
            ++i;
        }
        if (i < args.length) {
            if (!(args[i] instanceof ScriptableObject)) {
                GPError.throwAsGPErrorEx((Scriptable)ctorObj, 16, i + 1, "Argument dataMapper must be of type Object");
            }
            this.dataMapper = (ScriptableObject)args[i];
            ++i;
        }
        this.setupFunctions((Scriptable)ctorObj);
    }

    public Card getCard() {
        if (this.card == null) {
            Object o = ScriptableObject.getProperty((Scriptable)this, (String)"card");
            if (!(o instanceof Card)) {
                GPError.throwAsGPErrorEx((Scriptable)this, 23, 0, "Can't find associated card object");
            }
            this.card = (Card)((Object)o);
        }
        return this.card;
    }

    public static Scriptable jsFunction_select(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Application appl;
        Object o;
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 3);
        boolean next = ArgChecker.getBoolean(thisObj, clazzName, args, 0, false);
        boolean noData = false;
        int i = 1;
        if (args.length > i && args[i] instanceof Boolean) {
            noData = ArgChecker.getBoolean(thisObj, clazzName, args, i, false);
            ++i;
        }
        Object[] defaultSW = new Object[]{new Integer(36864)};
        NativeArray validSW = (NativeArray)cx.newArray(thisObj, defaultSW);
        if (args.length > i) {
            if (!(args[i] instanceof NativeArray)) {
                GPError.throwAsGPErrorEx(thisObj, 16, i, "Expected Number[] as argument");
            }
            validSW = (NativeArray)args[i];
        }
        if (!((o = ScriptableObject.getProperty((Scriptable)(appl = (Application)thisObj), (String)"aid")) instanceof ByteString)) {
            GPError.throwAsGPErrorEx(thisObj, 23, 0, "Can't find associated aid object");
        }
        ByteString aid = (ByteString)((Object)o);
        o = ScriptableObject.getProperty((Scriptable)appl, (String)"card");
        if (!(o instanceof Card)) {
            GPError.throwAsGPErrorEx(thisObj, 23, 0, "Can't find associated card object");
        }
        Card card = (Card)((Object)o);
        byte p2 = 0;
        int le = 0;
        if (next) {
            p2 = (byte)(p2 | 2);
        }
        if (noData) {
            p2 = (byte)(p2 | 0xC);
            le = -1;
        }
        return card.sendApdu((byte)0, (byte)-92, (byte)4, p2, aid, le, validSW, 0);
    }

    public static Scriptable jsFunction_sendApdu(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Application appl;
        Object o;
        ArgChecker.checkRange(thisObj, clazzName, args, 4, 7);
        byte cla = ArgChecker.getByte(thisObj, clazzName, args, 0, (byte)0);
        byte ins = ArgChecker.getByte(thisObj, clazzName, args, 1, (byte)0);
        byte p1 = ArgChecker.getByte(thisObj, clazzName, args, 2, (byte)0);
        byte p2 = ArgChecker.getByte(thisObj, clazzName, args, 3, (byte)0);
        int index = 4;
        ByteString data = null;
        if (args.length > index && args[index] instanceof ByteString) {
            data = (ByteString)((Object)args[index]);
            ++index;
        }
        int le = -1;
        if (args.length > index && args[index] instanceof Number) {
            le = (int)Context.toNumber((Object)args[index]);
            ++index;
        }
        Object[] defaultSW = new Object[]{new Integer(36864)};
        NativeArray validSW = (NativeArray)cx.newArray(thisObj, defaultSW);
        if (args.length > index && args[index] instanceof NativeArray) {
            validSW = (NativeArray)args[index];
            ++index;
        }
        if (index != args.length) {
            GPError.throwAsGPErrorEx(thisObj, 16, index, "Type of argument does not match");
        }
        if (!((o = ScriptableObject.getProperty((Scriptable)(appl = (Application)thisObj), (String)"card")) instanceof Card)) {
            GPError.throwAsGPErrorEx(thisObj, 23, 0, "Can't find associated card object");
        }
        Card card = (Card)((Object)o);
        return card.sendApdu(cla, ins, p1, p2, data, le, validSW, 65535);
    }

    public void setupKeys(Scriptable scriptFragment) {
        Scriptable keys;
        if (this.applicationFactory == null) {
            return;
        }
        Object o = GPXML.getObject((Scriptable)this, "profile.Key");
        if (!(o instanceof NativeArray)) {
            return;
        }
        if (this.has("key", (Scriptable)this)) {
            Object okey = this.get("key", (Scriptable)this);
            if (!(okey instanceof Scriptable)) {
                GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Existing key property in application instance is not an object");
            }
            keys = (Scriptable)okey;
        } else {
            keys = Context.getCurrentContext().newObject((Scriptable)this);
            this.put("key", (Scriptable)this, keys);
        }
        Scriptable keydefs = (Scriptable)o;
        Scriptable keydecls = (Scriptable)GPXML.getObject(scriptFragment, "KeyDeclaration");
        Object[] list = ((Scriptable)o).getIds();
        for (int i = 0; i < list.length; ++i) {
            String name;
            Scriptable keydef;
            String profileId;
            if (!(list[i] instanceof CharSequence)) {
                GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Invalid key definition in application profile");
            }
            if ((profileId = GPXML.getStringProperty(keydef = (Scriptable)keydefs.get(name = ((CharSequence)list[i]).toString(), (Scriptable)this), "ProfileID", null)) == null) {
                GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "ProfileID missing in key definition in application profile");
            }
            boolean external = GPXML.getBooleanProperty(keydef, "External", false);
            if (keydecls != null && (o = keydecls.get(name, keydecls)) != null && o instanceof Scriptable) {
                Scriptable keydecl = (Scriptable)o;
                external = GPXML.getBooleanProperty(keydecl, "External", external);
            }
            Scriptable key = this.applicationFactory.getKeyForId(profileId);
            keys.put(name, keys, (Object)key);
        }
    }

    public void setupDataElements(Scriptable scriptFragment) {
        Object o = GPXML.getObject((Scriptable)this, "profile.DataElement");
        if (!(o instanceof NativeArray)) {
            return;
        }
        if (this.has("data", (Scriptable)this)) {
            this.delete("data");
        }
        ScriptableObject data = (ScriptableObject)Context.getCurrentContext().newObject((Scriptable)this);
        this.put("data", (Scriptable)this, data);
        Scriptable datadefs = (Scriptable)o;
        Scriptable datadecls = (Scriptable)GPXML.getObject(scriptFragment, "Declaration");
        Object[] list = datadefs.getIds();
        for (int i = 0; i < list.length; ++i) {
            if (!(list[i] instanceof CharSequence)) {
                GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Invalid data element definition in application profile");
            }
            String name = ((CharSequence)list[i]).toString();
            Scriptable datadef = (Scriptable)datadefs.get(name, (Scriptable)this);
            Scriptable datadecl = null;
            o = datadecls.get(name, datadecls);
            if (o != null && o != NOT_FOUND) {
                datadecl = (Scriptable)o;
            }
            Scriptable valueObj = null;
            if (datadef.has("Value", datadef)) {
                valueObj = datadef;
            }
            if (datadecl != null && datadecl.has("Value", datadecl)) {
                valueObj = datadef;
            }
            int length = GPXML.getIntegerProperty(datadef, "Length", -1);
            int encoding = GPXML.getObjectAsToken(datadef, "Encoding", ByteString.encodingList);
            if (encoding != -1) {
                encoding = ByteString.encodingMap[encoding];
            }
            boolean fixedLengthFlag = GPXML.getBooleanProperty(datadef, "FixedLength", false);
            boolean externalFlag = GPXML.getBooleanProperty(datadef, "External", false);
            boolean optionalFlag = GPXML.getBooleanProperty(datadef, "Optional", true);
            boolean updateFlag = GPXML.getBooleanProperty(datadef, "Update", false);
            boolean readWriteFlag = GPXML.getBooleanProperty(datadef, "ReadWrite", false);
            String tag = GPXML.getStringProperty(datadef, "Tag", null);
            int tagNumber = -1;
            if (tag != null) {
                try {
                    tagNumber = Integer.parseInt(tag, 16);
                }
                catch (NumberFormatException e) {
                    GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Value of Tag attribute for data element " + name + " is not a hexadecimal integer");
                }
            }
            int tagEncoding = GPXML.getObjectAsToken(datadef, "TagEncoding", new String[]{"EMV", "DGI", "L16"});
            switch (tagEncoding) {
                case 0: {
                    tagEncoding = 1;
                    break;
                }
                case 1: {
                    tagEncoding = 2;
                    break;
                }
                case 2: {
                    tagEncoding = 3;
                }
            }
            if (tag != null && tagEncoding == -1 || tagEncoding >= 0 && tag == null) {
                GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Attributes Tag and TagEncoding must be both be defined for data element " + name);
            }
            if (datadecl != null) {
                externalFlag = GPXML.getBooleanProperty(datadecl, "External", externalFlag);
                optionalFlag = GPXML.getBooleanProperty(datadecl, "Optional", optionalFlag);
                updateFlag = GPXML.getBooleanProperty(datadecl, "Update", updateFlag);
                readWriteFlag = GPXML.getBooleanProperty(datadecl, "ReadWrite", readWriteFlag);
            }
            if (updateFlag) {
                readWriteFlag = true;
            }
            if (valueObj != null && externalFlag && !optionalFlag) {
                GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Data element can not be external and not optional and defined in the Value attribute for data element " + name);
            }
            Object de = null;
            if (externalFlag && (de = this.getDataElement(name, fixedLengthFlag, length, encoding)) == null && !optionalFlag) {
                GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Required external data element " + name + " not found externally");
            }
            if (de == null && valueObj != null) {
                de = GPXML.getByteString(valueObj);
            }
            if (de == null) {
                de = ByteString.newInstance((Scriptable)this, new byte[0]);
            }
            if (tagEncoding >= 0) {
                Object[] params = new Object[]{new Integer(tagNumber), de, new Integer(tagEncoding)};
                de = Context.getCurrentContext().newObject((Scriptable)this, "TLV", params);
            }
            data.defineProperty(name, de, readWriteFlag ? 0 : 1);
        }
    }

    public void setupFunctions(Scriptable scope) {
        Object o = GPXML.getObject((Scriptable)this, "profile.Function");
        if (!(o instanceof NativeArray)) {
            return;
        }
        Scriptable functions = (Scriptable)o;
        Object[] list = functions.getIds();
        for (int i = 0; i < list.length; ++i) {
            String name;
            Scriptable funcdef;
            if (!(list[i] instanceof CharSequence)) {
                GPError.throwAsGPErrorEx(scope, 9, 0, "Invalid function declaration in application profile");
            }
            if (!((o = (funcdef = (Scriptable)functions.get(name = ((CharSequence)list[i]).toString(), (Scriptable)this)).get("Script", funcdef)) instanceof Function)) {
                GPError.throwAsGPErrorEx(scope, 9, 0, "Missing Script element in function " + name + " in application profile");
            }
            this.defineProperty(name, o, 3);
        }
    }

    public void saveDataElements(Scriptable scriptFragment) {
        Object o = GPXML.getObject((Scriptable)this, "profile.DataElement");
        if (!(o instanceof NativeArray)) {
            return;
        }
        Scriptable datadefs = (Scriptable)o;
        Scriptable datadecls = (Scriptable)GPXML.getObject(scriptFragment, "Declaration");
        o = this.get("data", (Scriptable)this);
        if (!(o instanceof ScriptableObject)) {
            GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Property this.data[] not found");
        }
        ScriptableObject data = (ScriptableObject)o;
        Object[] list = datadefs.getIds();
        for (int i = 0; i < list.length; ++i) {
            int encoding;
            if (!(list[i] instanceof CharSequence)) {
                GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Invalid data element definition in application profile");
            }
            String name = ((CharSequence)list[i]).toString();
            Scriptable datadef = (Scriptable)datadefs.get(name, (Scriptable)this);
            Scriptable datadecl = null;
            o = datadecls.get(name, datadecls);
            if (o != null && o != NOT_FOUND) {
                datadecl = (Scriptable)o;
            }
            if ((encoding = GPXML.getObjectAsToken(datadef, "Encoding", ByteString.encodingList)) != -1) {
                encoding = ByteString.encodingMap[encoding];
            }
            boolean updateFlag = GPXML.getBooleanProperty(datadef, "Update", false);
            if (datadecl != null) {
                updateFlag = GPXML.getBooleanProperty(datadecl, "Update", updateFlag);
            }
            if (!updateFlag) continue;
            o = data.get(name, (Scriptable)data);
            if (o == NOT_FOUND || o == null) {
                GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Data element " + name + " not found in this.data[] or null");
            }
            ByteString bs = null;
            if (o instanceof GPTLV) {
                GPTLV t = (GPTLV)((Object)o);
                Object[] args = new Object[]{};
                bs = (ByteString)((Object)ScriptableObject.callMethod((Scriptable)t, (String)"getValue", (Object[])args));
            } else if (o instanceof ByteString) {
                bs = (ByteString)((Object)o);
            } else {
                GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Type of data element " + name + " is neither ByteString nor TLV");
            }
            this.putDataElement(name, bs, encoding);
        }
    }

    public Scriptable getDataElement(String name, boolean fixedLength, int length, int encoding) {
        if (this.dataMapper == null) {
            return null;
        }
        Object[] param = new Object[]{name, new Boolean(fixedLength), new Integer(length), new Integer(encoding)};
        Object o = ScriptableObject.callMethod((Scriptable)this.dataMapper, (String)"get", (Object[])param);
        if (o == null) {
            return null;
        }
        if (!(o instanceof ByteString)) {
            GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Data mapper get(" + name + ") method must return null or ByteString object");
        }
        return (ByteString)((Object)o);
    }

    public void putDataElement(String name, ByteString bs, int encoding) {
        if (this.dataMapper == null) {
            return;
        }
        Object[] param = new Object[]{name, bs, new Integer(encoding)};
        ScriptableObject.callMethod((Scriptable)this.dataMapper, (String)"put", (Object[])param);
    }

    public static void jsFunction_run(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        String scriptName = ArgChecker.getString(thisObj, clazzName, args, 0, null);
        ((Application)thisObj).run(scriptName);
    }

    public void run(String scriptName) {
        Scriptable fragment = this.getScriptFragment(scriptName);
        this.setupKeys(fragment);
        this.setupDataElements(fragment);
        Object o = fragment.get("Script", (Scriptable)this);
        if (!(o instanceof Function)) {
            GPError.throwAsGPErrorEx((Scriptable)this, 9, 0, "Invalid script fragment");
        }
        Function f = (Function)o;
        Object[] param = new Object[]{};
        f.call(Context.getCurrentContext(), (Scriptable)this, (Scriptable)this, param);
        this.saveDataElements(fragment);
    }

    public Scriptable getScriptFragment(String scriptName) {
        Object o = GPXML.getObject((Scriptable)this, "profile.ScriptFragment");
        if (!(o instanceof NativeArray)) {
            GPError.throwAsGPErrorEx((Scriptable)this, 23, 0, "No script fragments found in application profile");
        }
        if (!((o = ((Scriptable)o).get(scriptName, (Scriptable)this)) instanceof Scriptable) || o == NOT_FOUND) {
            GPError.throwAsGPErrorEx((Scriptable)this, 23, 0, "Script fragment \"" + scriptName + "\" not found in application profile");
        }
        return (Scriptable)o;
    }
}

