/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.utils;

import de.cardcontact.scdp.utils.ByteBuffer;
import java.io.UnsupportedEncodingException;

public class Base64 {
    private static int base64todec(char c) {
        int v = c >= 'A' && c <= 'Z' ? c - 65 : (c >= 'a' && c <= 'z' ? c - 97 + 26 : (c >= '0' && c <= '9' ? c - 48 + 52 : (c == '/' ? 63 : (c == '+' ? 62 : (c == '=' ? 64 : -1)))));
        return v;
    }

    private static char dectobase64(int v) {
        int c = v == 64 ? 61 : (v == 63 ? 47 : (v == 62 ? 43 : (v >= 52 && v <= 61 ? (int)((char)(v - 52 + 48)) : (v >= 26 && v <= 51 ? (int)((char)(v - 26 + 97)) : (int)((char)(v + 65))))));
        return (char)c;
    }

    public static byte[] decode(String str) throws UnsupportedEncodingException {
        ByteBuffer bb = new ByteBuffer(str.length() / 2);
        int padcnt = 0;
        int i = 0;
        int l = str.length();
        while (i < l) {
            int shifter;
            int digit = Base64.base64todec(str.charAt(i));
            if (digit < 0 || digit > 63) {
                ++i;
                continue;
            }
            int akku = 0;
            for (shifter = 18; i < l && shifter >= 0; shifter -= 6, ++i) {
                digit = Base64.base64todec(str.charAt(i));
                if (digit < 0) {
                    throw new UnsupportedEncodingException("Invalid character " + str.charAt(i) + " in Base64 string");
                }
                if (digit < 64) {
                    if (padcnt > 0) {
                        throw new UnsupportedEncodingException("Invalid padding character in Base64 string");
                    }
                    akku |= digit << shifter;
                    continue;
                }
                ++padcnt;
            }
            if (shifter >= 18) continue;
            while (shifter >= 0) {
                ++padcnt;
                shifter -= 6;
            }
            bb.append((byte)(akku >> 16 & 0xFF));
            if (padcnt >= 2) continue;
            bb.append((byte)(akku >> 8 & 0xFF));
            if (padcnt >= 1) continue;
            bb.append((byte)(akku & 0xFF));
        }
        return bb.getBytes();
    }

    public static String encode(byte[] bin, boolean linebreak) {
        int i = 0;
        int l = bin.length;
        StringBuffer sb = new StringBuffer(bin.length);
        while (l > 0) {
            int a0 = bin[i] >> 2 & 0x3F;
            int a1 = bin[i] << 4 & 0x30;
            int a2 = 64;
            int a3 = 64;
            ++i;
            if (--l > 0) {
                a1 |= bin[i] >> 4 & 0xF;
                a2 = bin[i] << 2 & 0x3C;
                ++i;
                if (--l > 0) {
                    a2 |= bin[i] >> 6 & 3;
                    a3 = bin[i] & 0x3F;
                    --l;
                    ++i;
                }
            }
            sb.append(Base64.dectobase64(a0));
            sb.append(Base64.dectobase64(a1));
            sb.append(Base64.dectobase64(a2));
            sb.append(Base64.dectobase64(a3));
            if (!linebreak || i % 48 != 0) continue;
            sb.append('\n');
        }
        return sb.toString();
    }

    public static String encode(byte[] bin) {
        return Base64.encode(bin, false);
    }

    public static String encodeWithLineBreaks(byte[] bin) {
        return Base64.encode(bin, true);
    }
}

