/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.sss;

import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.sss.SecretShare;
import de.cardcontact.scdp.sss.ShamirSecretSharing;
import de.cardcontact.scdp.utils.ArgChecker;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JsShamirSharedSecret
extends ScriptableObject {
    private static final long serialVersionUID = 108104394701810643L;
    public static final String clazzName = "ShamirSharedSecret";
    private BigInteger prime;
    private ArrayList<SecretShare> shares = new ArrayList();

    public String getClassName() {
        return clazzName;
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) {
        if (!inNewExpr) {
            Context.reportError((String)"ShamirSharedSecret() can not be called as function");
        }
        if (args.length < 1) {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 2, args.length, "Too few arguments");
        }
        JsShamirSharedSecret t = new JsShamirSharedSecret();
        if (args[0] instanceof ByteString) {
            t.prime = new BigInteger(1, ((ByteString)((Object)args[0])).getBytes());
        } else if (args[0] instanceof Number) {
            int bits = ((Number)args[0]).intValue();
            SecureRandom random = new SecureRandom();
            t.prime = new BigInteger(bits, 5, random);
        } else {
            GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 16, 1, "Arguments must be ByteString or Number");
        }
        return t;
    }

    private static byte[] stripLeadingZero(byte[] bs) {
        if (bs[0] != 0) {
            return bs;
        }
        byte[] nbs = new byte[bs.length - 1];
        System.arraycopy(bs, 1, nbs, 0, nbs.length);
        return nbs;
    }

    public static void jsFunction_addShare(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        int id = ArgChecker.getInt(thisObj, clazzName, args, 0, -1);
        ByteString bs = ArgChecker.getByteString(thisObj, clazzName, args, 1, null);
        JsShamirSharedSecret t = (JsShamirSharedSecret)thisObj;
        t.shares.add(new SecretShare(BigInteger.valueOf(id), new BigInteger(1, bs.getBytes())));
    }

    public static ByteString jsFunction_reconstructSecret(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsShamirSharedSecret t = (JsShamirSharedSecret)thisObj;
        BigInteger r = ShamirSecretSharing.reconstructSecret(t.shares, t.prime);
        return ByteString.newInstance(thisObj, JsShamirSharedSecret.stripLeadingZero(r.toByteArray()));
    }

    public static ByteString jsFunction_getPrime(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        JsShamirSharedSecret t = (JsShamirSharedSecret)thisObj;
        return ByteString.newInstance(thisObj, JsShamirSharedSecret.stripLeadingZero(t.prime.toByteArray()));
    }

    public static ByteString jsFunction_trimSecret(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        ByteString secret = ArgChecker.getByteString(thisObj, clazzName, args, 0, null);
        BigInteger bi = new BigInteger(1, secret.getBytes());
        JsShamirSharedSecret t = (JsShamirSharedSecret)thisObj;
        bi = bi.mod(t.prime);
        return ByteString.newInstance(thisObj, JsShamirSharedSecret.stripLeadingZero(bi.toByteArray()));
    }

    public static NativeArray jsFunction_createShares(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 3, 3);
        ByteString secret = ArgChecker.getByteString(thisObj, clazzName, args, 0, null);
        int threshold = ArgChecker.getInt(thisObj, clazzName, args, 1, -1);
        int totalshares = ArgChecker.getInt(thisObj, clazzName, args, 2, -1);
        JsShamirSharedSecret t = (JsShamirSharedSecret)thisObj;
        BigInteger bisecret = new BigInteger(1, secret.getBytes());
        if (t.prime.subtract(bisecret).signum() != 1) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 9, 1, "Secret must be smaller than prime");
        }
        if (totalshares < 2) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 9, 1, "At least 2 shares are required");
        }
        if (totalshares < threshold) {
            GPError.throwAsGPErrorEx(thisObj, clazzName, 9, 1, "Threshold can't be larger than number of shares");
        }
        List<SecretShare> shares = ShamirSecretSharing.createShares(new BigInteger(1, secret.getBytes()), threshold, totalshares, t.prime);
        ByteString[] list = new ByteString[shares.size()];
        for (int i = 0; i < shares.size(); ++i) {
            byte[] bs = shares.get(i).getY().toByteArray();
            list[i] = ByteString.newInstance(thisObj, JsShamirSharedSecret.stripLeadingZero(bs));
        }
        return new NativeArray((Object[])list);
    }
}

