/*
 * Decompiled with CFR 0.152.
 */
package de.cardcontact.scdp.gp;

import de.cardcontact.scdp.gp.ByteString;
import de.cardcontact.scdp.gp.GPError;
import de.cardcontact.scdp.gp.GPTLV;
import de.cardcontact.scdp.utils.ArgChecker;
import de.cardcontact.scdp.utils.ByteBuffer;
import de.cardcontact.tlv.ParseBuffer;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class GPTLVList
extends ScriptableObject {
    static final String clazzName = "TLVList";
    private List<GPTLV> entries = new ArrayList<GPTLV>();
    private int encoding;

    public String getClassName() {
        return clazzName;
    }

    public long jsGet_encodingMode() {
        return this.encoding;
    }

    public int jsGet_length() {
        return this.entries.size();
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctorObj, boolean inNewExpr) throws Exception {
        if (!inNewExpr) {
            Context.reportError((String)"TLV() can not be called as function");
        }
        ArgChecker.checkRange((Scriptable)ctorObj, clazzName, args, 2, 2);
        ByteString data = ArgChecker.getByteString((Scriptable)ctorObj, clazzName, args, 0, null);
        int encoding = ArgChecker.getInt((Scriptable)ctorObj, clazzName, args, 1, -1);
        if (encoding != 2 && encoding != 1 && encoding != 3) {
            throw GPError.throwAsGPErrorEx((Scriptable)ctorObj, clazzName, 10, encoding, "Invalid encoding");
        }
        GPTLVList gptlvlist = new GPTLVList();
        ParseBuffer pb = new ParseBuffer(data.getBytes());
        while (pb.hasRemaining()) {
            pb.mark();
            if (pb.get() == 0) break;
            pb.reset();
            GPTLV tmp = GPTLV.newInstance((Scriptable)ctorObj, pb, encoding);
            gptlvlist.entries.add(tmp);
        }
        gptlvlist.encoding = encoding;
        return gptlvlist;
    }

    public static GPTLV jsFunction_index(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int index = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        GPTLVList tlvlist = (GPTLVList)thisObj;
        GPTLV tlv = null;
        try {
            tlv = tlvlist.entries.get(index);
        }
        catch (IndexOutOfBoundsException ae) {
            GPError.throwAsGPErrorEx(thisObj, thisObj.getClassName(), 11, index, "Index is out of bounds!");
        }
        return tlv;
    }

    public static void jsFunction_append(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ByteString value;
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 2);
        GPTLVList tlvlist = (GPTLVList)thisObj;
        GPTLV tlv = null;
        if (args[0] instanceof ByteString) {
            ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
            value = ArgChecker.getByteString(thisObj, clazzName, args, 0, null);
            tlv = GPTLV.newInstance(thisObj, value.bs, tlvlist.encoding);
        } else if (args[0] instanceof GPTLV) {
            ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
            tlv = (GPTLV)((Object)args[0]);
        } else if (args[0] instanceof Number) {
            ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
            value = ArgChecker.getByteString(thisObj, clazzName, args, 1, null);
            Object[] arguments = new Object[]{args[0], value, new Integer(tlvlist.encoding)};
            tlv = (GPTLV)cx.newObject(thisObj, "TLV", arguments);
        } else {
            GPError.throwAsGPErrorEx(thisObj, thisObj.getClassName(), 16, 16, "Argument type is invalid!");
        }
        for (int i = 0; i < tlvlist.entries.size(); ++i) {
            GPTLV tmp = tlvlist.entries.get(i);
            if (tmp.jsFunction_getTag() != tlv.jsFunction_getTag()) continue;
            GPError.throwAsGPErrorEx(thisObj, thisObj.getClassName(), 21, (int)tlv.jsFunction_getTag(), "The specified tag already exists!");
        }
        tlvlist.entries.add(tlv);
    }

    public static void jsFunction_appendValue(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        GPTLVList tlvlist = (GPTLVList)thisObj;
        GPTLV tlv = null;
        int tag = ArgChecker.getInt(thisObj, clazzName, args, 0, -1);
        ByteString value = ArgChecker.getByteString(thisObj, clazzName, args, 1, null);
        for (int i = 0; i < tlvlist.entries.size(); ++i) {
            GPTLV tmp = tlvlist.entries.get(i);
            if (tmp.jsFunction_getTag() != (double)tag) continue;
            tlv = tmp;
            break;
        }
        if (tlv == null) {
            GPError.throwAsGPErrorEx(thisObj, thisObj.getClassName(), 15, tag, "The specified tag does not exist!");
        }
        byte[] old_data = tlv.getInternal_tlv().data;
        byte[] new_data = value.bs;
        byte[] data = new byte[old_data.length + new_data.length];
        System.arraycopy(old_data, 0, data, 0, old_data.length);
        System.arraycopy(new_data, 0, data, old_data.length, new_data.length);
        tlv.getInternal_tlv().data = data;
    }

    public static void jsFunction_appendValueIndex(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        GPTLVList tlvlist = (GPTLVList)thisObj;
        GPTLV tlv = null;
        int index = ArgChecker.getInt(thisObj, clazzName, args, 0, -1);
        ByteString value = ArgChecker.getByteString(thisObj, clazzName, args, 1, null);
        try {
            tlv = tlvlist.entries.get(index);
        }
        catch (IndexOutOfBoundsException ae) {
            GPError.throwAsGPErrorEx(thisObj, thisObj.getClassName(), 11, index, "Index is out of bounds!");
        }
        byte[] old_data = tlv.getInternal_tlv().data;
        byte[] new_data = value.bs;
        byte[] data = new byte[old_data.length + new_data.length];
        System.arraycopy(old_data, 0, data, 0, old_data.length);
        System.arraycopy(new_data, 0, data, old_data.length, new_data.length);
        tlv.getInternal_tlv().data = data;
    }

    public static void jsFunction_deleteByIndex(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        GPTLVList tlvlist = (GPTLVList)thisObj;
        int index = ArgChecker.getInt(thisObj, clazzName, args, 0, -1);
        try {
            tlvlist.entries.remove(index);
        }
        catch (IndexOutOfBoundsException ae) {
            GPError.throwAsGPErrorEx(thisObj, thisObj.getClassName(), 11, index, "Index is out of bounds!");
        }
    }

    public static void jsFunction_deleteByTag(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        GPTLVList tlvlist = (GPTLVList)thisObj;
        GPTLV tlv = null;
        int tag = ArgChecker.getInt(thisObj, clazzName, args, 0, -1);
        int index = 0;
        for (index = 0; index < tlvlist.entries.size(); ++index) {
            GPTLV tmp = tlvlist.entries.get(index);
            if (tmp.jsFunction_getTag() != (double)tag) continue;
            tlv = tmp;
            break;
        }
        if (tlv == null) {
            GPError.throwAsGPErrorEx(thisObj, thisObj.getClassName(), 22, tag, "The specified tag does not exist!");
        }
        tlvlist.entries.remove(index);
    }

    public static GPTLV jsFunction_find(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int tag = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        GPTLVList tlvlist = (GPTLVList)thisObj;
        GPTLV tlv = null;
        for (int i = 0; i < tlvlist.entries.size(); ++i) {
            GPTLV tmp = tlvlist.entries.get(i);
            if (tmp.jsFunction_getTag() != (double)tag) continue;
            tlv = tmp;
            break;
        }
        return tlv;
    }

    public static double jsFunction_findIndex(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        int index;
        ArgChecker.checkRange(thisObj, clazzName, args, 1, 1);
        int tag = ArgChecker.getInt(thisObj, clazzName, args, 0, 0);
        GPTLVList tlvlist = (GPTLVList)thisObj;
        GPTLV tlv = null;
        for (index = 0; index < tlvlist.entries.size(); ++index) {
            GPTLV tmp = tlvlist.entries.get(index);
            if (tmp.jsFunction_getTag() != (double)tag) continue;
            tlv = tmp;
            break;
        }
        return tlv != null ? (double)index : -1.0;
    }

    public static void jsFunction_updateValue(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        GPTLVList tlvlist = (GPTLVList)thisObj;
        GPTLV tlv = null;
        int tag = ArgChecker.getInt(thisObj, clazzName, args, 0, -1);
        ByteString value = ArgChecker.getByteString(thisObj, clazzName, args, 1, null);
        for (int i = 0; i < tlvlist.entries.size(); ++i) {
            GPTLV tmp = tlvlist.entries.get(i);
            if (tmp.jsFunction_getTag() != (double)tag) continue;
            tlv = tmp;
            break;
        }
        if (tlv == null) {
            GPError.throwAsGPErrorEx(thisObj, thisObj.getClassName(), 15, tag, "The specified tag does not exist!");
        }
        tlv.getInternal_tlv().data = value.bs;
    }

    public static void jsFunction_updateValueIndex(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 2, 2);
        GPTLVList tlvlist = (GPTLVList)thisObj;
        GPTLV tlv = null;
        int index = ArgChecker.getInt(thisObj, clazzName, args, 0, -1);
        ByteString value = ArgChecker.getByteString(thisObj, clazzName, args, 1, null);
        try {
            tlv = tlvlist.entries.get(index);
        }
        catch (IndexOutOfBoundsException ae) {
            GPError.throwAsGPErrorEx(thisObj, thisObj.getClassName(), 11, index, "Index is out of bounds!");
        }
        tlv.getInternal_tlv().data = value.bs;
    }

    public static ByteString jsFunction_toByteString(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        ArgChecker.checkRange(thisObj, clazzName, args, 0, 0);
        GPTLVList tlvlist = (GPTLVList)thisObj;
        ByteBuffer bb = new ByteBuffer();
        for (int i = 0; i < tlvlist.entries.size(); ++i) {
            GPTLV tmp = tlvlist.entries.get(i);
            bb.append(tmp.jsFunction_getTLV().bs);
        }
        return ByteString.newInstance(thisObj, bb.getBytes());
    }

    public String jsFunction_toString() {
        Object s = "";
        for (int i = 0; i < this.entries.size(); ++i) {
            GPTLV tmp = this.entries.get(i);
            s = (String)s + ((Object)((Object)tmp)).toString() + "\n";
        }
        return s;
    }
}

